/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.registry.checkin;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.synchronization.SynchronizationException;
import org.wso2.carbon.registry.synchronization.UserInputCallback;
import org.wso2.carbon.registry.synchronization.Utils;
import org.wso2.carbon.registry.synchronization.message.MessageCode;
import org.wso2.carbon.registry.synchronization.operation.CheckInCommand;
import org.wso2.registry.checkin.ClientOptions;
import org.wso2.registry.checkin.ClientUtils;
import org.wso2.registry.checkin.DefaultUserInputCallback;
import org.wso2.registry.checkin.UserInputCode;

public class Checkin {
    private CheckInCommand checkInCommand = null;
    private ClientOptions clientOptions = null;
    private String registryUrl = null;

    public Checkin(ClientOptions clientOptions) throws SynchronizationException {
        this.checkInCommand = new CheckInCommand(clientOptions.getOutputFile(), clientOptions.getWorkingLocation(), clientOptions.getUserUrl(), clientOptions.getUsername(), true, true, false);
        this.clientOptions = clientOptions;
        String url = clientOptions.getUserUrl();
        String startingDir = clientOptions.getWorkingLocation();
        if (url != null) {
            this.registryUrl = Utils.getRegistryUrl((String)url);
        } else {
            OMElement metaOMElement = Utils.getMetaOMElement((String)startingDir);
            if (metaOMElement == null) {
                throw new SynchronizationException(MessageCode.CHECKOUT_BEFORE_UPDATE);
            }
            this.registryUrl = metaOMElement.getAttributeValue(new QName("registryUrl"));
        }
    }

    public void execute() throws SynchronizationException {
        this.execute(ClientUtils.newRegistry(this.registryUrl, this.clientOptions.getUsername(), this.clientOptions.getPassword(), this.clientOptions.getTenantId(), this.clientOptions.getType()));
    }

    public void execute(Registry registry) throws SynchronizationException {
        UserInputCode inputCode = UserInputCode.YES;
        if (this.clientOptions.isInteractive()) {
            inputCode = ClientUtils.confirmMessage(this.clientOptions, MessageCode.CHECK_IN_RESOURCES_CONFIRMATION, null, "checkIn");
        }
        if (inputCode == UserInputCode.YES) {
            this.checkInCommand.execute(registry, (UserInputCallback)new DefaultUserInputCallback(this.clientOptions));
            if (this.clientOptions.getOutputFile() == null) {
                ClientUtils.printMessage(this.clientOptions, MessageCode.TRANSMIT_SUCCESS, new String[]{this.checkInCommand.getSentCount() + ""});
            }
            ClientUtils.printMessage(this.clientOptions, MessageCode.SUCCESS);
        } else {
            ClientUtils.printMessage(this.clientOptions, MessageCode.CHECK_IN_OPERATION_ABORTED);
        }
    }
}

