/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.registry.checkin;

import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.synchronization.SynchronizationException;
import org.wso2.carbon.registry.synchronization.UserInputCallback;
import org.wso2.carbon.registry.synchronization.Utils;
import org.wso2.carbon.registry.synchronization.message.MessageCode;
import org.wso2.carbon.registry.synchronization.operation.CheckOutCommand;
import org.wso2.registry.checkin.ClientOptions;
import org.wso2.registry.checkin.ClientUtils;
import org.wso2.registry.checkin.DefaultUserInputCallback;

public class Checkout {
    private CheckOutCommand checkOutCommand = null;
    private ClientOptions clientOptions = null;
    private String registryUrl = null;

    public int getAddedCount() {
        return this.checkOutCommand.getAddedCount();
    }

    public int getOverwrittenCount() {
        return this.checkOutCommand.getOverwrittenCount();
    }

    public int getNonOverwrittenCount() {
        return this.checkOutCommand.getNonOverwrittenCount();
    }

    public Checkout(ClientOptions clientOptions) throws SynchronizationException {
        this.checkOutCommand = new CheckOutCommand(clientOptions.getOutputFile(), clientOptions.getWorkingLocation(), clientOptions.getUserUrl(), clientOptions.getUsername(), true);
        this.checkOutCommand.setDumpLite(clientOptions.isDumpLite());
        this.clientOptions = clientOptions;
        String url = clientOptions.getUserUrl();
        if (url == null) {
            throw new SynchronizationException(MessageCode.CO_PATH_MISSING);
        }
        this.registryUrl = Utils.getRegistryUrl((String)url);
    }

    public void execute() throws SynchronizationException {
        this.execute(ClientUtils.newRegistry(this.registryUrl, this.clientOptions.getUsername(), this.clientOptions.getPassword(), this.clientOptions.getTenantId(), this.clientOptions.getType()));
    }

    public void execute(Registry registry) throws SynchronizationException {
        this.checkOutCommand.execute(registry, (UserInputCallback)new DefaultUserInputCallback(this.clientOptions));
        if (this.clientOptions.getOutputFile() == null) {
            if (this.checkOutCommand.getAddedCount() > 0) {
                ClientUtils.printMessage(this.clientOptions, MessageCode.ADDED_SUCCESS, new String[]{this.checkOutCommand.getAddedCount() + ""});
            } else if (this.checkOutCommand.getAddedCount() == 0) {
                ClientUtils.printMessage(this.clientOptions, MessageCode.NO_FILES_ADDED);
            }
            if (this.checkOutCommand.getOverwrittenCount() > 0) {
                ClientUtils.printMessage(this.clientOptions, MessageCode.OVERWRITTEN_FINAL, new String[]{this.checkOutCommand.getOverwrittenCount() + ""});
            }
            if (this.checkOutCommand.getNonOverwrittenCount() > 0) {
                ClientUtils.printMessage(this.clientOptions, MessageCode.NON_OVERWRITTEN_FINAL, new String[]{this.checkOutCommand.getNonOverwrittenCount() + ""});
            }
        }
        ClientUtils.printMessage(this.clientOptions, MessageCode.SUCCESS);
    }
}

