/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.registry.checkin;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.synchronization.SynchronizationException;
import org.wso2.carbon.registry.synchronization.message.MessageCode;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.registry.checkin.Add;
import org.wso2.registry.checkin.Checkin;
import org.wso2.registry.checkin.Checkout;
import org.wso2.registry.checkin.ClientOptions;
import org.wso2.registry.checkin.ClientUtils;
import org.wso2.registry.checkin.DefaultUserInteractor;
import org.wso2.registry.checkin.Delete;
import org.wso2.registry.checkin.PropDelete;
import org.wso2.registry.checkin.PropSet;
import org.wso2.registry.checkin.Status;
import org.wso2.registry.checkin.Update;

public class Client {
    private static final Log log = LogFactory.getLog(Client.class);
    public static final int CHECKOUT = 1;
    public static final int CHECK_IN = 2;
    public static final int UPDATE = 3;
    public static final int ADD = 4;
    public static final int DELETE = 5;
    public static final int PROPSET = 6;
    public static final int PROPDELETE = 7;
    public static final int STATUS = 8;
    ClientOptions clientOptions;

    public Client() {
        this(new ClientOptions());
    }

    public Client(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public void start(String[] arguments) throws Exception {
        Client.initializeLog4j();
        DefaultUserInteractor userInteractor = new DefaultUserInteractor();
        this.clientOptions.setUserInteractor(userInteractor);
        try {
            this.execute(arguments);
        }
        catch (SynchronizationException e) {
            MessageCode exceptionMsgCode = e.getCode();
            String[] parameters = e.getParameters();
            String msg = userInteractor.showMessage(exceptionMsgCode, parameters);
            log.error((Object)msg, (Throwable)e);
        }
    }

    public void execute(String[] arguments) throws Exception {
        int operation = -1;
        if (arguments.length == 0) {
            throw new SynchronizationException(MessageCode.NO_OPTIONS_PROVIDED);
        }
        if (arguments.length == 1 && arguments[0].equals("-h")) {
            ClientUtils.printMessage(this.clientOptions, MessageCode.HELP);
            return;
        }
        for (int i = 0; i < arguments.length; ++i) {
            block50: {
                String targetResource;
                block54: {
                    block53: {
                        String url;
                        block52: {
                            block51: {
                                if (operation != -1) break block50;
                                if (!arguments[i].equals("checkout") && !arguments[i].equals("co")) break block51;
                                if (arguments.length <= i) {
                                    throw new SynchronizationException(MessageCode.CO_PATH_MISSING);
                                }
                                if (arguments.length - 1 == ++i) {
                                    throw new SynchronizationException(MessageCode.CO_PATH_MISSING);
                                }
                                url = arguments[i];
                                this.clientOptions.setUserUrl(url);
                                operation = 1;
                                break block50;
                            }
                            if (!arguments[i].equals("ci") && !arguments[i].equals("checkin")) break block52;
                            operation = 2;
                            if (arguments.length <= i + 1) break block50;
                            url = arguments[i + 1];
                            if (url.startsWith("http") || url.startsWith("/")) {
                                this.clientOptions.setUserUrl(url);
                                ++i;
                            }
                            if (arguments[i + 1].startsWith("-")) break block50;
                            this.clientOptions.setWorkingLocation(arguments[i + 1]);
                            ++i;
                            break block50;
                        }
                        if (!arguments[i].equals("up") && !arguments[i].equals("update")) break block53;
                        operation = 3;
                        if (arguments.length > i + 1 && ((url = arguments[i + 1]).startsWith("http") || url.startsWith("/"))) {
                            this.clientOptions.setUserUrl(url);
                            ++i;
                        }
                        break block50;
                    }
                    if (!arguments[i].equals("add")) break block54;
                    operation = 4;
                    if (arguments.length <= i + 1) break block50;
                    targetResource = arguments[i + 1];
                    this.clientOptions.setTargetResource(targetResource);
                    if (arguments.length <= ++i + 1 || !"--mediatype".equals(arguments[i + 1])) break block50;
                    this.clientOptions.setMediatype(arguments[i + 2]);
                    i += 2;
                    break block50;
                }
                if (arguments[i].equals("delete") || arguments[i].equals("del")) {
                    operation = 5;
                    if (arguments.length > i + 1) {
                        targetResource = arguments[i + 1];
                        this.clientOptions.setTargetResource(targetResource);
                        break;
                    }
                } else {
                    if (arguments[i].equals("propset") || arguments[i].equals("pset")) {
                        operation = 6;
                        if (arguments.length > i + 1) {
                            targetResource = arguments[++i];
                            this.clientOptions.setTargetResource(targetResource);
                        }
                        HashMap<String, String> propertyMap = new HashMap<String, String>();
                        while (i < arguments.length - 1) {
                            String propertyKey = arguments[++i];
                            String propertyValue = arguments[++i];
                            propertyMap.put(propertyKey, propertyValue);
                        }
                        this.clientOptions.setProperties(propertyMap);
                        break;
                    }
                    if (arguments[i].equals("propdelete") || arguments[i].equals("pdel")) {
                        operation = 7;
                        if (arguments.length > i + 1) {
                            targetResource = arguments[++i];
                            this.clientOptions.setTargetResource(targetResource);
                        }
                        HashSet<String> propertySet = new HashSet<String>();
                        while (i < arguments.length - 1) {
                            propertySet.add(arguments[++i]);
                        }
                        this.clientOptions.setDeletedProperties(propertySet);
                        break;
                    }
                    if (arguments[i].equals("status")) {
                        operation = 8;
                        if (arguments.length > i + 1) {
                            targetResource = arguments[i + 1];
                            this.clientOptions.setTargetResource(targetResource);
                            break;
                        }
                    }
                }
            }
            if (arguments[i].equals("-u") || arguments[i].equals("--user")) {
                if (arguments.length - 1 == i) {
                    throw new SynchronizationException(MessageCode.USERNAME_MISSING);
                }
                String username = arguments[++i];
                this.clientOptions.setUsername(username);
            }
            if (arguments[i].equals("-p") || arguments[i].equals("--password")) {
                if (arguments.length - 1 == i) {
                    throw new SynchronizationException(MessageCode.PASSWORD_MISSING);
                }
                String password = arguments[++i];
                this.clientOptions.setPassword(password);
            }
            if (arguments[i].equals("-l") || arguments[i].equals("--location")) {
                String workingLocation;
                File workingFile;
                if (arguments.length - 1 == i) {
                    throw new SynchronizationException(MessageCode.WORKING_DIR_MISSING);
                }
                if (!(workingFile = new File(workingLocation = arguments[++i])).exists()) {
                    workingFile.mkdirs();
                }
                this.clientOptions.setWorkingLocation(workingLocation);
            }
            if (arguments[i].equals("-f") || arguments[i].equals("--filename")) {
                if (arguments.length - 1 == i) {
                    throw new SynchronizationException(MessageCode.DUMP_FILE_MISSING);
                }
                String outputFile = arguments[++i];
                this.clientOptions.setOutputFile(outputFile);
            }
            if (arguments[i].equals("-i") || arguments[i].equals("--interactive")) {
                this.clientOptions.setInteractive(true);
            }
            if (arguments[i].equals("-t") || arguments[i].equals("--type")) {
                if (arguments.length - 1 == i) {
                    throw new SynchronizationException(MessageCode.REGISTRY_TYPE_MISSING);
                }
                String type = arguments[++i].toUpperCase();
                this.clientOptions.setType(ClientOptions.RegistryType.valueOf(type));
            }
            if (!arguments[i].equals("--tenant") || arguments.length - 1 == i) continue;
            this.clientOptions.setTenantId(Integer.parseInt(arguments[++i]));
        }
        if (operation == -1) {
            throw new SynchronizationException(MessageCode.OPERATION_NOT_FOUND);
        }
        if (!(this.clientOptions.getUsername() != null && !this.clientOptions.getUsername().equals("") || operation != 2 && operation != 1 && operation != 3)) {
            throw new SynchronizationException(MessageCode.USERNAME_NOT_PROVIDED);
        }
        try {
            ClientUtils.setSystemProperties();
        }
        catch (Exception e) {
            throw new Exception("Faild to set system properties", e);
        }
        if (null != this.clientOptions.getUserUrl() && this.clientOptions.getUserUrl().startsWith("/")) {
            CarbonContext.getThreadLocalCarbonContext();
        }
        if (operation == 1) {
            Checkout checkout = new Checkout(this.clientOptions);
            checkout.execute();
        } else if (operation == 2) {
            new Checkin(this.clientOptions).execute();
        } else if (operation == 3) {
            Update update = new Update(this.clientOptions);
            update.execute();
        } else if (operation == 4) {
            Add add = new Add(this.clientOptions);
            add.execute();
        } else if (operation == 5) {
            Delete delete = new Delete(this.clientOptions);
            delete.execute();
        } else if (operation == 6) {
            PropSet propSet = new PropSet(this.clientOptions);
            propSet.execute();
        } else if (operation == 7) {
            PropDelete propDelete = new PropDelete(this.clientOptions);
            propDelete.execute();
        } else if (operation == 8) {
            Status status = new Status(this.clientOptions);
            status.execute();
        }
    }

    private static void initializeLog4j() {
        String log4jConfFile = "log4j.properties";
        String carbonHome = CarbonUtils.getCarbonHome();
        if (carbonHome != null) {
            log4jConfFile = carbonHome + "/lib/checkin-client/log4j.properties";
        }
        if (new File(log4jConfFile).exists()) {
            PropertyConfigurator.configure((String)log4jConfFile);
        }
    }
}

