/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.registry.checkin;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.registry.app.RemoteRegistry;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.internal.RegistryCoreServiceComponent;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.synchronization.SynchronizationException;
import org.wso2.carbon.registry.synchronization.Utils;
import org.wso2.carbon.registry.synchronization.message.MessageCode;
import org.wso2.carbon.registry.ws.client.registry.WSRegistryServiceClient;
import org.wso2.carbon.user.core.common.DefaultRealmService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.registry.checkin.ClientOptions;
import org.wso2.registry.checkin.UserInputCode;
import org.wso2.registry.checkin.UserInteractor;

public class ClientUtils {
    public static void setSystemProperties() throws Exception {
        String ns = "http://wso2.org/projects/carbon/carbon.xml";
        if (System.getProperty("javax.net.ssl.trustStore") == null) {
            try {
                String type;
                StAXOMBuilder builder = new StAXOMBuilder(System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "conf" + File.separator + "carbon.xml");
                OMElement omElement = builder.getDocumentElement();
                OMElement trustStoreOmElement = omElement.getFirstChildWithName(new QName(ns, "Security")).getFirstChildWithName(new QName(ns, "TrustStore"));
                String location = trustStoreOmElement.getFirstChildWithName(new QName(ns, "Location")).getText();
                if (location == null || "".equals(location)) {
                    throw new Exception("trust store location is can't be null or empty, check the configuration in carbon.xml");
                }
                if (location.contains("${carbon.home}")) {
                    location = System.getProperty("carbon.home") + location.replace("${carbon.home}", "");
                }
                if ((type = trustStoreOmElement.getFirstChildWithName(new QName(ns, "Type")).getText()) == null || "".equals(type)) {
                    throw new Exception("trust store type is can't be null or empty, check the configuration in carbon.xml");
                }
                String password = trustStoreOmElement.getFirstChildWithName(new QName(ns, "Password")).getText();
                if (password == null) {
                    throw new Exception("trust store pasword is can't be null, check the configuration in carbon.xml");
                }
                System.setProperty("javax.net.ssl.trustStore", location);
                System.setProperty("javax.net.ssl.trustStorePassword", password);
                System.setProperty("javax.net.ssl.trustStoreType", type);
                System.setProperty("carbon.repo.write.mode", Boolean.toString(true));
            }
            catch (XMLStreamException e) {
                throw new Exception("Failed to set the client-truststore ", e);
            }
            catch (FileNotFoundException e) {
                throw new Exception(e);
            }
        }
    }

    public static Registry newRegistry(String registryUrl, String username, String password, int tenantId, ClientOptions.RegistryType type) throws SynchronizationException {
        RegistryService registryService;
        DefaultRealmService realmService;
        if (registryUrl != null) {
            try {
                switch (type) {
                    case WS: {
                        ConfigurationContext context = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)(System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "deployment" + File.separator + "client"), (String)ServerConfiguration.getInstance().getFirstProperty("Axis2Config.clientAxis2XmlLocation"));
                        if (registryUrl.endsWith("/")) {
                            registryUrl = registryUrl.substring(0, registryUrl.length() - 1);
                        }
                        String serverUrl = registryUrl.substring(0, registryUrl.lastIndexOf("/")) + "/services/";
                        WSRegistryServiceClient wsRegistryServiceClient = new WSRegistryServiceClient(serverUrl, username, password, context);
                        wsRegistryServiceClient.setTenantId(tenantId);
                        return wsRegistryServiceClient;
                    }
                }
                return new RemoteRegistry(new URL(registryUrl), username, password);
            }
            catch (MalformedURLException e) {
                throw new SynchronizationException(MessageCode.MALFORMED_URL, (Throwable)e, new String[]{" registry url:" + registryUrl});
            }
            catch (RegistryException e) {
                throw new SynchronizationException(MessageCode.ERROR_IN_CONNECTING_REGISTRY, (Throwable)e, new String[]{" registry url:" + registryUrl});
            }
            catch (AxisFault e) {
                throw new SynchronizationException(MessageCode.ERROR_IN_CONNECTING_REGISTRY, (Throwable)e, new String[]{" registry url:" + registryUrl});
            }
        }
        try {
            realmService = new DefaultRealmService(null);
        }
        catch (Exception e) {
            throw new SynchronizationException(MessageCode.REALM_SERVICE_FAILED, (Throwable)e);
        }
        class EmbeddingRegistryCoreServiceComponent
        extends RegistryCoreServiceComponent {
            EmbeddingRegistryCoreServiceComponent() {
            }

            public void setRealmService(RealmService realmService) {
                super.setRealmService(realmService);
            }
        }
        EmbeddingRegistryCoreServiceComponent registryComponent = new EmbeddingRegistryCoreServiceComponent();
        registryComponent.setRealmService((RealmService)realmService);
        try {
            registryService = registryComponent.buildRegistryService();
        }
        catch (Exception e) {
            throw new SynchronizationException(MessageCode.REGISTRY_SERVICE_FAILED, (Throwable)e);
        }
        try {
            return registryService.getRegistry(username, password);
        }
        catch (RegistryException e) {
            throw new SynchronizationException(MessageCode.USER_REGISTRY_FAILED, (Throwable)e);
        }
    }

    public static void printMessage(ClientOptions clientOptions, MessageCode messageCode) {
        UserInteractor userInteractor = clientOptions.getUserInteractor();
        userInteractor.showMessage(messageCode, null);
    }

    public static void printMessage(ClientOptions clientOptions, MessageCode messageCode, String[] parameters) {
        UserInteractor userInteractor = clientOptions.getUserInteractor();
        userInteractor.showMessage(messageCode, parameters);
    }

    public static UserInputCode confirmMessage(ClientOptions clientOptions, MessageCode messageCode, String[] parameters, String context) {
        if (clientOptions.isTesting()) {
            return UserInputCode.YES;
        }
        UserInteractor userInteractor = clientOptions.getUserInteractor();
        return userInteractor.getInput(messageCode, parameters, context);
    }

    public static String getMetaFilePath(String path) throws SynchronizationException {
        File file = new File(path);
        if (file.isDirectory()) {
            return path + File.separator + ".meta" + File.separator + "~" + ".xml";
        }
        String parentDirName = file.getParent();
        return parentDirName + File.separator + ".meta" + File.separator + "~" + Utils.encodeResourceName((String)file.getName()) + ".xml";
    }
}

