/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.registry.checkin;

import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.wso2.carbon.registry.synchronization.message.MessageCode;
import org.wso2.registry.checkin.DefaultMessages;
import org.wso2.registry.checkin.UserInputCode;
import org.wso2.registry.checkin.UserInteractor;

public class DefaultUserInteractor
implements UserInteractor {
    private Map<String, Boolean> yesToAllMap = new HashMap<String, Boolean>();
    private Map<String, Boolean> noToAllMap = new HashMap<String, Boolean>();

    @Override
    public String showMessage(MessageCode msgCode, String[] parameters) {
        String codeMsg = DefaultMessages.getMessageFromCode(msgCode);
        int placeHolderCount = this.derivePlaceHolderCount(codeMsg);
        codeMsg = this.buildMessage(codeMsg, parameters);
        StringBuffer msgStringBuffer = new StringBuffer(codeMsg);
        if (parameters != null) {
            for (int i = placeHolderCount; i < parameters.length; ++i) {
                msgStringBuffer.append("\n").append(parameters[i]);
            }
        }
        String msg = msgStringBuffer.toString();
        System.out.println(msg);
        return msg;
    }

    public int derivePlaceHolderCount(String msg) {
        int count = 0;
        while (msg.indexOf("'?'") >= 0) {
            ++count;
            msg = msg.substring(msg.indexOf("'?'") + "'?'".length());
        }
        return count;
    }

    public String buildMessage(String msg, String[] parameters) {
        int placeHolderIndex;
        int parameterIndex = 0;
        while ((placeHolderIndex = msg.indexOf("'?'")) >= 0) {
            String parameter = parameters[parameterIndex++];
            String remainingMsg = msg.substring(placeHolderIndex + "'?'".length());
            msg = placeHolderIndex == 0 ? parameter + remainingMsg : msg.substring(0, placeHolderIndex) + parameter + remainingMsg;
            placeHolderIndex += parameter.length();
        }
        return msg;
    }

    @Override
    public UserInputCode getInput(MessageCode expectedInputExplanationMsgCode, String[] parameters, String context) {
        if (context != null) {
            if (this.yesToAllMap.get(context) != null && this.yesToAllMap.get(context).booleanValue()) {
                return UserInputCode.YES;
            }
            if (this.noToAllMap.get(context) != null && this.noToAllMap.get(context).booleanValue()) {
                return UserInputCode.NO;
            }
        }
        this.showMessage(expectedInputExplanationMsgCode, parameters);
        Scanner scan = new Scanner(System.in);
        String answer = scan.nextLine();
        if (answer.toUpperCase().equals("Y") || answer.toUpperCase().equals("YES")) {
            return UserInputCode.YES;
        }
        if (answer.toUpperCase().equals("N") || answer.toUpperCase().equals("NO")) {
            return UserInputCode.NO;
        }
        if (answer.toUpperCase().equals("NA")) {
            if (context != null) {
                this.noToAllMap.put(context, true);
            }
            return UserInputCode.NO;
        }
        if (answer.toUpperCase().equals("A")) {
            if (context != null) {
                this.yesToAllMap.put(context, true);
            }
            return UserInputCode.YES;
        }
        return UserInputCode.NO;
    }
}

