/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.registry.checkin;

import java.io.File;
import java.io.FilenameFilter;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.synchronization.SynchronizationException;
import org.wso2.carbon.registry.synchronization.Utils;
import org.wso2.registry.checkin.ClientOptions;

public class Status {
    private ClientOptions clientOptions;
    private List<String> added = new LinkedList<String>();
    private List<String> deleted = new LinkedList<String>();
    private List<String> updated = new LinkedList<String>();
    private Log log = LogFactory.getLog(Status.class);

    public Status(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public void execute() throws SynchronizationException {
        String path = this.clientOptions.getTargetResource() != null ? this.clientOptions.getTargetResource() : this.clientOptions.getWorkingLocation();
        this.printStatusRecursively(path);
    }

    private void printStatusRecursively(String path) throws SynchronizationException {
        File file = new File(path);
        OMElement metaElement = Utils.getMetaOMElement((String)path);
        if (metaElement == null) {
            System.out.println("? " + path);
            return;
        }
        String status = metaElement.getAttributeValue(new QName("status"));
        if (status != null) {
            if (status.equals("added")) {
                this.added.add(path);
                System.out.println("A " + path);
            } else if (status.equals("updated")) {
                this.updated.add(path);
                System.out.println("U " + path);
            } else if (status.equals("deleted")) {
                this.deleted.add(path);
                System.out.println("D " + path);
            }
        } else if (!file.isDirectory()) {
            String metaMd5 = metaElement.getAttributeValue(new QName("md5"));
            if (!Utils.getMD5((File)file).equals(metaMd5)) {
                this.updated.add(path);
                System.out.println("U " + path);
            }
        }
        if (file.isDirectory()) {
            for (String fileName : file.list(new FilenameFilter(){

                @Override
                public boolean accept(File file, String s) {
                    return !".meta".equals(s);
                }
            })) {
                this.printStatusRecursively(path + File.separator + fileName);
            }
        }
    }

    public List<String> getAdded() {
        return this.added;
    }

    public List<String> getDeleted() {
        return this.deleted;
    }

    public List<String> getUpdated() {
        return this.updated;
    }
}

