/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.registry.checkin;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.synchronization.SynchronizationException;
import org.wso2.carbon.registry.synchronization.UserInputCallback;
import org.wso2.carbon.registry.synchronization.Utils;
import org.wso2.carbon.registry.synchronization.message.MessageCode;
import org.wso2.carbon.registry.synchronization.operation.UpdateCommand;
import org.wso2.registry.checkin.ClientOptions;
import org.wso2.registry.checkin.ClientUtils;
import org.wso2.registry.checkin.DefaultUserInputCallback;

public class Update {
    private UpdateCommand updateCommand = null;
    private ClientOptions clientOptions = null;
    private String registryUrl = null;

    public int getAddedCount() {
        return this.updateCommand.getAddedCount();
    }

    public int getUpdatedCount() {
        return this.updateCommand.getUpdatedCount();
    }

    public int getConflictedCount() {
        return this.updateCommand.getConflictedCount();
    }

    public int getDeletedCount() {
        return this.updateCommand.getDeletedCount();
    }

    public int getNotDeletedCount() {
        return this.updateCommand.getNotDeletedCount();
    }

    public Update(ClientOptions clientOptions) throws SynchronizationException {
        this.updateCommand = new UpdateCommand(clientOptions.getOutputFile(), clientOptions.getWorkingLocation(), clientOptions.getUserUrl(), false, clientOptions.getUsername(), true);
        this.updateCommand.setDumpLite(clientOptions.isDumpLite());
        this.clientOptions = clientOptions;
        String url = clientOptions.getUserUrl();
        String startingDir = clientOptions.getWorkingLocation();
        if (url != null) {
            this.registryUrl = Utils.getRegistryUrl((String)url);
        } else {
            OMElement metaOMElement = Utils.getMetaOMElement((String)startingDir);
            if (metaOMElement == null) {
                throw new SynchronizationException(MessageCode.CHECKOUT_BEFORE_UPDATE);
            }
            this.registryUrl = metaOMElement.getAttributeValue(new QName("registryUrl"));
        }
    }

    public void execute() throws SynchronizationException {
        this.execute(ClientUtils.newRegistry(this.registryUrl, this.clientOptions.getUsername(), this.clientOptions.getPassword(), this.clientOptions.getTenantId(), this.clientOptions.getType()));
    }

    public void execute(Registry registry) throws SynchronizationException {
        this.updateCommand.execute(registry, (UserInputCallback)new DefaultUserInputCallback(this.clientOptions));
        if (this.updateCommand.getAddedCount() > 0) {
            ClientUtils.printMessage(this.clientOptions, MessageCode.ADDED_SUCCESS, new String[]{this.updateCommand.getAddedCount() + ""});
        } else {
            ClientUtils.printMessage(this.clientOptions, MessageCode.NO_FILES_ADDED);
        }
        if (this.updateCommand.getUpdatedCount() > 0) {
            ClientUtils.printMessage(this.clientOptions, MessageCode.UPDATED_SUCCESS, new String[]{this.updateCommand.getUpdatedCount() + ""});
        } else {
            ClientUtils.printMessage(this.clientOptions, MessageCode.NO_FILES_UPDATED);
        }
        if (this.updateCommand.getConflictedCount() > 0) {
            ClientUtils.printMessage(this.clientOptions, MessageCode.CONFLICTED_FAILURE, new String[]{this.updateCommand.getConflictedCount() + ""});
        } else {
            ClientUtils.printMessage(this.clientOptions, MessageCode.NO_FILES_CONFLICTED);
        }
        if (this.updateCommand.getDeletedCount() > 0) {
            ClientUtils.printMessage(this.clientOptions, MessageCode.DELETED_SUCCESS, new String[]{this.updateCommand.getDeletedCount() + ""});
        } else {
            ClientUtils.printMessage(this.clientOptions, MessageCode.NO_FILES_DELETED);
        }
        if (this.updateCommand.getNotDeletedCount() > 0) {
            ClientUtils.printMessage(this.clientOptions, MessageCode.NOT_DELETED_FINAL, new String[]{this.updateCommand.getNotDeletedCount() + ""});
        }
        ClientUtils.printMessage(this.clientOptions, MessageCode.SUCCESS);
    }
}

