/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.registry.checkin.scm;

import java.io.File;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.Commandline;

public class Utils {
    private static final String PASSWORD_ARG = "--password";
    private static final String USERNAME_ARG = "--user";
    private static final String LOCATION_ARG = "--location";

    public static Commandline getCommandLine(ScmProviderRepository repository, String command, ScmFileSet scmFileSet) {
        Commandline cl = new Commandline();
        String carbonHome = System.getenv("CARBON_HOME");
        String executableName = Os.isFamily((String)"windows") ? "checkin-client.bat" : "checkin-client.sh";
        if (carbonHome != null) {
            if (!carbonHome.endsWith(File.separator)) {
                carbonHome = carbonHome + File.separator;
            }
            cl.setExecutable(carbonHome + executableName);
        } else {
            cl.setExecutable(executableName);
        }
        cl.addArguments(new String[]{command, ((ScmProviderRepositoryWithHost)repository).getHost(), USERNAME_ARG, repository.getUser(), PASSWORD_ARG, repository.getPassword(), LOCATION_ARG, scmFileSet.getBasedir().getAbsolutePath()});
        return cl;
    }

    public static String getCommandLineAsString(Commandline cl) {
        String clString = cl.toString();
        int pos = clString.indexOf(PASSWORD_ARG);
        if (pos > 0) {
            String beforePassword = clString.substring(0, pos + PASSWORD_ARG.length() + 1);
            String afterPassword = clString.substring(pos + PASSWORD_ARG.length() + 1);
            afterPassword = afterPassword.substring(afterPassword.indexOf(32));
            if (Os.isFamily((String)"windows")) {
                return beforePassword + "********" + afterPassword;
            }
            return beforePassword + "'********'" + afterPassword;
        }
        return clString;
    }
}

