/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.registry.checkin.scm.checkin;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.wso2.registry.checkin.scm.Utils;
import org.wso2.registry.checkin.scm.checkin.CheckInConsumer;
import org.wso2.registry.checkin.scm.repository.ProviderRepository;

public class CheckInCommand
extends AbstractCheckInCommand {
    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository scmProviderRepository, ScmFileSet scmFileSet, String s, ScmVersion scmVersion) throws ScmException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("executing check-in command...");
        }
        ProviderRepository repository = (ProviderRepository)scmProviderRepository;
        Commandline cl = Utils.getCommandLine((ScmProviderRepository)repository, "ci", scmFileSet);
        CheckInConsumer consumer = new CheckInConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing: " + cl.getWorkingDirectory().getAbsolutePath() + ">>" + Utils.getCommandLineAsString(cl));
        }
        try {
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)err);
            if (exitCode != 0 && this.getLogger().isWarnEnabled()) {
                this.getLogger().warn(err.getOutput());
            }
        }
        catch (CommandLineException e) {
            this.getLogger().error("An error occurred while performing check-in", (Throwable)e);
        }
        return new CheckInScmResult(cl.toString(), consumer.getUpdatedFiles());
    }
}

