/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.registry.checkin.scm.checkout;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.wso2.registry.checkin.scm.Utils;
import org.wso2.registry.checkin.scm.checkout.CheckOutConsumer;
import org.wso2.registry.checkin.scm.repository.ProviderRepository;

public class CheckOutCommand
extends AbstractCheckOutCommand {
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository scmProviderRepository, ScmFileSet scmFileSet, ScmVersion scmVersion, boolean b) throws ScmException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("executing checkout command...");
        }
        ProviderRepository repository = (ProviderRepository)scmProviderRepository;
        Commandline cl = Utils.getCommandLine((ScmProviderRepository)repository, "co", scmFileSet);
        CheckOutConsumer consumer = new CheckOutConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing: " + cl.getWorkingDirectory().getAbsolutePath() + ">>" + Utils.getCommandLineAsString(cl));
        }
        try {
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)err);
            if (exitCode != 0 && this.getLogger().isWarnEnabled()) {
                this.getLogger().warn(err.getOutput());
            }
        }
        catch (CommandLineException e) {
            this.getLogger().error("An error occurred while performing checkout", (Throwable)e);
        }
        return new CheckOutScmResult(cl.toString(), consumer.getUpdatedFiles());
    }
}

