/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.registry.checkin.scm.checkout;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.util.AbstractConsumer;

public class CheckOutConsumer
extends AbstractConsumer {
    private List<ScmFile> updatedFiles = new LinkedList<ScmFile>();

    public CheckOutConsumer(ScmLogger logger) {
        super(logger);
    }

    public void consumeLine(String line) {
        String file;
        ScmFileStatus status;
        char statusSymbol = line.charAt(0);
        switch (statusSymbol) {
            case 'A': {
                status = ScmFileStatus.ADDED;
                file = line.substring(2).trim();
                break;
            }
            case 'O': {
                status = ScmFileStatus.UPDATED;
                file = line.substring(3).trim();
                break;
            }
            default: {
                return;
            }
        }
        if (new File(file).isFile()) {
            this.updatedFiles.add(new ScmFile(file, status));
        }
    }

    public List<ScmFile> getUpdatedFiles() {
        return this.updatedFiles;
    }
}

