/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.registry.checkin.scm.update;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogCommand;
import org.apache.maven.scm.command.update.AbstractUpdateCommand;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.wso2.registry.checkin.scm.Utils;
import org.wso2.registry.checkin.scm.repository.ProviderRepository;
import org.wso2.registry.checkin.scm.update.UpdateConsumer;

public class UpdateCommand
extends AbstractUpdateCommand {
    protected UpdateScmResult executeUpdateCommand(ScmProviderRepository scmProviderRepository, ScmFileSet scmFileSet, ScmVersion scmVersion) throws ScmException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("executing update command...");
        }
        ProviderRepository repository = (ProviderRepository)scmProviderRepository;
        Commandline cl = Utils.getCommandLine((ScmProviderRepository)repository, "up", scmFileSet);
        UpdateConsumer consumer = new UpdateConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing: " + cl.getWorkingDirectory().getAbsolutePath() + ">>" + Utils.getCommandLineAsString(cl));
        }
        try {
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)err);
            if (exitCode != 0 && this.getLogger().isWarnEnabled()) {
                this.getLogger().warn(err.getOutput());
            }
        }
        catch (CommandLineException e) {
            this.getLogger().error("An error occurred while performing update", (Throwable)e);
        }
        return new UpdateScmResult(cl.toString(), consumer.getUpdatedFiles());
    }

    protected ChangeLogCommand getChangeLogCommand() {
        throw new UnsupportedOperationException("This operation is not supported");
    }
}

