/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.registry.checkin.scm.update;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.util.AbstractConsumer;

public class UpdateConsumer
extends AbstractConsumer {
    private List<ScmFile> updatedFiles = new LinkedList<ScmFile>();

    public UpdateConsumer(ScmLogger logger) {
        super(logger);
    }

    public void consumeLine(String line) {
        ScmFileStatus status;
        char statusSymbol = line.charAt(0);
        switch (statusSymbol) {
            case 'A': {
                status = ScmFileStatus.ADDED;
                break;
            }
            case 'D': {
                status = ScmFileStatus.DELETED;
                break;
            }
            case 'C': {
                status = ScmFileStatus.CONFLICT;
                break;
            }
            case 'U': {
                status = ScmFileStatus.UPDATED;
                break;
            }
            default: {
                return;
            }
        }
        String file = line.substring(2).trim();
        if (new File(file).isFile()) {
            this.updatedFiles.add(new ScmFile(file, status));
        }
    }

    public List<ScmFile> getUpdatedFiles() {
        return this.updatedFiles;
    }
}

