/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.qsg;

import java.util.HashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.wso2.mdm.qsg.dto.EMMQSGConfig;
import org.wso2.mdm.qsg.dto.HTTPResponse;
import org.wso2.mdm.qsg.utils.HTTPInvoker;

public class UserOperations {
    public static boolean createUser(String username, String email, boolean isAdmin) {
        HashMap<String, String> headers = new HashMap<String, String>();
        String userEndpoint = EMMQSGConfig.getInstance().getEmmHost() + "/api/device-mgt/v1.0/users";
        JSONObject userData = new JSONObject();
        userData.put("username", username);
        userData.put("emailAddress", email);
        JSONArray roles = new JSONArray();
        if (isAdmin) {
            roles.add("admin");
            userData.put("firstname", "Chris");
            userData.put("lastname", "Admin");
        } else {
            userData.put("password", "kimemmtrial");
            userData.put("firstname", "Alex");
            userData.put("lastname", "User");
        }
        userData.put("roles", roles);
        headers.put("Content-Type", "application/json");
        HTTPResponse httpResponse = HTTPInvoker.sendHTTPPostWithOAuthSecurity(userEndpoint, userData.toJSONString(), headers);
        return httpResponse.getResponseCode() == 201;
    }

    public static boolean changePassword(String username, String pwd) {
        HashMap<String, String> headers = new HashMap<String, String>();
        String pwdEndpoint = EMMQSGConfig.getInstance().getEmmHost() + "/api/device-mgt/v1.0/admin/users/" + username + "/credentials";
        JSONObject pwdData = new JSONObject();
        pwdData.put("newPassword", pwd);
        headers.put("Content-Type", "application/json");
        HTTPResponse httpResponse = HTTPInvoker.sendHTTPPostWithOAuthSecurity(pwdEndpoint, pwdData.toJSONString(), headers);
        return httpResponse.getResponseCode() == 200;
    }

    private static String[] getUserPermissions() {
        String permissions = "/permission/admin/device-mgt/certificates/manage,/permission/admin/device-mgt/certificates/view,/permission/admin/device-mgt/configurations/view,/permission/admin/device-mgt/api,/permission/admin/device-mgt/devices/enroll,/permission/admin/device-mgt/devices/disenroll,/permission/admin/device-mgt/devices/enroll/android,/permission/admin/device-mgt/devices/enroll/ios,/permission/admin/device-mgt/devices/owning-device,/permission/admin/device-mgt/devices/owning-device/view,/permission/admin/device-mgt/devices/owning-device/operations/android/applications,/permission/admin/device-mgt/devices/owning-device/operations/android/blacklist-app,/permission/admin/device-mgt/devices/owning-device/operations/android/camera,/permission/admin/device-mgt/devices/owning-device/operations/android/change-lock-code,/permission/admin/device-mgt/devices/owning-device/operations/android/clear-password,/permission/admin/device-mgt/devices/owning-device/operations/android/encrypt,/permission/admin/device-mgt/devices/owning-device/operations/android/enterprise-wipe,/permission/admin/device-mgt/devices/owning-device/operations/android/info,/permission/admin/device-mgt/devices/owning-device/operations/android/install-app,/permission/admin/device-mgt/devices/owning-device/operations/android/location,/permission/admin/device-mgt/devices/owning-device/operations/android/lock,/permission/admin/device-mgt/devices/owning-device/operations/android/logcat,/permission/admin/device-mgt/devices/owning-device/operations/android/mute,/permission/admin/device-mgt/devices/owning-device/operations/android/password-policy,/permission/admin/device-mgt/devices/owning-device/operations/android/ring,/permission/admin/device-mgt/devices/owning-device/operations/android/reboot,/permission/admin/device-mgt/devices/owning-device/operations/android/send-notification,/permission/admin/device-mgt/devices/owning-device/operations/android/uninstall-app,/permission/admin/device-mgt/devices/owning-device/operations/android/update-app,/permission/admin/device-mgt/devices/owning-device/operations/android/unlock,/permission/admin/device-mgt/devices/owning-device/operations/android/upgrade,/permission/admin/device-mgt/devices/owning-device/operations/android/vpn,/permission/admin/device-mgt/devices/owning-device/operations/android/webclip,/permission/admin/device-mgt/devices/owning-device/operations/android/wifi,/permission/admin/device-mgt/devices/owning-device/operations/android/wipe,/permission/admin/device-mgt/devices/owning-device/operations/ios,/permission/admin/device-mgt/devices/owning-device/operations/ios/airplay,/permission/admin/device-mgt/devices/owning-device/operations/ios/apn,/permission/admin/device-mgt/devices/owning-device/operations/ios/app-list,/permission/admin/device-mgt/devices/owning-device/operations/ios/app-lock,/permission/admin/device-mgt/devices/owning-device/operations/ios/app-to-per-app-vpn,/permission/admin/device-mgt/devices/owning-device/operations/ios/cal-subscription,/permission/admin/device-mgt/devices/owning-device/operations/ios/caldav,/permission/admin/device-mgt/devices/owning-device/operations/ios/cellular,/permission/admin/device-mgt/devices/owning-device/operations/ios/clear-passcode,/permission/admin/device-mgt/devices/owning-device/operations/ios/device-info,/permission/admin/device-mgt/devices/owning-device/operations/ios/email,/permission/admin/device-mgt/devices/owning-device/operations/ios/enterprise-app,/permission/admin/device-mgt/devices/owning-device/operations/ios/enterprise-wipe,/permission/admin/device-mgt/devices/owning-device/operations/ios/get-restrictions,/permission/admin/device-mgt/devices/owning-device/operations/ios/ldap,/permission/admin/device-mgt/devices/owning-device/operations/ios/location,/permission/admin/device-mgt/devices/owning-device/operations/ios/lock,/permission/admin/device-mgt/devices/owning-device/operations/ios/notification,/permission/admin/device-mgt/devices/owning-device/operations/ios/passcode-policy,/permission/admin/device-mgt/devices/owning-device/operations/ios/per-app-vpn,/permission/admin/device-mgt/devices/owning-device/operations/ios/profile-list,/permission/admin/device-mgt/devices/owning-device/operations/ios/remove-app,/permission/admin/device-mgt/devices/owning-device/operations/ios/remove-profile,/permission/admin/device-mgt/devices/owning-device/operations/ios/restriction,/permission/admin/device-mgt/devices/owning-device/operations/ios/ring,/permission/admin/device-mgt/devices/owning-device/operations/ios/store-app,/permission/admin/device-mgt/devices/owning-device/operations/ios/vpn,/permission/admin/device-mgt/devices/owning-device/operations/ios/webclip,/permission/admin/device-mgt/devices/owning-device/operations/ios/wifi,/permission/admin/device-mgt/notifications/view,/permission/admin/device-mgt/platform-configurations/view,/permission/admin/device-mgt/policies/view,/permission/admin/device-mgt/applications/manage,/permission/admin/manage/mobileapp/create,/permission/admin/manage/mobileapp/install,/permission/admin/manage/resources/browse,/permission/admin/manage/webapp/subscribe,/permission/admin/manage/search/advanced-search,/permission/admin/manage/search/resources,/permission/admin/manage/resources/govern/mobileapp/list,/permission/admin/login";
        return permissions.split(",");
    }

    public static boolean createRole(String roleName, String[] users) {
        String[] permissions;
        HashMap<String, String> headers = new HashMap<String, String>();
        String roleEndpoint = EMMQSGConfig.getInstance().getEmmHost() + "/api/device-mgt/v1.0/roles";
        JSONObject roleData = new JSONObject();
        roleData.put("roleName", roleName);
        JSONArray perms = new JSONArray();
        for (String perm : permissions = UserOperations.getUserPermissions()) {
            perms.add(perm);
        }
        roleData.put("permissions", perms);
        JSONArray usrs = new JSONArray();
        for (String usr : users) {
            usrs.add(usr);
        }
        roleData.put("permissions", perms);
        roleData.put("users", usrs);
        headers.put("Content-Type", "application/json");
        HTTPResponse httpResponse = HTTPInvoker.sendHTTPPostWithOAuthSecurity(roleEndpoint, roleData.toJSONString(), headers);
        return httpResponse.getResponseCode() == 201;
    }
}

