/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal;

import javax.ws.rs.ext.ExceptionMapper;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;
import org.wso2.carbon.kernel.transports.CarbonTransport;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.Microservice;
import org.wso2.msf4j.internal.DataHolder;
import org.wso2.msf4j.internal.MicroservicesRegistry;
import org.wso2.msf4j.internal.swagger.SwaggerDefinitionService;

@Component(name="org.wso2.msf4j.internal.MicroServicesServerSC", immediate=true, property={"componentName=wso2-microservices-server"})
public class MicroservicesServerSC
implements RequiredCapabilityListener {
    private static final Logger log = LoggerFactory.getLogger(MicroservicesServerSC.class);
    private final MicroservicesRegistry microservicesRegistry = new MicroservicesRegistry();

    @Activate
    protected void start(BundleContext bundleContext) {
        DataHolder.getInstance().setMicroservicesRegistry(this.microservicesRegistry);
        this.microservicesRegistry.addService(new SwaggerDefinitionService(this.microservicesRegistry));
    }

    @Reference(name="microservice", service=Microservice.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeService")
    protected void addService(Microservice service) {
        this.microservicesRegistry.addService(service);
    }

    protected void removeService(Microservice service) {
        this.microservicesRegistry.removeService(service);
    }

    @Reference(name="carbon-transport", service=CarbonTransport.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="removeCarbonTransport")
    protected void addCarbonTransport(CarbonTransport carbonTransport) {
    }

    protected void removeCarbonTransport(CarbonTransport carbonTransport) {
    }

    @Reference(name="interceptor", service=Interceptor.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeInterceptor")
    protected void addInterceptor(Interceptor interceptor) {
        this.microservicesRegistry.addInterceptor(interceptor);
    }

    protected void removeInterceptor(Interceptor interceptor) {
        this.microservicesRegistry.removeInterceptor(interceptor);
    }

    @Reference(name="exception-mapper", service=ExceptionMapper.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeExceptionMapper")
    protected void addExceptionMapper(ExceptionMapper exceptionMapper) {
        this.microservicesRegistry.addExceptionMapper(exceptionMapper);
    }

    protected void removeExceptionMapper(ExceptionMapper exceptionMapper) {
        this.microservicesRegistry.removeExceptionMapper(exceptionMapper);
    }

    @Override
    public void onAllRequiredCapabilitiesAvailable() {
        DataHolder.getInstance().getBundleContext().registerService(MicroservicesServerSC.class, (Object)this, null);
        log.info("All microservices are available");
    }
}

