/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.internal;

import java.util.Set;
import java.util.stream.Collectors;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.kernel.transports.CarbonTransport;
import org.wso2.carbon.messaging.TransportSender;
import org.wso2.carbon.messaging.handler.HandlerExecutor;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.config.SenderConfiguration;
import org.wso2.carbon.transport.http.netty.config.TransportsConfiguration;
import org.wso2.carbon.transport.http.netty.config.YAMLTransportConfigurationBuilder;
import org.wso2.carbon.transport.http.netty.internal.NettyTransportContextHolder;
import org.wso2.carbon.transport.http.netty.listener.NettyListener;
import org.wso2.carbon.transport.http.netty.sender.NettySender;

public class NettyTransportActivator
implements BundleActivator {
    public void start(BundleContext bundleContext) throws Exception {
        this.createNettyListeners().forEach(listener -> bundleContext.registerService(CarbonTransport.class, listener, null));
        this.createNettySenders().forEach(sender -> bundleContext.registerService(TransportSender.class, sender, null));
        NettyTransportContextHolder.getInstance().setBundleContext(bundleContext);
        HandlerExecutor handlerExecutor = new HandlerExecutor();
        NettyTransportContextHolder.getInstance().setHandlerExecutor(handlerExecutor);
    }

    private Set<NettyListener> createNettyListeners() {
        TransportsConfiguration trpConfig = YAMLTransportConfigurationBuilder.build();
        Set<ListenerConfiguration> listenerConfigurations = trpConfig.getListenerConfigurations();
        listenerConfigurations.forEach(listenerConfiguration -> NettyTransportContextHolder.getInstance().setListenerConfiguration(listenerConfiguration.getId(), (ListenerConfiguration)listenerConfiguration));
        Set<NettyListener> listeners = listenerConfigurations.stream().map(listenerConfiguration -> new NettyListener((ListenerConfiguration)listenerConfiguration)).collect(Collectors.toSet());
        return listeners;
    }

    private Set<NettySender> createNettySenders() {
        Set<SenderConfiguration> senderConfigurations = YAMLTransportConfigurationBuilder.build().getSenderConfigurations();
        Set<NettySender> senders = senderConfigurations.stream().map(senderConfiguration -> new NettySender((SenderConfiguration)senderConfiguration)).collect(Collectors.toSet());
        return senders;
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }
}

