/*
 * Decompiled with CFR 0.152.
 */
package org.example.service;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.example.service.Stock;

public class StockQuoteDatabase {
    private Random random = new Random();
    private Map<String, Stock> stockQuotes = new HashMap<String, Stock>();
    private Map<String, Stock> stockQuotesCache = new HashMap<String, Stock>();

    public StockQuoteDatabase() {
        this.stockQuotes.put("IBM", new Stock("IBM", "International Business Machines", 149.62, 150.78, 149.18));
        this.stockQuotes.put("GOOG", new Stock("GOOG", "Alphabet Inc.", 652.3, 657.81, 643.15));
        this.stockQuotes.put("AMZN", new Stock("AMZN", "Amazon.com", 548.9, 553.2, 543.1));
    }

    public Stock getStock(String symbol) {
        int rand = this.random.nextInt(3);
        if (rand == 0) {
            System.out.println("Failed. Timeout!");
            this.delay(50);
        } else if (rand == 1) {
            System.out.println("Failed. Exception!");
            throw new RuntimeException("Failed. Exception!");
        }
        System.out.println("No failure");
        Stock stock = this.stockQuotes.get(symbol);
        this.stockQuotesCache.put(symbol, stock);
        return stock;
    }

    private void delay(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Stock getCachedStock(String symbol) {
        return this.stockQuotesCache.get(symbol);
    }
}

