/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.annotations.Beta;
import rx.exceptions.Exceptions;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.internal.operators.NotificationLite;
import rx.internal.util.UtilityFunctions;
import rx.schedulers.Timestamped;
import rx.subjects.Subject;
import rx.subjects.SubjectSubscriptionManager;

public final class ReplaySubject<T>
extends Subject<T, T> {
    final ReplayState<T, ?> state;
    final SubjectSubscriptionManager<T> ssm;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public static <T> ReplaySubject<T> create() {
        return ReplaySubject.create(16);
    }

    public static <T> ReplaySubject<T> create(int capacity) {
        final UnboundedReplayState state = new UnboundedReplayState(capacity);
        SubjectSubscriptionManager ssm = new SubjectSubscriptionManager();
        ssm.onStart = new Action1<SubjectSubscriptionManager.SubjectObserver<T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<T> o) {
                int lastIndex = state.replayObserverFromIndex(0, o);
                o.index(lastIndex);
            }
        };
        ssm.onAdded = new Action1<SubjectSubscriptionManager.SubjectObserver<T>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<T> o) {
                SubjectSubscriptionManager.SubjectObserver subjectObserver = o;
                synchronized (subjectObserver) {
                    if (!o.first) return;
                    if (o.emitting) {
                        return;
                    }
                    o.first = false;
                    o.emitting = true;
                }
                boolean skipFinal = false;
                try {
                    UnboundedReplayState localState = state;
                    while (true) {
                        int sidx;
                        int idx;
                        if ((idx = ((Integer)o.index()).intValue()) != (sidx = localState.get())) {
                            Integer j = localState.replayObserverFromIndex(idx, o);
                            o.index(j);
                        }
                        SubjectSubscriptionManager.SubjectObserver subjectObserver2 = o;
                        synchronized (subjectObserver2) {
                            if (sidx == localState.get()) {
                                o.emitting = false;
                                skipFinal = true;
                                return;
                            }
                        }
                    }
                }
                finally {
                    if (!skipFinal) {
                        SubjectSubscriptionManager.SubjectObserver subjectObserver3 = o;
                        synchronized (subjectObserver3) {
                            o.emitting = false;
                        }
                    }
                }
            }
        };
        ssm.onTerminated = new Action1<SubjectSubscriptionManager.SubjectObserver<T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<T> o) {
                Integer idx = (Integer)o.index();
                if (idx == null) {
                    idx = 0;
                }
                state.replayObserverFromIndex(idx, o);
            }
        };
        return new ReplaySubject(ssm, ssm, state);
    }

    static <T> ReplaySubject<T> createUnbounded() {
        BoundedState state = new BoundedState(new EmptyEvictionPolicy(), UtilityFunctions.<Object>identity(), UtilityFunctions.<Object>identity());
        return ReplaySubject.createWithState(state, new DefaultOnAdd(state));
    }

    public static <T> ReplaySubject<T> createWithSize(int size) {
        BoundedState state = new BoundedState(new SizeEvictionPolicy(size), UtilityFunctions.<Object>identity(), UtilityFunctions.<Object>identity());
        return ReplaySubject.createWithState(state, new DefaultOnAdd(state));
    }

    public static <T> ReplaySubject<T> createWithTime(long time, TimeUnit unit, Scheduler scheduler) {
        BoundedState state = new BoundedState(new TimeEvictionPolicy(unit.toMillis(time), scheduler), new AddTimestamped(scheduler), new RemoveTimestamped());
        return ReplaySubject.createWithState(state, new TimedOnAdd(state, scheduler));
    }

    public static <T> ReplaySubject<T> createWithTimeAndSize(long time, TimeUnit unit, int size, Scheduler scheduler) {
        BoundedState state = new BoundedState(new PairEvictionPolicy(new SizeEvictionPolicy(size), new TimeEvictionPolicy(unit.toMillis(time), scheduler)), new AddTimestamped(scheduler), new RemoveTimestamped());
        return ReplaySubject.createWithState(state, new TimedOnAdd(state, scheduler));
    }

    static <T> ReplaySubject<T> createWithState(final BoundedState<T> state, Action1<SubjectSubscriptionManager.SubjectObserver<T>> onStart) {
        SubjectSubscriptionManager ssm = new SubjectSubscriptionManager();
        ssm.onStart = onStart;
        ssm.onAdded = new Action1<SubjectSubscriptionManager.SubjectObserver<T>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<T> o) {
                SubjectSubscriptionManager.SubjectObserver subjectObserver = o;
                synchronized (subjectObserver) {
                    if (!o.first) return;
                    if (o.emitting) {
                        return;
                    }
                    o.first = false;
                    o.emitting = true;
                }
                boolean skipFinal = false;
                try {
                    while (true) {
                        NodeList.Node<Object> sidx;
                        NodeList.Node idx;
                        if ((idx = (NodeList.Node)o.index()) != (sidx = state.tail())) {
                            NodeList.Node<Object> j = state.replayObserverFromIndex(idx, o);
                            o.index(j);
                        }
                        SubjectSubscriptionManager.SubjectObserver subjectObserver2 = o;
                        synchronized (subjectObserver2) {
                            if (sidx == state.tail()) {
                                o.emitting = false;
                                skipFinal = true;
                                return;
                            }
                        }
                    }
                }
                finally {
                    if (!skipFinal) {
                        SubjectSubscriptionManager.SubjectObserver subjectObserver3 = o;
                        synchronized (subjectObserver3) {
                            o.emitting = false;
                        }
                    }
                }
            }
        };
        ssm.onTerminated = new Action1<SubjectSubscriptionManager.SubjectObserver<T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<T> t1) {
                NodeList.Node<Object> l = (NodeList.Node<Object>)t1.index();
                if (l == null) {
                    l = state.head();
                }
                state.replayObserverFromIndex(l, t1);
            }
        };
        return new ReplaySubject(ssm, ssm, state);
    }

    ReplaySubject(Observable.OnSubscribe<T> onSubscribe, SubjectSubscriptionManager<T> ssm, ReplayState<T, ?> state) {
        super(onSubscribe);
        this.ssm = ssm;
        this.state = state;
    }

    @Override
    public void onNext(T t) {
        if (this.ssm.active) {
            this.state.next(t);
            for (SubjectSubscriptionManager.SubjectObserver<T> o : this.ssm.observers()) {
                if (!this.caughtUp(o)) continue;
                o.onNext(t);
            }
        }
    }

    @Override
    public void onError(Throwable e) {
        if (this.ssm.active) {
            this.state.error(e);
            ArrayList<Throwable> errors = null;
            for (SubjectSubscriptionManager.SubjectObserver<T> o : this.ssm.terminate(NotificationLite.instance().error(e))) {
                try {
                    if (!this.caughtUp(o)) continue;
                    o.onError(e);
                }
                catch (Throwable e2) {
                    if (errors == null) {
                        errors = new ArrayList<Throwable>();
                    }
                    errors.add(e2);
                }
            }
            Exceptions.throwIfAny(errors);
        }
    }

    @Override
    public void onCompleted() {
        if (this.ssm.active) {
            this.state.complete();
            for (SubjectSubscriptionManager.SubjectObserver<T> o : this.ssm.terminate(NotificationLite.instance().completed())) {
                if (!this.caughtUp(o)) continue;
                o.onCompleted();
            }
        }
    }

    int subscriberCount() {
        return ((SubjectSubscriptionManager.State)this.ssm.get()).observers.length;
    }

    @Override
    public boolean hasObservers() {
        return this.ssm.observers().length > 0;
    }

    private boolean caughtUp(SubjectSubscriptionManager.SubjectObserver<? super T> o) {
        if (!o.caughtUp) {
            if (this.state.replayObserver(o)) {
                o.caughtUp = true;
                o.index(null);
            }
            return false;
        }
        return true;
    }

    @Beta
    public boolean hasThrowable() {
        NotificationLite nl = this.ssm.nl;
        Object o = this.ssm.getLatest();
        return nl.isError(o);
    }

    @Beta
    public boolean hasCompleted() {
        NotificationLite nl = this.ssm.nl;
        Object o = this.ssm.getLatest();
        return o != null && !nl.isError(o);
    }

    @Beta
    public Throwable getThrowable() {
        NotificationLite nl = this.ssm.nl;
        Object o = this.ssm.getLatest();
        if (nl.isError(o)) {
            return nl.getError(o);
        }
        return null;
    }

    @Beta
    public int size() {
        return this.state.size();
    }

    @Beta
    public boolean hasAnyValue() {
        return !this.state.isEmpty();
    }

    @Beta
    public boolean hasValue() {
        return this.hasAnyValue();
    }

    @Beta
    public T[] getValues(T[] a) {
        return this.state.toArray(a);
    }

    @Beta
    public Object[] getValues() {
        Object[] r = this.getValues(EMPTY_ARRAY);
        if (r == EMPTY_ARRAY) {
            return new Object[0];
        }
        return r;
    }

    @Beta
    public T getValue() {
        return this.state.latest();
    }

    static final class EmptyEvictionPolicy
    implements EvictionPolicy {
        EmptyEvictionPolicy() {
        }

        @Override
        public boolean test(Object value, long now) {
            return true;
        }

        @Override
        public void evict(NodeList<Object> list) {
        }

        @Override
        public void evictFinal(NodeList<Object> list) {
        }
    }

    static final class NodeList<T> {
        final Node<T> head = new Node<Object>(null);
        Node<T> tail = this.head;
        int size;

        NodeList() {
        }

        public void addLast(T value) {
            Node<T> t = this.tail;
            Node<T> t2 = new Node<T>(value);
            t.next = t2;
            this.tail = t2;
            ++this.size;
        }

        public T removeFirst() {
            if (this.head.next == null) {
                throw new IllegalStateException("Empty!");
            }
            Node t = this.head.next;
            this.head.next = t.next;
            if (this.head.next == null) {
                this.tail = this.head;
            }
            --this.size;
            return t.value;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public int size() {
            return this.size;
        }

        public void clear() {
            this.tail = this.head;
            this.size = 0;
        }

        static final class Node<T> {
            final T value;
            volatile Node<T> next;

            Node(T value) {
                this.value = value;
            }
        }
    }

    static final class TimedOnAdd<T>
    implements Action1<SubjectSubscriptionManager.SubjectObserver<T>> {
        final BoundedState<T> state;
        final Scheduler scheduler;

        public TimedOnAdd(BoundedState<T> state, Scheduler scheduler) {
            this.state = state;
            this.scheduler = scheduler;
        }

        @Override
        public void call(SubjectSubscriptionManager.SubjectObserver<T> t1) {
            NodeList.Node<Object> l = !this.state.terminated ? this.state.replayObserverFromIndexTest(this.state.head(), t1, this.scheduler.now()) : this.state.replayObserverFromIndex(this.state.head(), t1);
            t1.index(l);
        }
    }

    static final class DefaultOnAdd<T>
    implements Action1<SubjectSubscriptionManager.SubjectObserver<T>> {
        final BoundedState<T> state;

        public DefaultOnAdd(BoundedState<T> state) {
            this.state = state;
        }

        @Override
        public void call(SubjectSubscriptionManager.SubjectObserver<T> t1) {
            NodeList.Node<Object> l = this.state.replayObserverFromIndex(this.state.head(), t1);
            t1.index(l);
        }
    }

    static final class RemoveTimestamped
    implements Func1<Object, Object> {
        RemoveTimestamped() {
        }

        @Override
        public Object call(Object t1) {
            return ((Timestamped)t1).getValue();
        }
    }

    static final class AddTimestamped
    implements Func1<Object, Object> {
        final Scheduler scheduler;

        public AddTimestamped(Scheduler scheduler) {
            this.scheduler = scheduler;
        }

        @Override
        public Object call(Object t1) {
            return new Timestamped<Object>(this.scheduler.now(), t1);
        }
    }

    static final class PairEvictionPolicy
    implements EvictionPolicy {
        final EvictionPolicy first;
        final EvictionPolicy second;

        public PairEvictionPolicy(EvictionPolicy first, EvictionPolicy second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public void evict(NodeList<Object> t1) {
            this.first.evict(t1);
            this.second.evict(t1);
        }

        @Override
        public void evictFinal(NodeList<Object> t1) {
            this.first.evictFinal(t1);
            this.second.evictFinal(t1);
        }

        @Override
        public boolean test(Object value, long now) {
            return this.first.test(value, now) || this.second.test(value, now);
        }
    }

    static final class TimeEvictionPolicy
    implements EvictionPolicy {
        final long maxAgeMillis;
        final Scheduler scheduler;

        public TimeEvictionPolicy(long maxAgeMillis, Scheduler scheduler) {
            this.maxAgeMillis = maxAgeMillis;
            this.scheduler = scheduler;
        }

        @Override
        public void evict(NodeList<Object> t1) {
            long now = this.scheduler.now();
            while (!t1.isEmpty()) {
                NodeList.Node n = t1.head.next;
                if (!this.test(n.value, now)) break;
                t1.removeFirst();
            }
        }

        @Override
        public void evictFinal(NodeList<Object> t1) {
            long now = this.scheduler.now();
            while (t1.size > 1) {
                NodeList.Node n = t1.head.next;
                if (!this.test(n.value, now)) break;
                t1.removeFirst();
            }
        }

        @Override
        public boolean test(Object value, long now) {
            Timestamped ts = (Timestamped)value;
            return ts.getTimestampMillis() <= now - this.maxAgeMillis;
        }
    }

    static final class SizeEvictionPolicy
    implements EvictionPolicy {
        final int maxSize;

        public SizeEvictionPolicy(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public void evict(NodeList<Object> t1) {
            while (t1.size() > this.maxSize) {
                t1.removeFirst();
            }
        }

        @Override
        public boolean test(Object value, long now) {
            return false;
        }

        @Override
        public void evictFinal(NodeList<Object> t1) {
            while (t1.size() > this.maxSize + 1) {
                t1.removeFirst();
            }
        }
    }

    static interface EvictionPolicy {
        public boolean test(Object var1, long var2);

        public void evict(NodeList<Object> var1);

        public void evictFinal(NodeList<Object> var1);
    }

    static interface ReplayState<T, I> {
        public boolean terminated();

        public boolean replayObserver(SubjectSubscriptionManager.SubjectObserver<? super T> var1);

        public I replayObserverFromIndex(I var1, SubjectSubscriptionManager.SubjectObserver<? super T> var2);

        public I replayObserverFromIndexTest(I var1, SubjectSubscriptionManager.SubjectObserver<? super T> var2, long var3);

        public void next(T var1);

        public void error(Throwable var1);

        public void complete();

        public int size();

        public boolean isEmpty();

        public T[] toArray(T[] var1);

        public T latest();
    }

    static final class BoundedState<T>
    implements ReplayState<T, NodeList.Node<Object>> {
        final NodeList<Object> list;
        final EvictionPolicy evictionPolicy;
        final Func1<Object, Object> enterTransform;
        final Func1<Object, Object> leaveTransform;
        final NotificationLite<T> nl = NotificationLite.instance();
        volatile boolean terminated;
        volatile NodeList.Node<Object> tail;

        public BoundedState(EvictionPolicy evictionPolicy, Func1<Object, Object> enterTransform, Func1<Object, Object> leaveTransform) {
            this.list = new NodeList();
            this.tail = this.list.tail;
            this.evictionPolicy = evictionPolicy;
            this.enterTransform = enterTransform;
            this.leaveTransform = leaveTransform;
        }

        @Override
        public void next(T value) {
            if (!this.terminated) {
                this.list.addLast(this.enterTransform.call(this.nl.next(value)));
                this.evictionPolicy.evict(this.list);
                this.tail = this.list.tail;
            }
        }

        @Override
        public void complete() {
            if (!this.terminated) {
                this.terminated = true;
                this.list.addLast(this.enterTransform.call(this.nl.completed()));
                this.evictionPolicy.evictFinal(this.list);
                this.tail = this.list.tail;
            }
        }

        @Override
        public void error(Throwable e) {
            if (!this.terminated) {
                this.terminated = true;
                this.list.addLast(this.enterTransform.call(this.nl.error(e)));
                this.evictionPolicy.evictFinal(this.list);
                this.tail = this.list.tail;
            }
        }

        public void accept(Observer<? super T> o, NodeList.Node<Object> node) {
            this.nl.accept(o, this.leaveTransform.call(node.value));
        }

        public void acceptTest(Observer<? super T> o, NodeList.Node<Object> node, long now) {
            Object v = node.value;
            if (!this.evictionPolicy.test(v, now)) {
                this.nl.accept(o, this.leaveTransform.call(v));
            }
        }

        public NodeList.Node<Object> head() {
            return this.list.head;
        }

        public NodeList.Node<Object> tail() {
            return this.tail;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean replayObserver(SubjectSubscriptionManager.SubjectObserver<? super T> observer) {
            SubjectSubscriptionManager.SubjectObserver<T> subjectObserver = observer;
            synchronized (subjectObserver) {
                observer.first = false;
                if (observer.emitting) {
                    return false;
                }
            }
            NodeList.Node lastEmittedLink = (NodeList.Node)observer.index();
            NodeList.Node<Object> l = this.replayObserverFromIndex(lastEmittedLink, observer);
            observer.index(l);
            return true;
        }

        @Override
        public NodeList.Node<Object> replayObserverFromIndex(NodeList.Node<Object> l, SubjectSubscriptionManager.SubjectObserver<? super T> observer) {
            while (l != this.tail()) {
                this.accept(observer, l.next);
                l = l.next;
            }
            return l;
        }

        @Override
        public NodeList.Node<Object> replayObserverFromIndexTest(NodeList.Node<Object> l, SubjectSubscriptionManager.SubjectObserver<? super T> observer, long now) {
            while (l != this.tail()) {
                this.acceptTest(observer, l.next, now);
                l = l.next;
            }
            return l;
        }

        @Override
        public boolean terminated() {
            return this.terminated;
        }

        @Override
        public int size() {
            Object value;
            int size = 0;
            NodeList.Node<Object> l = this.head();
            NodeList.Node next = l.next;
            while (next != null) {
                ++size;
                l = next;
                next = next.next;
            }
            if (l.value != null && (value = this.leaveTransform.call(l.value)) != null && (this.nl.isError(value) || this.nl.isCompleted(value))) {
                return size - 1;
            }
            return size;
        }

        @Override
        public boolean isEmpty() {
            NodeList.Node<Object> l = this.head();
            NodeList.Node next = l.next;
            if (next == null) {
                return true;
            }
            Object value = this.leaveTransform.call(next.value);
            return this.nl.isError(value) || this.nl.isCompleted(value);
        }

        @Override
        public T[] toArray(T[] a) {
            ArrayList<Object> list = new ArrayList<Object>();
            NodeList.Node<Object> l = this.head();
            NodeList.Node next = l.next;
            while (next != null) {
                Object o = this.leaveTransform.call(next.value);
                if (next.next == null && (this.nl.isError(o) || this.nl.isCompleted(o))) break;
                list.add(o);
                l = next;
                next = next.next;
            }
            return list.toArray(a);
        }

        @Override
        public T latest() {
            NodeList.Node h = this.head().next;
            if (h == null) {
                return null;
            }
            NodeList.Node p = null;
            while (h != this.tail()) {
                p = h;
                h = h.next;
            }
            Object value = this.leaveTransform.call(h.value);
            if (this.nl.isError(value) || this.nl.isCompleted(value)) {
                if (p != null) {
                    value = this.leaveTransform.call(p.value);
                    return this.nl.getValue(value);
                }
                return null;
            }
            return this.nl.getValue(value);
        }
    }

    static final class UnboundedReplayState<T>
    extends AtomicInteger
    implements ReplayState<T, Integer> {
        private final NotificationLite<T> nl = NotificationLite.instance();
        private final ArrayList<Object> list;
        private volatile boolean terminated;

        public UnboundedReplayState(int initialCapacity) {
            this.list = new ArrayList(initialCapacity);
        }

        @Override
        public void next(T n) {
            if (!this.terminated) {
                this.list.add(this.nl.next(n));
                this.getAndIncrement();
            }
        }

        public void accept(Observer<? super T> o, int idx) {
            this.nl.accept(o, this.list.get(idx));
        }

        @Override
        public void complete() {
            if (!this.terminated) {
                this.terminated = true;
                this.list.add(this.nl.completed());
                this.getAndIncrement();
            }
        }

        @Override
        public void error(Throwable e) {
            if (!this.terminated) {
                this.terminated = true;
                this.list.add(this.nl.error(e));
                this.getAndIncrement();
            }
        }

        @Override
        public boolean terminated() {
            return this.terminated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean replayObserver(SubjectSubscriptionManager.SubjectObserver<? super T> observer) {
            SubjectSubscriptionManager.SubjectObserver<T> subjectObserver = observer;
            synchronized (subjectObserver) {
                observer.first = false;
                if (observer.emitting) {
                    return false;
                }
            }
            Integer lastEmittedLink = (Integer)observer.index();
            if (lastEmittedLink != null) {
                int l = this.replayObserverFromIndex(lastEmittedLink, observer);
                observer.index(l);
                return true;
            }
            throw new IllegalStateException("failed to find lastEmittedLink for: " + observer);
        }

        @Override
        public Integer replayObserverFromIndex(Integer idx, SubjectSubscriptionManager.SubjectObserver<? super T> observer) {
            int i;
            for (i = idx.intValue(); i < this.get(); ++i) {
                this.accept(observer, i);
            }
            return i;
        }

        @Override
        public Integer replayObserverFromIndexTest(Integer idx, SubjectSubscriptionManager.SubjectObserver<? super T> observer, long now) {
            return this.replayObserverFromIndex(idx, observer);
        }

        @Override
        public int size() {
            Object o;
            int idx = this.get();
            if (idx > 0 && (this.nl.isCompleted(o = this.list.get(idx - 1)) || this.nl.isError(o))) {
                return idx - 1;
            }
            return idx;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public T[] toArray(T[] a) {
            int s = this.size();
            if (s > 0) {
                if (s > a.length) {
                    a = (Object[])Array.newInstance(a.getClass().getComponentType(), s);
                }
                for (int i = 0; i < s; ++i) {
                    a[i] = this.list.get(i);
                }
                if (a.length > s) {
                    a[s] = null;
                }
            } else if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public T latest() {
            int idx = this.get();
            if (idx > 0) {
                Object o = this.list.get(idx - 1);
                if (this.nl.isCompleted(o) || this.nl.isError(o)) {
                    if (idx > 1) {
                        return this.nl.getValue(this.list.get(idx - 2));
                    }
                    return null;
                }
                return this.nl.getValue(o);
            }
            return null;
        }
    }
}

