/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.listener;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AsciiString;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.certificatevalidation.CertificateVerificationException;
import org.wso2.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.transport.http.netty.common.ssl.SSLHandlerFactory;
import org.wso2.transport.http.netty.config.ChunkConfig;
import org.wso2.transport.http.netty.config.KeepAliveConfig;
import org.wso2.transport.http.netty.config.RequestSizeValidationConfig;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.listener.CustomHttpContentCompressor;
import org.wso2.transport.http.netty.listener.HTTPTraceLoggingHandler;
import org.wso2.transport.http.netty.listener.Http2SourceHandlerBuilder;
import org.wso2.transport.http.netty.listener.Http2WithPriorKnowledgeHandler;
import org.wso2.transport.http.netty.listener.HttpAccessLoggingHandler;
import org.wso2.transport.http.netty.listener.MaxEntityBodyValidator;
import org.wso2.transport.http.netty.listener.OCSPResponseBuilder;
import org.wso2.transport.http.netty.listener.SourceHandler;
import org.wso2.transport.http.netty.listener.SslHandshakeCompletionHandlerForServer;
import org.wso2.transport.http.netty.listener.UriAndHeaderLengthValidator;
import org.wso2.transport.http.netty.listener.WebSocketServerHandshakeHandler;
import org.wso2.transport.http.netty.sender.CertificateValidationHandler;

public class HttpServerChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger log = LoggerFactory.getLogger(HttpServerChannelInitializer.class);
    private int socketIdleTimeout;
    private boolean httpTraceLogEnabled;
    private boolean httpAccessLogEnabled;
    private ChunkConfig chunkConfig;
    private KeepAliveConfig keepAliveConfig;
    private String interfaceId;
    private String serverName;
    private SSLConfig sslConfig;
    private ServerConnectorFuture serverConnectorFuture;
    private RequestSizeValidationConfig reqSizeValidationConfig;
    private boolean http2Enabled = false;
    private boolean validateCertEnabled;
    private int cacheDelay;
    private int cacheSize;
    private ChannelGroup allChannels;
    private boolean ocspStaplingEnabled = false;

    @Override
    public void initChannel(SocketChannel ch) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Initializing source channel pipeline");
        }
        ChannelPipeline serverPipeline = ch.pipeline();
        if (this.http2Enabled) {
            if (this.sslConfig != null) {
                SslContext sslCtx = new SSLHandlerFactory(this.sslConfig).createHttp2TLSContextForServer(this.ocspStaplingEnabled);
                if (this.ocspStaplingEnabled) {
                    OCSPResp response = this.getOcspResponse();
                    ReferenceCountedOpenSslContext context = (ReferenceCountedOpenSslContext)sslCtx;
                    SslHandler sslHandler = context.newHandler(ch.alloc());
                    ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)sslHandler.engine();
                    engine.setOcspResponse(response.getEncoded());
                    ch.pipeline().addLast(sslHandler, new Http2PipelineConfiguratorForServer());
                } else {
                    serverPipeline.addLast(sslCtx.newHandler(ch.alloc()), new Http2PipelineConfiguratorForServer());
                }
            } else {
                this.configureH2cPipeline(serverPipeline);
            }
        } else if (this.sslConfig != null) {
            this.configureSslForHttp(serverPipeline, ch);
        } else {
            this.configureHTTPPipeline(serverPipeline, "http");
        }
    }

    private OCSPResp getOcspResponse() throws IOException, KeyStoreException, UnrecoverableEntryException, NoSuchAlgorithmException, CertificateVerificationException {
        OCSPResp response = OCSPResponseBuilder.generatetOcspResponse(this.sslConfig, this.cacheSize, this.cacheDelay);
        if (!OpenSsl.isAvailable()) {
            throw new IllegalStateException("OpenSSL is not available!");
        }
        if (!OpenSsl.isOcspSupported()) {
            throw new IllegalStateException("OCSP is not supported!");
        }
        return response;
    }

    private void configureSslForHttp(ChannelPipeline serverPipeline, SocketChannel ch) throws NoSuchAlgorithmException, CertificateVerificationException, UnrecoverableEntryException, KeyStoreException, IOException {
        if (this.ocspStaplingEnabled) {
            OCSPResp response = this.getOcspResponse();
            ReferenceCountedOpenSslContext context = new SSLHandlerFactory(this.sslConfig).getServerReferenceCountedOpenSslContext(this.ocspStaplingEnabled);
            SslHandler sslHandler = context.newHandler(ch.alloc());
            ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)sslHandler.engine();
            engine.setOcspResponse(response.getEncoded());
            ch.pipeline().addLast(sslHandler);
        } else {
            SSLEngine sslEngine = new SSLHandlerFactory(this.sslConfig).buildServerSSLEngine();
            serverPipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
            if (this.validateCertEnabled) {
                serverPipeline.addLast("certificateValidation", (ChannelHandler)new CertificateValidationHandler(sslEngine, this.cacheDelay, this.cacheSize));
            }
        }
        serverPipeline.addLast("sslHandshakeCompletionHandler", (ChannelHandler)new SslHandshakeCompletionHandlerForServer(this, serverPipeline));
    }

    void configureHTTPPipeline(ChannelPipeline serverPipeline, String httpScheme) {
        if (httpScheme.equals("http")) {
            serverPipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        }
        serverPipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(this.reqSizeValidationConfig.getMaxUriLength(), this.reqSizeValidationConfig.getMaxHeaderSize(), this.reqSizeValidationConfig.getMaxChunkSize()));
        serverPipeline.addLast("compressor", (ChannelHandler)new CustomHttpContentCompressor());
        serverPipeline.addLast("chunkWriter", (ChannelHandler)new ChunkedWriteHandler());
        if (this.httpTraceLogEnabled) {
            serverPipeline.addLast("http-trace-logger", (ChannelHandler)new HTTPTraceLoggingHandler("tracelog.http.downstream"));
        }
        if (this.httpAccessLogEnabled) {
            serverPipeline.addLast("http-access-logger", (ChannelHandler)new HttpAccessLoggingHandler("accesslog.http"));
        }
        serverPipeline.addLast("uriLengthValidator", (ChannelHandler)new UriAndHeaderLengthValidator(this.serverName));
        if (this.reqSizeValidationConfig.getMaxEntityBodySize() > -1) {
            serverPipeline.addLast("maxEntityBodyValidator", (ChannelHandler)new MaxEntityBodyValidator(this.serverName, this.reqSizeValidationConfig.getMaxEntityBodySize()));
        }
        serverPipeline.addLast("websocket-server-handshake-handler", (ChannelHandler)new WebSocketServerHandshakeHandler(this.serverConnectorFuture, this.interfaceId));
        serverPipeline.addLast("SourceHandler", (ChannelHandler)new SourceHandler(this.serverConnectorFuture, this.interfaceId, this.chunkConfig, this.keepAliveConfig, this.serverName, this.allChannels));
        if (this.socketIdleTimeout > 0) {
            serverPipeline.addBefore("SourceHandler", "idleStateHandler", new IdleStateHandler(this.socketIdleTimeout, this.socketIdleTimeout, this.socketIdleTimeout, TimeUnit.MILLISECONDS));
        }
    }

    private void configureH2cPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new Http2WithPriorKnowledgeHandler(this.interfaceId, this.serverName, this.serverConnectorFuture));
        HttpServerCodec sourceCodec = new HttpServerCodec();
        HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = protocol -> {
            if (AsciiString.contentEquals(Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, protocol)) {
                return new Http2ServerUpgradeCodec("Http2SourceHandler", new Http2SourceHandlerBuilder(this.interfaceId, this.serverConnectorFuture, this.serverName).build());
            }
            return null;
        };
        pipeline.addLast("ServerCodec", (ChannelHandler)sourceCodec);
        pipeline.addLast("Http2UpgradeHandler", (ChannelHandler)new HttpServerUpgradeHandler(sourceCodec, upgradeCodecFactory, Integer.MAX_VALUE));
        this.configureHTTPPipeline(pipeline, "h2");
    }

    public void setServerConnectorFuture(ServerConnectorFuture serverConnectorFuture) {
        this.serverConnectorFuture = serverConnectorFuture;
    }

    void setIdleTimeout(int idleTimeout) {
        this.socketIdleTimeout = idleTimeout;
    }

    void setHttpTraceLogEnabled(boolean httpTraceLogEnabled) {
        this.httpTraceLogEnabled = httpTraceLogEnabled;
    }

    void setHttpAccessLogEnabled(boolean httpAccessLogEnabled) {
        this.httpAccessLogEnabled = httpAccessLogEnabled;
    }

    void setInterfaceId(String interfaceId) {
        this.interfaceId = interfaceId;
    }

    void setSslConfig(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    void setReqSizeValidationConfig(RequestSizeValidationConfig reqSizeValidationConfig) {
        this.reqSizeValidationConfig = reqSizeValidationConfig;
    }

    public void setChunkingConfig(ChunkConfig chunkConfig) {
        this.chunkConfig = chunkConfig;
    }

    void setKeepAliveConfig(KeepAliveConfig keepAliveConfig) {
        this.keepAliveConfig = keepAliveConfig;
    }

    void setValidateCertEnabled(boolean validateCertEnabled) {
        this.validateCertEnabled = validateCertEnabled;
    }

    void setCacheDelay(int cacheDelay) {
        this.cacheDelay = cacheDelay;
    }

    void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    void setServerName(String serverName) {
        this.serverName = serverName;
    }

    void setOcspStaplingEnabled(boolean ocspStaplingEnabled) {
        this.ocspStaplingEnabled = ocspStaplingEnabled;
    }

    void setHttp2Enabled(boolean http2Enabled) {
        this.http2Enabled = http2Enabled;
    }

    void setAllChannels(ChannelGroup allChannels) {
        this.allChannels = allChannels;
    }

    class Http2PipelineConfiguratorForServer
    extends ApplicationProtocolNegotiationHandler {
        Http2PipelineConfiguratorForServer() {
            super("http/1.1");
        }

        @Override
        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
            if ("h2".equals(protocol)) {
                ctx.pipeline().addLast("Http2SourceHandler", (ChannelHandler)new Http2SourceHandlerBuilder(HttpServerChannelInitializer.this.interfaceId, HttpServerChannelInitializer.this.serverConnectorFuture, HttpServerChannelInitializer.this.serverName).build());
            } else if ("http/1.1".equals(protocol)) {
                HttpServerChannelInitializer.this.configureHTTPPipeline(ctx.pipeline(), "http");
            } else {
                throw new IllegalStateException("unknown protocol: " + protocol);
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (ctx != null && ctx.channel().isActive()) {
                ctx.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
            }
        }
    }
}

