/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender.channel.pool;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.HttpRoute;
import org.wso2.transport.http.netty.config.SenderConfiguration;
import org.wso2.transport.http.netty.listener.SourceHandler;
import org.wso2.transport.http.netty.sender.channel.BootstrapConfiguration;
import org.wso2.transport.http.netty.sender.channel.TargetChannel;
import org.wso2.transport.http.netty.sender.channel.pool.PoolConfiguration;
import org.wso2.transport.http.netty.sender.channel.pool.PoolableTargetChannelFactory;
import org.wso2.transport.http.netty.sender.channel.pool.PoolableTargetChannelFactoryPerSrcHndlr;
import org.wso2.transport.http.netty.sender.http2.Http2ConnectionManager;

public class ConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(ConnectionManager.class);
    private EventLoopGroup clientEventGroup;
    private PoolConfiguration poolConfiguration;
    private PoolManagementPolicy poolManagementPolicy;
    private BootstrapConfiguration bootstrapConfig;
    private final Map<String, GenericObjectPool> connGlobalPool;
    private Http2ConnectionManager http2ConnectionManager;

    public ConnectionManager(SenderConfiguration senderConfig, BootstrapConfiguration bootstrapConfiguration, EventLoopGroup clientEventGroup) {
        this.poolConfiguration = senderConfig.getPoolConfiguration();
        if (this.poolConfiguration.getNumberOfPools() == 1) {
            this.poolManagementPolicy = PoolManagementPolicy.LOCK_DEFAULT_POOLING;
        }
        this.connGlobalPool = new ConcurrentHashMap<String, GenericObjectPool>();
        this.clientEventGroup = clientEventGroup;
        this.bootstrapConfig = bootstrapConfiguration;
        this.http2ConnectionManager = new Http2ConnectionManager(senderConfig);
    }

    private GenericObjectPool createPoolForRoute(PoolableTargetChannelFactory poolableTargetChannelFactory) {
        return new GenericObjectPool((PoolableObjectFactory)poolableTargetChannelFactory, this.instantiateAndConfigureConfig());
    }

    private GenericObjectPool createPoolForRoutePerSrcHndlr(GenericObjectPool genericObjectPool) {
        return new GenericObjectPool((PoolableObjectFactory)new PoolableTargetChannelFactoryPerSrcHndlr(genericObjectPool), this.instantiateAndConfigureConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetChannel borrowTargetChannel(HttpRoute httpRoute, SourceHandler sourceHandler, SenderConfiguration senderConfig) throws Exception {
        GenericObjectPool trgHlrConnPool;
        if (sourceHandler != null) {
            ChannelHandlerContext ctx = sourceHandler.getInboundChannelContext();
            EventLoop group = ctx.channel().eventLoop();
            Class<?> cl = ctx.channel().getClass();
            if (this.poolManagementPolicy == PoolManagementPolicy.LOCK_DEFAULT_POOLING) {
                Map<String, GenericObjectPool> srcHlrConnPool = sourceHandler.getTargetChannelPool();
                trgHlrConnPool = srcHlrConnPool.get(httpRoute.toString());
                if (trgHlrConnPool == null) {
                    PoolableTargetChannelFactory poolableTargetChannelFactory = new PoolableTargetChannelFactory(group, cl, httpRoute, senderConfig, this.bootstrapConfig, this);
                    trgHlrConnPool = this.createPoolForRoute(poolableTargetChannelFactory);
                    srcHlrConnPool.put(httpRoute.toString(), trgHlrConnPool);
                }
            } else {
                Map<String, GenericObjectPool> srcHlrConnPool = sourceHandler.getTargetChannelPool();
                trgHlrConnPool = srcHlrConnPool.get(httpRoute.toString());
                if (trgHlrConnPool == null) {
                    ConnectionManager connectionManager = this;
                    synchronized (connectionManager) {
                        if (!this.connGlobalPool.containsKey(httpRoute.toString())) {
                            PoolableTargetChannelFactory poolableTargetChannelFactory = new PoolableTargetChannelFactory(group, cl, httpRoute, senderConfig, this.bootstrapConfig, this);
                            trgHlrConnPool = this.createPoolForRoute(poolableTargetChannelFactory);
                            this.connGlobalPool.put(httpRoute.toString(), trgHlrConnPool);
                        }
                        trgHlrConnPool = this.connGlobalPool.get(httpRoute.toString());
                        trgHlrConnPool = this.createPoolForRoutePerSrcHndlr(trgHlrConnPool);
                    }
                    srcHlrConnPool.put(httpRoute.toString(), trgHlrConnPool);
                }
            }
        } else {
            Class<NioSocketChannel> cl = NioSocketChannel.class;
            EventLoopGroup group = this.clientEventGroup;
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                if (!this.connGlobalPool.containsKey(httpRoute.toString())) {
                    PoolableTargetChannelFactory poolableTargetChannelFactory = new PoolableTargetChannelFactory(group, cl, httpRoute, senderConfig, this.bootstrapConfig, this);
                    trgHlrConnPool = this.createPoolForRoute(poolableTargetChannelFactory);
                    this.connGlobalPool.put(httpRoute.toString(), trgHlrConnPool);
                }
                trgHlrConnPool = this.connGlobalPool.get(httpRoute.toString());
            }
        }
        TargetChannel targetChannel = (TargetChannel)trgHlrConnPool.borrowObject();
        targetChannel.setCorrelatedSource(sourceHandler);
        targetChannel.setConnectionManager(this);
        return targetChannel;
    }

    public void returnChannel(TargetChannel targetChannel) throws Exception {
        targetChannel.setRequestWritten(false);
        if (targetChannel.getCorrelatedSource() != null) {
            Map<String, GenericObjectPool> objectPoolMap = targetChannel.getCorrelatedSource().getTargetChannelPool();
            this.releaseChannelToPool(targetChannel, objectPoolMap.get(targetChannel.getHttpRoute().toString()));
        } else {
            this.releaseChannelToPool(targetChannel, this.connGlobalPool.get(targetChannel.getHttpRoute().toString()));
        }
    }

    private void releaseChannelToPool(TargetChannel targetChannel, GenericObjectPool pool) throws Exception {
        try {
            String channelID = targetChannel.getChannel().id().asShortText();
            if (targetChannel.getChannel().isActive() && pool != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Returning connection {} to the pool", (Object)channelID);
                }
                pool.returnObject(targetChannel);
            } else {
                log.warn("Channel {} is inactive hence not returning to connection pool", (Object)channelID);
            }
        }
        catch (Exception e) {
            throw new Exception("Couldn't return channel {} to pool", e);
        }
    }

    public void invalidateTargetChannel(TargetChannel targetChannel) throws Exception {
        targetChannel.setRequestWritten(false);
        if (targetChannel.getCorrelatedSource() != null) {
            Map<String, GenericObjectPool> objectPoolMap = targetChannel.getCorrelatedSource().getTargetChannelPool();
            try {
                String httpRoute = targetChannel.getHttpRoute().toString();
                if (objectPoolMap.get(httpRoute) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Invalidating connection {} to the pool", (Object)targetChannel.getChannel().id().asShortText());
                    }
                    objectPoolMap.get(httpRoute).invalidateObject(targetChannel);
                }
            }
            catch (Exception e) {
                throw new Exception("Cannot invalidate channel from pool", e);
            }
        }
    }

    private GenericObjectPool.Config instantiateAndConfigureConfig() {
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.maxActive = this.poolConfiguration.getMaxActivePerPool();
        config.maxIdle = this.poolConfiguration.getMaxIdlePerPool();
        config.minIdle = this.poolConfiguration.getMinIdlePerPool();
        config.testOnBorrow = this.poolConfiguration.isTestOnBorrow();
        config.testWhileIdle = this.poolConfiguration.isTestWhileIdle();
        config.timeBetweenEvictionRunsMillis = this.poolConfiguration.getTimeBetweenEvictionRuns();
        config.minEvictableIdleTimeMillis = this.poolConfiguration.getMinEvictableIdleTime();
        config.whenExhaustedAction = this.poolConfiguration.getExhaustedAction();
        config.maxWait = this.poolConfiguration.getMaxWaitTime();
        if (log.isDebugEnabled()) {
            log.debug("Creating a pool with {}", (Object)config.toString());
        }
        return config;
    }

    public Http2ConnectionManager getHttp2ConnectionManager() {
        return this.http2ConnectionManager;
    }

    public static enum PoolManagementPolicy {
        LOCK_DEFAULT_POOLING;

    }
}

