/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender.http2;

import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.wso2.transport.http.netty.common.HttpRoute;
import org.wso2.transport.http.netty.config.SenderConfiguration;
import org.wso2.transport.http.netty.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.sender.http2.Http2DataEventListener;

public class Http2ConnectionManager {
    private static ConcurrentHashMap<String, PerRouteConnectionPool> connectionPools = new ConcurrentHashMap();
    private Lock lock = new ReentrantLock();
    private SenderConfiguration senderConfig;

    public Http2ConnectionManager(SenderConfiguration senderConfig) {
        this.senderConfig = senderConfig;
    }

    public Http2ClientChannel borrowChannel(HttpRoute httpRoute) {
        String key = this.generateKey(httpRoute);
        PerRouteConnectionPool perRouteConnectionPool = this.fetchConnectionPool(key);
        Http2ClientChannel http2ClientChannel = null;
        if (perRouteConnectionPool != null) {
            http2ClientChannel = perRouteConnectionPool.fetchTargetChannel();
        }
        return http2ClientChannel;
    }

    private PerRouteConnectionPool fetchConnectionPool(String key) {
        return connectionPools.get(key);
    }

    private void registerConnectionPool(String key, PerRouteConnectionPool perRouteConnectionPool) {
        connectionPools.put(key, perRouteConnectionPool);
    }

    private String generateKey(HttpRoute httpRoute) {
        return httpRoute.getHost() + ":" + httpRoute.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHttp2ClientChannel(HttpRoute httpRoute, Http2ClientChannel http2ClientChannel) {
        String key = this.generateKey(httpRoute);
        PerRouteConnectionPool perRouteConnectionPool = this.fetchConnectionPool(key);
        if (perRouteConnectionPool != null) {
            perRouteConnectionPool.addChannel(http2ClientChannel);
        } else {
            this.lock.lock();
            try {
                perRouteConnectionPool = this.fetchConnectionPool(key);
                if (perRouteConnectionPool == null) {
                    perRouteConnectionPool = new PerRouteConnectionPool(this.senderConfig.getPoolConfiguration().getHttp2MaxActiveStreamsPerConnection());
                    this.registerConnectionPool(key, perRouteConnectionPool);
                }
                perRouteConnectionPool.addChannel(http2ClientChannel);
            }
            finally {
                this.lock.unlock();
            }
        }
        http2ClientChannel.getChannel().closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
            PerRouteConnectionPool pool = connectionPools.get(key);
            if (pool != null) {
                pool.removeChannel(http2ClientChannel);
                http2ClientChannel.getDataEventListeners().forEach(Http2DataEventListener::destroy);
            }
        }));
    }

    void returnClientChannel(HttpRoute httpRoute, Http2ClientChannel http2ClientChannel) {
        String key = this.generateKey(httpRoute);
        PerRouteConnectionPool perRouteConnectionPool = this.fetchConnectionPool(key);
        if (perRouteConnectionPool != null) {
            perRouteConnectionPool.addChannel(http2ClientChannel);
        }
    }

    private static class PerRouteConnectionPool {
        private BlockingQueue<Http2ClientChannel> http2ClientChannels = new LinkedBlockingQueue<Http2ClientChannel>();
        private int maxActiveStreams;

        public PerRouteConnectionPool() {
            this.maxActiveStreams = Integer.MAX_VALUE;
        }

        public PerRouteConnectionPool(int maxActiveStreams) {
            this.maxActiveStreams = maxActiveStreams;
        }

        Http2ClientChannel fetchTargetChannel() {
            if (this.http2ClientChannels.size() != 0) {
                Http2ClientChannel http2ClientChannel = (Http2ClientChannel)this.http2ClientChannels.peek();
                Channel channel = http2ClientChannel.getChannel();
                if (!channel.isActive()) {
                    this.http2ClientChannels.remove(http2ClientChannel);
                    return this.fetchTargetChannel();
                }
                int activeSteamCount = http2ClientChannel.incrementActiveStreamCount();
                if (activeSteamCount < this.maxActiveStreams) {
                    return http2ClientChannel;
                }
                if (activeSteamCount == this.maxActiveStreams) {
                    http2ClientChannel.markAsExhausted();
                    this.http2ClientChannels.remove(http2ClientChannel);
                    return http2ClientChannel;
                }
                this.http2ClientChannels.remove(http2ClientChannel);
                return this.fetchTargetChannel();
            }
            return null;
        }

        void addChannel(Http2ClientChannel http2ClientChannel) {
            this.http2ClientChannels.add(http2ClientChannel);
        }

        void removeChannel(Http2ClientChannel http2ClientChannel) {
            this.http2ClientChannels.remove(http2ClientChannel);
        }
    }
}

