/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.listener;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoop;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.timeout.IdleStateEvent;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.config.ChunkConfig;
import org.wso2.transport.http.netty.config.KeepAliveConfig;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.HttpOutboundRespListener;
import org.wso2.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.transport.http.netty.internal.HandlerExecutor;
import org.wso2.transport.http.netty.message.DefaultListener;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.message.HttpCarbonRequest;
import org.wso2.transport.http.netty.message.Listener;
import org.wso2.transport.http.netty.message.PooledDataStreamerFactory;

public class SourceHandler
extends ChannelInboundHandlerAdapter {
    private static Logger log = LoggerFactory.getLogger(SourceHandler.class);
    private HTTPCarbonMessage sourceReqCmsg;
    private HandlerExecutor handlerExecutor;
    private Map<String, GenericObjectPool> targetChannelPool;
    private ServerConnectorFuture serverConnectorFuture;
    private ChunkConfig chunkConfig;
    private KeepAliveConfig keepAliveConfig;
    private HttpResponseFuture httpOutboundRespFuture;
    private String interfaceId;
    private String serverName;
    private boolean idleTimeout;
    private ChannelGroup allChannels;
    protected ChannelHandlerContext ctx;
    private SocketAddress remoteAddress;

    public SourceHandler(ServerConnectorFuture serverConnectorFuture, String interfaceId, ChunkConfig chunkConfig, KeepAliveConfig keepAliveConfig, String serverName, ChannelGroup allChannels) {
        this.serverConnectorFuture = serverConnectorFuture;
        this.interfaceId = interfaceId;
        this.chunkConfig = chunkConfig;
        this.keepAliveConfig = keepAliveConfig;
        this.targetChannelPool = new ConcurrentHashMap<String, GenericObjectPool>();
        this.idleTimeout = false;
        this.serverName = serverName;
        this.allChannels = allChannels;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.allChannels.add(ctx.channel());
        this.handlerExecutor = HTTPTransportContextHolder.getInstance().getHandlerExecutor();
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtSourceConnectionInitiation(Integer.toString(ctx.hashCode()));
        }
        this.ctx = ctx;
        this.remoteAddress = ctx.channel().remoteAddress();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            this.sourceReqCmsg = this.setupCarbonMessage(httpRequest, ctx);
            this.notifyRequestListener(this.sourceReqCmsg, ctx);
            if (httpRequest.decoderResult().isFailure()) {
                log.warn(httpRequest.decoderResult().cause().getMessage());
            }
        } else if (this.sourceReqCmsg != null) {
            if (msg instanceof HttpContent) {
                HttpContent httpContent = (HttpContent)msg;
                this.sourceReqCmsg.addHttpContent(httpContent);
                if (Util.isLastHttpContent(httpContent)) {
                    if (this.handlerExecutor != null) {
                        this.handlerExecutor.executeAtSourceRequestSending(this.sourceReqCmsg);
                    }
                    if (this.isDiffered(this.sourceReqCmsg)) {
                        this.serverConnectorFuture.notifyHttpListener(this.sourceReqCmsg);
                    }
                    this.httpOutboundRespFuture = this.sourceReqCmsg.getHttpOutboundRespStatusFuture();
                    this.sourceReqCmsg = null;
                }
            }
        } else {
            log.warn("Inconsistent state detected : sourceReqCmsg is null for channel read event");
        }
    }

    private HTTPCarbonMessage setupCarbonMessage(HttpMessage httpMessage, ChannelHandlerContext ctx) throws URISyntaxException {
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtSourceRequestReceiving(this.sourceReqCmsg);
        }
        this.sourceReqCmsg = new HttpCarbonRequest((HttpRequest)httpMessage, (Listener)new DefaultListener(ctx));
        this.sourceReqCmsg.setProperty("POOLED_BYTE_BUFFER_FACTORY", new PooledDataStreamerFactory(ctx.alloc()));
        HttpRequest httpRequest = (HttpRequest)httpMessage;
        this.sourceReqCmsg.setProperty("CHNL_HNDLR_CTX", this.ctx);
        this.sourceReqCmsg.setProperty("SRC_HANDLER", this);
        HttpVersion protocolVersion = httpRequest.protocolVersion();
        this.sourceReqCmsg.setProperty("HTTP_VERSION", protocolVersion.majorVersion() + "." + protocolVersion.minorVersion());
        this.sourceReqCmsg.setProperty("HTTP_METHOD", httpRequest.method().name());
        InetSocketAddress localAddress = null;
        if (ctx.channel().localAddress() instanceof InetSocketAddress) {
            localAddress = (InetSocketAddress)ctx.channel().localAddress();
        }
        this.sourceReqCmsg.setProperty("LISTENER_PORT", localAddress != null ? Integer.valueOf(localAddress.getPort()) : null);
        this.sourceReqCmsg.setProperty("listener.interface.id", this.interfaceId);
        this.sourceReqCmsg.setProperty("PROTOCOL", "http");
        boolean isSecuredConnection = false;
        if (ctx.channel().pipeline().get("ssl") != null) {
            isSecuredConnection = true;
        }
        this.sourceReqCmsg.setProperty("IS_SECURED_CONNECTION", isSecuredConnection);
        this.sourceReqCmsg.setProperty("LOCAL_ADDRESS", ctx.channel().localAddress());
        this.sourceReqCmsg.setProperty("REMOTE_ADDRESS", this.remoteAddress);
        this.sourceReqCmsg.setProperty("REQUEST_URL", httpRequest.uri());
        this.sourceReqCmsg.setProperty("TO", httpRequest.uri());
        return this.sourceReqCmsg;
    }

    private void notifyRequestListener(HTTPCarbonMessage httpRequestMsg, ChannelHandlerContext ctx) throws URISyntaxException {
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtSourceRequestReceiving(httpRequestMsg);
        }
        if (this.serverConnectorFuture != null) {
            try {
                ServerConnectorFuture outboundRespFuture = httpRequestMsg.getHttpResponseFuture();
                outboundRespFuture.setHttpConnectorListener(new HttpOutboundRespListener(ctx, httpRequestMsg, this.chunkConfig, this.keepAliveConfig, this.serverName));
                this.serverConnectorFuture.notifyHttpListener(httpRequestMsg);
            }
            catch (Exception e) {
                log.error("Error while notifying listeners", e);
            }
        } else {
            log.error("Cannot find registered listener to forward the message");
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.close();
        this.handleErrorCloseScenario(ctx);
        this.closeTargetChannels();
    }

    private void handleErrorCloseScenario(ChannelHandlerContext ctx) {
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtSourceConnectionTermination(Integer.toString(ctx.hashCode()));
            this.handlerExecutor = null;
        }
        if (this.sourceReqCmsg != null && !this.idleTimeout) {
            this.handleIncompleteInboundRequest("Remote client closed the connection without completing inbound request");
        }
    }

    private void closeTargetChannels() {
        this.targetChannelPool.forEach((hostPortKey, genericObjectPool) -> {
            try {
                this.targetChannelPool.remove(hostPortKey).close();
            }
            catch (Exception e) {
                log.error("Couldn't close target channel socket connections", e);
            }
        });
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (ctx != null && ctx.channel().isActive()) {
            ctx.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
        if (this.sourceReqCmsg != null) {
            this.handleIncompleteInboundRequest("Exception caught while reading inbound request");
        }
        this.serverConnectorFuture.notifyErrorListener(cause);
    }

    private void handleIncompleteInboundRequest(String errorMessage) {
        DefaultLastHttpContent lastHttpContent = new DefaultLastHttpContent();
        lastHttpContent.setDecoderResult(DecoderResult.failure(new DecoderException(errorMessage)));
        this.sourceReqCmsg.addHttpContent(lastHttpContent);
        log.warn(errorMessage);
    }

    public Map<String, GenericObjectPool> getTargetChannelPool() {
        return this.targetChannelPool;
    }

    public ChannelHandlerContext getInboundChannelContext() {
        return this.ctx;
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            this.idleTimeout = true;
            this.channelInactive(ctx);
            this.handleIdleErrorScenario();
            log.debug("Idle timeout has reached hence closing the connection {}", (Object)ctx.channel().id().asShortText());
        } else if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            log.debug("Server upgrade event received");
        } else if (evt instanceof SslCloseCompletionEvent) {
            log.debug("SSL close completion event received");
        } else if (evt instanceof ChannelInputShutdownReadComplete) {
            log.debug("Input side of the connection is already shutdown");
        } else {
            log.warn("Unexpected user event {} triggered", (Object)evt.toString());
        }
    }

    private void handleIdleErrorScenario() {
        if (this.sourceReqCmsg == null) {
            this.httpOutboundRespFuture.notifyHttpListener(new ServerConnectorException("Idle timeout triggered while writing outbound response"));
        } else {
            this.handleIncompleteInboundRequest("Idle timeout triggered while reading inbound request");
        }
    }

    private boolean isDiffered(HTTPCarbonMessage sourceReqCmsg) {
        return sourceReqCmsg.getProperty("httpResource") != null;
    }

    public EventLoop getEventLoop() {
        return this.ctx.channel().eventLoop();
    }
}

