/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.config;

import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;

public class HystrixCommandConfiguration {
    private static final String VERSION = "1";
    private final HystrixCommandKey commandKey;
    private final HystrixThreadPoolKey threadPoolKey;
    private final HystrixCommandGroupKey groupKey;
    private final HystrixCommandExecutionConfig executionConfig;
    private final HystrixCommandCircuitBreakerConfig circuitBreakerConfig;
    private final HystrixCommandMetricsConfig metricsConfig;

    private HystrixCommandConfiguration(HystrixCommandKey commandKey, HystrixThreadPoolKey threadPoolKey, HystrixCommandGroupKey groupKey, HystrixCommandExecutionConfig executionConfig, HystrixCommandCircuitBreakerConfig circuitBreakerConfig, HystrixCommandMetricsConfig metricsConfig) {
        this.commandKey = commandKey;
        this.threadPoolKey = threadPoolKey;
        this.groupKey = groupKey;
        this.executionConfig = executionConfig;
        this.circuitBreakerConfig = circuitBreakerConfig;
        this.metricsConfig = metricsConfig;
    }

    public static HystrixCommandConfiguration sample(HystrixCommandKey commandKey, HystrixThreadPoolKey threadPoolKey, HystrixCommandGroupKey groupKey, HystrixCommandProperties commandProperties) {
        HystrixCommandExecutionConfig executionConfig = new HystrixCommandExecutionConfig(commandProperties.executionIsolationSemaphoreMaxConcurrentRequests().get(), commandProperties.executionIsolationStrategy().get(), commandProperties.executionIsolationThreadInterruptOnTimeout().get(), commandProperties.executionIsolationThreadPoolKeyOverride().get(), commandProperties.executionTimeoutEnabled().get(), commandProperties.executionTimeoutInMilliseconds().get(), commandProperties.fallbackEnabled().get(), commandProperties.fallbackIsolationSemaphoreMaxConcurrentRequests().get(), commandProperties.requestCacheEnabled().get(), commandProperties.requestLogEnabled().get());
        HystrixCommandCircuitBreakerConfig circuitBreakerConfig = new HystrixCommandCircuitBreakerConfig(commandProperties.circuitBreakerEnabled().get(), commandProperties.circuitBreakerErrorThresholdPercentage().get(), commandProperties.circuitBreakerForceClosed().get(), commandProperties.circuitBreakerForceOpen().get(), commandProperties.circuitBreakerRequestVolumeThreshold().get(), commandProperties.circuitBreakerSleepWindowInMilliseconds().get());
        HystrixCommandMetricsConfig metricsConfig = new HystrixCommandMetricsConfig(commandProperties.metricsHealthSnapshotIntervalInMilliseconds().get(), commandProperties.metricsRollingPercentileEnabled().get(), commandProperties.metricsRollingPercentileWindowBuckets().get(), commandProperties.metricsRollingPercentileWindowInMilliseconds().get(), commandProperties.metricsRollingStatisticalWindowBuckets().get(), commandProperties.metricsRollingStatisticalWindowInMilliseconds().get());
        return new HystrixCommandConfiguration(commandKey, threadPoolKey, groupKey, executionConfig, circuitBreakerConfig, metricsConfig);
    }

    public HystrixThreadPoolKey getThreadPoolKey() {
        return this.threadPoolKey;
    }

    public HystrixCommandGroupKey getGroupKey() {
        return this.groupKey;
    }

    public HystrixCommandExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    public HystrixCommandCircuitBreakerConfig getCircuitBreakerConfig() {
        return this.circuitBreakerConfig;
    }

    public HystrixCommandMetricsConfig getMetricsConfig() {
        return this.metricsConfig;
    }

    public static class HystrixCommandMetricsConfig {
        private final int healthIntervalInMilliseconds;
        private final boolean rollingPercentileEnabled;
        private final int rollingPercentileNumberOfBuckets;
        private final int rollingPercentileBucketSizeInMilliseconds;
        private final int rollingCounterNumberOfBuckets;
        private final int rollingCounterBucketSizeInMilliseconds;

        public HystrixCommandMetricsConfig(int healthIntervalInMilliseconds, boolean rollingPercentileEnabled, int rollingPercentileNumberOfBuckets, int rollingPercentileBucketSizeInMilliseconds, int rollingCounterNumberOfBuckets, int rollingCounterBucketSizeInMilliseconds) {
            this.healthIntervalInMilliseconds = healthIntervalInMilliseconds;
            this.rollingPercentileEnabled = rollingPercentileEnabled;
            this.rollingPercentileNumberOfBuckets = rollingPercentileNumberOfBuckets;
            this.rollingPercentileBucketSizeInMilliseconds = rollingPercentileBucketSizeInMilliseconds;
            this.rollingCounterNumberOfBuckets = rollingCounterNumberOfBuckets;
            this.rollingCounterBucketSizeInMilliseconds = rollingCounterBucketSizeInMilliseconds;
        }

        public int getHealthIntervalInMilliseconds() {
            return this.healthIntervalInMilliseconds;
        }

        public boolean isRollingPercentileEnabled() {
            return this.rollingPercentileEnabled;
        }

        public int getRollingPercentileNumberOfBuckets() {
            return this.rollingPercentileNumberOfBuckets;
        }

        public int getRollingPercentileBucketSizeInMilliseconds() {
            return this.rollingPercentileBucketSizeInMilliseconds;
        }

        public int getRollingCounterNumberOfBuckets() {
            return this.rollingCounterNumberOfBuckets;
        }

        public int getRollingCounterBucketSizeInMilliseconds() {
            return this.rollingCounterBucketSizeInMilliseconds;
        }
    }

    public static class HystrixCommandExecutionConfig {
        private final int semaphoreMaxConcurrentRequests;
        private final HystrixCommandProperties.ExecutionIsolationStrategy isolationStrategy;
        private final boolean threadInterruptOnTimeout;
        private final String threadPoolKeyOverride;
        private final boolean timeoutEnabled;
        private final int timeoutInMilliseconds;
        private final boolean fallbackEnabled;
        private final int fallbackMaxConcurrentRequest;
        private final boolean requestCacheEnabled;
        private final boolean requestLogEnabled;

        public HystrixCommandExecutionConfig(int semaphoreMaxConcurrentRequests, HystrixCommandProperties.ExecutionIsolationStrategy isolationStrategy, boolean threadInterruptOnTimeout, String threadPoolKeyOverride, boolean timeoutEnabled, int timeoutInMilliseconds, boolean fallbackEnabled, int fallbackMaxConcurrentRequests, boolean requestCacheEnabled, boolean requestLogEnabled) {
            this.semaphoreMaxConcurrentRequests = semaphoreMaxConcurrentRequests;
            this.isolationStrategy = isolationStrategy;
            this.threadInterruptOnTimeout = threadInterruptOnTimeout;
            this.threadPoolKeyOverride = threadPoolKeyOverride;
            this.timeoutEnabled = timeoutEnabled;
            this.timeoutInMilliseconds = timeoutInMilliseconds;
            this.fallbackEnabled = fallbackEnabled;
            this.fallbackMaxConcurrentRequest = fallbackMaxConcurrentRequests;
            this.requestCacheEnabled = requestCacheEnabled;
            this.requestLogEnabled = requestLogEnabled;
        }

        public int getSemaphoreMaxConcurrentRequests() {
            return this.semaphoreMaxConcurrentRequests;
        }

        public HystrixCommandProperties.ExecutionIsolationStrategy getIsolationStrategy() {
            return this.isolationStrategy;
        }

        public boolean isThreadInterruptOnTimeout() {
            return this.threadInterruptOnTimeout;
        }

        public String getThreadPoolKeyOverride() {
            return this.threadPoolKeyOverride;
        }

        public boolean isTimeoutEnabled() {
            return this.timeoutEnabled;
        }

        public int getTimeoutInMilliseconds() {
            return this.timeoutInMilliseconds;
        }

        public boolean isFallbackEnabled() {
            return this.fallbackEnabled;
        }

        public int getFallbackMaxConcurrentRequest() {
            return this.fallbackMaxConcurrentRequest;
        }

        public boolean isRequestCacheEnabled() {
            return this.requestCacheEnabled;
        }

        public boolean isRequestLogEnabled() {
            return this.requestLogEnabled;
        }
    }

    public static class HystrixCommandCircuitBreakerConfig {
        private final boolean enabled;
        private final int errorThresholdPercentage;
        private final boolean forceClosed;
        private final boolean forceOpen;
        private final int requestVolumeThreshold;
        private final int sleepWindowInMilliseconds;

        public HystrixCommandCircuitBreakerConfig(boolean enabled, int errorThresholdPercentage, boolean forceClosed, boolean forceOpen, int requestVolumeThreshold, int sleepWindowInMilliseconds) {
            this.enabled = enabled;
            this.errorThresholdPercentage = errorThresholdPercentage;
            this.forceClosed = forceClosed;
            this.forceOpen = forceOpen;
            this.requestVolumeThreshold = requestVolumeThreshold;
            this.sleepWindowInMilliseconds = sleepWindowInMilliseconds;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getErrorThresholdPercentage() {
            return this.errorThresholdPercentage;
        }

        public boolean isForceClosed() {
            return this.forceClosed;
        }

        public boolean isForceOpen() {
            return this.forceOpen;
        }

        public int getRequestVolumeThreshold() {
            return this.requestVolumeThreshold;
        }

        public int getSleepWindowInMilliseconds() {
            return this.sleepWindowInMilliseconds;
        }
    }
}

