/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric;

import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.metric.HystrixCommandCompletion;
import com.netflix.hystrix.metric.HystrixEventStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import rx.Observable;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;

public class HystrixThreadPoolCompletionStream
implements HystrixEventStream<HystrixCommandCompletion> {
    private final HystrixThreadPoolKey threadPoolKey;
    private final Subject<HystrixCommandCompletion, HystrixCommandCompletion> writeOnlySubject;
    private final Observable<HystrixCommandCompletion> readOnlyStream;
    private static final ConcurrentMap<String, HystrixThreadPoolCompletionStream> streams = new ConcurrentHashMap<String, HystrixThreadPoolCompletionStream>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HystrixThreadPoolCompletionStream getInstance(HystrixThreadPoolKey threadPoolKey) {
        HystrixThreadPoolCompletionStream initialStream = (HystrixThreadPoolCompletionStream)streams.get(threadPoolKey.name());
        if (initialStream != null) {
            return initialStream;
        }
        Class<HystrixThreadPoolCompletionStream> clazz = HystrixThreadPoolCompletionStream.class;
        synchronized (HystrixThreadPoolCompletionStream.class) {
            HystrixThreadPoolCompletionStream existingStream = (HystrixThreadPoolCompletionStream)streams.get(threadPoolKey.name());
            if (existingStream == null) {
                HystrixThreadPoolCompletionStream newStream = new HystrixThreadPoolCompletionStream(threadPoolKey);
                streams.putIfAbsent(threadPoolKey.name(), newStream);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return newStream;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return existingStream;
        }
    }

    HystrixThreadPoolCompletionStream(HystrixThreadPoolKey threadPoolKey) {
        this.threadPoolKey = threadPoolKey;
        this.writeOnlySubject = new SerializedSubject<HystrixCommandCompletion, HystrixCommandCompletion>(PublishSubject.create());
        this.readOnlyStream = this.writeOnlySubject.share();
    }

    public static void reset() {
        streams.clear();
    }

    public void write(HystrixCommandCompletion event) {
        this.writeOnlySubject.onNext(event);
    }

    @Override
    public Observable<HystrixCommandCompletion> observe() {
        return this.readOnlyStream;
    }

    public String toString() {
        return "HystrixThreadPoolCompletionStream(" + this.threadPoolKey.name() + ")";
    }
}

