/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config.util;

import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.ConcurrentMapConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.Configuration;

public class ConfigurationUtils {
    public static ConcurrentCompositeConfiguration convertToConcurrentCompositeConfiguration(CombinedConfiguration combinedConfiguration) {
        Object object;
        ConcurrentCompositeConfiguration concurrentCompositeConfiguration = new ConcurrentCompositeConfiguration();
        IdentityHashMap<Configuration, String> identityHashMap = new IdentityHashMap<Configuration, String>();
        for (String object2 : combinedConfiguration.getConfigurationNames()) {
            object = combinedConfiguration.getConfiguration(object2);
            identityHashMap.put((Configuration)object, object2);
        }
        for (int i = 0; i < combinedConfiguration.getNumberOfConfigurations(); ++i) {
            AbstractConfiguration abstractConfiguration;
            Configuration configuration = combinedConfiguration.getConfiguration(i);
            object = (String)identityHashMap.get(configuration);
            if (configuration instanceof CombinedConfiguration) {
                abstractConfiguration = (CombinedConfiguration)configuration;
                ConcurrentCompositeConfiguration concurrentCompositeConfiguration2 = ConfigurationUtils.convertToConcurrentCompositeConfiguration(abstractConfiguration);
                concurrentCompositeConfiguration.addConfiguration(concurrentCompositeConfiguration2, (String)object);
                continue;
            }
            abstractConfiguration = new ConcurrentMapConfiguration(configuration);
            concurrentCompositeConfiguration.addConfiguration(abstractConfiguration, (String)object);
        }
        return concurrentCompositeConfiguration;
    }

    public static Map<String, Configuration> getAllNamedConfiguration(Configuration configuration) {
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        HashMap<String, Configuration> hashMap = new HashMap<String, Configuration>();
        arrayList.add(configuration);
        while (!arrayList.isEmpty()) {
            AbstractConfiguration abstractConfiguration;
            Configuration configuration2 = (Configuration)arrayList.remove(0);
            if (configuration2 instanceof ConcurrentCompositeConfiguration) {
                abstractConfiguration = (ConcurrentCompositeConfiguration)configuration2;
                for (String string : ((ConcurrentCompositeConfiguration)abstractConfiguration).getConfigurationNames()) {
                    hashMap.put(string, ((ConcurrentCompositeConfiguration)abstractConfiguration).getConfiguration(string));
                }
                for (AbstractConfiguration abstractConfiguration2 : ((ConcurrentCompositeConfiguration)abstractConfiguration).getConfigurations()) {
                    arrayList.add(abstractConfiguration2);
                }
                continue;
            }
            if (!(configuration2 instanceof CombinedConfiguration)) continue;
            abstractConfiguration = (CombinedConfiguration)configuration2;
            for (String string : ((CombinedConfiguration)abstractConfiguration).getConfigurationNames()) {
                hashMap.put(string, ((CombinedConfiguration)abstractConfiguration).getConfiguration(string));
            }
            for (int i = 0; i < ((CombinedConfiguration)abstractConfiguration).getNumberOfConfigurations(); ++i) {
                arrayList.add(((CombinedConfiguration)abstractConfiguration).getConfiguration(i));
            }
        }
        return hashMap;
    }

    public static Properties getProperties(AbstractConfiguration abstractConfiguration) {
        Properties properties = new Properties();
        if (abstractConfiguration != null) {
            Iterator<String> iterator = abstractConfiguration.getKeys();
            while (iterator.hasNext()) {
                String string = iterator.next();
                properties.put(string, abstractConfiguration.getString(string));
            }
        }
        return properties;
    }

    public static void loadProperties(Properties properties, Configuration configuration) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            configuration.setProperty((String)entry.getKey(), entry.getValue());
        }
    }
}

