/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.collapser;

import com.netflix.hystrix.HystrixCollapser;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Subscriber;
import rx.subjects.PublishSubject;

class CollapsedRequestObservableFunction<T, R>
implements HystrixCollapser.CollapsedRequest<T, R>,
Observable.OnSubscribe<T> {
    private final R argument;
    private AtomicBoolean valueSet = new AtomicBoolean(false);
    private final PublishSubject<T> responseSubject = PublishSubject.create();

    public CollapsedRequestObservableFunction(R arg) {
        this.argument = arg;
    }

    @Override
    public void call(Subscriber<? super T> observer) {
        this.responseSubject.unsafeSubscribe(observer);
    }

    @Override
    public R getArgument() {
        return this.argument;
    }

    @Override
    public void setResponse(T response) {
        if (this.isTerminated()) {
            throw new IllegalStateException("Response has already terminated so response can not be set : " + response);
        }
        this.responseSubject.onNext(response);
        this.valueSet.set(true);
        this.responseSubject.onCompleted();
    }

    @Override
    public void emitResponse(T response) {
        if (this.isTerminated()) {
            throw new IllegalStateException("Response has already terminated so response can not be set : " + response);
        }
        this.responseSubject.onNext(response);
        this.valueSet.set(true);
    }

    @Override
    public void setComplete() {
        if (!this.isTerminated()) {
            this.responseSubject.onCompleted();
        }
    }

    public void setExceptionIfResponseNotReceived(Exception e) {
        if (!this.valueSet.get() && !this.isTerminated()) {
            this.responseSubject.onError(e);
        }
    }

    public Exception setExceptionIfResponseNotReceived(Exception e, String exceptionMessage) {
        Exception exception = e;
        if (!this.valueSet.get() && !this.isTerminated()) {
            if (e == null) {
                exception = new IllegalStateException(exceptionMessage);
            }
            this.setExceptionIfResponseNotReceived(exception);
        }
        return exception;
    }

    @Override
    public void setException(Exception e) {
        if (this.isTerminated()) {
            throw new IllegalStateException("Response has already terminated so exception can not be set", e);
        }
        this.responseSubject.onError(e);
    }

    private boolean isTerminated() {
        return this.responseSubject.hasCompleted() || this.responseSubject.hasThrowable();
    }
}

