/*
 * Decompiled with CFR 0.152.
 */
package org.example.service;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import org.example.service.Stock;
import org.example.service.StockQuoteDatabase;

public class CircuitBreakerCommand
extends HystrixCommand<Stock> {
    private StockQuoteDatabase db;
    private final String symbol;

    CircuitBreakerCommand(StockQuoteDatabase db, String symbol) {
        super(HystrixCommand.Setter.withGroupKey(HystrixCommandGroupKey.Factory.asKey("MyGroup")).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withCircuitBreakerEnabled(true).withCircuitBreakerRequestVolumeThreshold(50).withExecutionTimeoutEnabled(true).withExecutionTimeoutInMilliseconds(10)));
        this.db = db;
        this.symbol = symbol;
    }

    @Override
    protected Stock run() {
        this.printMetrics();
        return this.db.getStock(this.symbol);
    }

    @Override
    protected Stock getFallback() {
        if (this.isCircuitBreakerOpen()) {
            System.out.println("Circuit is open");
        }
        this.printMetrics();
        return this.db.getCachedStock(this.symbol);
    }

    private void printMetrics() {
        HystrixCommandMetrics metrics = HystrixCommandMetrics.getInstance(HystrixCommandKey.Factory.asKey(this.getClass().getSimpleName()));
        StringBuilder m = new StringBuilder();
        if (metrics != null) {
            HystrixCommandMetrics.HealthCounts health = metrics.getHealthCounts();
            m.append("Requests: ").append(health.getTotalRequests()).append(" ");
            m.append("Errors: ").append(health.getErrorCount()).append(" (").append(health.getErrorPercentage()).append("%)   ");
            m.append("Mean: ").append(metrics.getExecutionTimePercentile(50.0)).append(" ");
            m.append("75th: ").append(metrics.getExecutionTimePercentile(75.0)).append(" ");
            m.append("90th: ").append(metrics.getExecutionTimePercentile(90.0)).append(" ");
            m.append("99th: ").append(metrics.getExecutionTimePercentile(99.0)).append(" ");
        }
        System.out.println(m);
    }
}

