/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesChainedProperty;
import com.netflix.hystrix.strategy.properties.HystrixProperty;

public abstract class HystrixThreadPoolProperties {
    private Integer default_coreSize = 10;
    private Integer default_keepAliveTimeMinutes = 1;
    private Integer default_maxQueueSize = -1;
    private Integer default_queueSizeRejectionThreshold = 5;
    private Integer default_threadPoolRollingNumberStatisticalWindow = 10000;
    private Integer default_threadPoolRollingNumberStatisticalWindowBuckets = 10;
    private final HystrixProperty<Integer> corePoolSize;
    private final HystrixProperty<Integer> keepAliveTime;
    private final HystrixProperty<Integer> maxQueueSize;
    private final HystrixProperty<Integer> queueSizeRejectionThreshold;
    private final HystrixProperty<Integer> threadPoolRollingNumberStatisticalWindowInMilliseconds;
    private final HystrixProperty<Integer> threadPoolRollingNumberStatisticalWindowBuckets;

    protected HystrixThreadPoolProperties(HystrixThreadPoolKey key) {
        this(key, new Setter(), "hystrix");
    }

    protected HystrixThreadPoolProperties(HystrixThreadPoolKey key, Setter builder) {
        this(key, builder, "hystrix");
    }

    protected HystrixThreadPoolProperties(HystrixThreadPoolKey key, Setter builder, String propertyPrefix) {
        this.corePoolSize = HystrixThreadPoolProperties.getProperty(propertyPrefix, key, "coreSize", builder.getCoreSize(), this.default_coreSize);
        this.keepAliveTime = HystrixThreadPoolProperties.getProperty(propertyPrefix, key, "keepAliveTimeMinutes", builder.getKeepAliveTimeMinutes(), this.default_keepAliveTimeMinutes);
        this.maxQueueSize = HystrixThreadPoolProperties.getProperty(propertyPrefix, key, "maxQueueSize", builder.getMaxQueueSize(), this.default_maxQueueSize);
        this.queueSizeRejectionThreshold = HystrixThreadPoolProperties.getProperty(propertyPrefix, key, "queueSizeRejectionThreshold", builder.getQueueSizeRejectionThreshold(), this.default_queueSizeRejectionThreshold);
        this.threadPoolRollingNumberStatisticalWindowInMilliseconds = HystrixThreadPoolProperties.getProperty(propertyPrefix, key, "metrics.rollingStats.timeInMilliseconds", builder.getMetricsRollingStatisticalWindowInMilliseconds(), this.default_threadPoolRollingNumberStatisticalWindow);
        this.threadPoolRollingNumberStatisticalWindowBuckets = HystrixThreadPoolProperties.getProperty(propertyPrefix, key, "metrics.rollingStats.numBuckets", builder.getMetricsRollingStatisticalWindowBuckets(), this.default_threadPoolRollingNumberStatisticalWindowBuckets);
    }

    private static HystrixProperty<Integer> getProperty(String propertyPrefix, HystrixThreadPoolKey key, String instanceProperty, Integer builderOverrideValue, Integer defaultValue) {
        return HystrixPropertiesChainedProperty.forInteger().add(propertyPrefix + ".threadpool." + key.name() + "." + instanceProperty, builderOverrideValue).add(propertyPrefix + ".threadpool.default." + instanceProperty, defaultValue).build();
    }

    private static HystrixProperty<Boolean> getProperty(String propertyPrefix, HystrixThreadPoolKey key, String instanceProperty, Boolean builderOverrideValue, Boolean defaultValue) {
        return HystrixPropertiesChainedProperty.forBoolean().add(propertyPrefix + ".threadpool." + key.name() + "." + instanceProperty, builderOverrideValue).add(propertyPrefix + ".threadpool.default." + instanceProperty, defaultValue).build();
    }

    private static HystrixProperty<String> getProperty(String propertyPrefix, HystrixThreadPoolKey key, String instanceProperty, String builderOverrideValue, String defaultValue) {
        return HystrixPropertiesChainedProperty.forString().add(propertyPrefix + ".threadpool." + key.name() + "." + instanceProperty, builderOverrideValue).add(propertyPrefix + ".threadpool.default." + instanceProperty, defaultValue).build();
    }

    public HystrixProperty<Integer> coreSize() {
        return this.corePoolSize;
    }

    public HystrixProperty<Integer> keepAliveTimeMinutes() {
        return this.keepAliveTime;
    }

    public HystrixProperty<Integer> maxQueueSize() {
        return this.maxQueueSize;
    }

    public HystrixProperty<Integer> queueSizeRejectionThreshold() {
        return this.queueSizeRejectionThreshold;
    }

    public HystrixProperty<Integer> metricsRollingStatisticalWindowInMilliseconds() {
        return this.threadPoolRollingNumberStatisticalWindowInMilliseconds;
    }

    public HystrixProperty<Integer> metricsRollingStatisticalWindowBuckets() {
        return this.threadPoolRollingNumberStatisticalWindowBuckets;
    }

    public static Setter Setter() {
        return new Setter();
    }

    public static Setter defaultSetter() {
        return HystrixThreadPoolProperties.Setter();
    }

    public static class Setter {
        private Integer coreSize = null;
        private Integer keepAliveTimeMinutes = null;
        private Integer maxQueueSize = null;
        private Integer queueSizeRejectionThreshold = null;
        private Integer rollingStatisticalWindowInMilliseconds = null;
        private Integer rollingStatisticalWindowBuckets = null;

        private Setter() {
        }

        public Integer getCoreSize() {
            return this.coreSize;
        }

        public Integer getKeepAliveTimeMinutes() {
            return this.keepAliveTimeMinutes;
        }

        public Integer getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public Integer getQueueSizeRejectionThreshold() {
            return this.queueSizeRejectionThreshold;
        }

        public Integer getMetricsRollingStatisticalWindowInMilliseconds() {
            return this.rollingStatisticalWindowInMilliseconds;
        }

        public Integer getMetricsRollingStatisticalWindowBuckets() {
            return this.rollingStatisticalWindowBuckets;
        }

        public Setter withCoreSize(int value) {
            this.coreSize = value;
            return this;
        }

        public Setter withKeepAliveTimeMinutes(int value) {
            this.keepAliveTimeMinutes = value;
            return this;
        }

        public Setter withMaxQueueSize(int value) {
            this.maxQueueSize = value;
            return this;
        }

        public Setter withQueueSizeRejectionThreshold(int value) {
            this.queueSizeRejectionThreshold = value;
            return this;
        }

        public Setter withMetricsRollingStatisticalWindowInMilliseconds(int value) {
            this.rollingStatisticalWindowInMilliseconds = value;
            return this;
        }

        public Setter withMetricsRollingStatisticalWindowBuckets(int value) {
            this.rollingStatisticalWindowBuckets = value;
            return this;
        }

        static Setter getUnitTestPropertiesBuilder() {
            return new Setter().withCoreSize(10).withKeepAliveTimeMinutes(1).withMaxQueueSize(100).withQueueSizeRejectionThreshold(10).withMetricsRollingStatisticalWindowInMilliseconds(10000).withMetricsRollingStatisticalWindowBuckets(10);
        }

        static HystrixThreadPoolProperties asMock(final Setter builder) {
            return new HystrixThreadPoolProperties(TestThreadPoolKey.TEST){

                @Override
                public HystrixProperty<Integer> coreSize() {
                    return HystrixProperty.Factory.asProperty(builder.coreSize);
                }

                @Override
                public HystrixProperty<Integer> keepAliveTimeMinutes() {
                    return HystrixProperty.Factory.asProperty(builder.keepAliveTimeMinutes);
                }

                @Override
                public HystrixProperty<Integer> maxQueueSize() {
                    return HystrixProperty.Factory.asProperty(builder.maxQueueSize);
                }

                @Override
                public HystrixProperty<Integer> queueSizeRejectionThreshold() {
                    return HystrixProperty.Factory.asProperty(builder.queueSizeRejectionThreshold);
                }

                @Override
                public HystrixProperty<Integer> metricsRollingStatisticalWindowInMilliseconds() {
                    return HystrixProperty.Factory.asProperty(builder.rollingStatisticalWindowInMilliseconds);
                }

                @Override
                public HystrixProperty<Integer> metricsRollingStatisticalWindowBuckets() {
                    return HystrixProperty.Factory.asProperty(builder.rollingStatisticalWindowBuckets);
                }
            };
        }

        private static enum TestThreadPoolKey implements HystrixThreadPoolKey
        {
            TEST;

        }
    }
}

