/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.config;

import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;

public class HystrixThreadPoolConfiguration {
    private static final String VERSION = "1";
    private final HystrixThreadPoolKey threadPoolKey;
    private final int coreSize;
    private final int maxQueueSize;
    private final int queueRejectionThreshold;
    private final int keepAliveTimeInMinutes;
    private final int rollingCounterNumberOfBuckets;
    private final int rollingCounterBucketSizeInMilliseconds;

    private HystrixThreadPoolConfiguration(HystrixThreadPoolKey threadPoolKey, int coreSize, int maxQueueSize, int queueRejectionThreshold, int keepAliveTimeInMinutes, int rollingCounterNumberOfBuckets, int rollingCounterBucketSizeInMilliseconds) {
        this.threadPoolKey = threadPoolKey;
        this.coreSize = coreSize;
        this.maxQueueSize = maxQueueSize;
        this.queueRejectionThreshold = queueRejectionThreshold;
        this.keepAliveTimeInMinutes = keepAliveTimeInMinutes;
        this.rollingCounterNumberOfBuckets = rollingCounterNumberOfBuckets;
        this.rollingCounterBucketSizeInMilliseconds = rollingCounterBucketSizeInMilliseconds;
    }

    public static HystrixThreadPoolConfiguration sample(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties threadPoolProperties) {
        return new HystrixThreadPoolConfiguration(threadPoolKey, threadPoolProperties.coreSize().get(), threadPoolProperties.maxQueueSize().get(), threadPoolProperties.queueSizeRejectionThreshold().get(), threadPoolProperties.keepAliveTimeMinutes().get(), threadPoolProperties.metricsRollingStatisticalWindowBuckets().get(), threadPoolProperties.metricsRollingStatisticalWindowInMilliseconds().get());
    }

    public HystrixThreadPoolKey getThreadPoolKey() {
        return this.threadPoolKey;
    }

    public int getCoreSize() {
        return this.coreSize;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public int getQueueRejectionThreshold() {
        return this.queueRejectionThreshold;
    }

    public int getKeepAliveTimeInMinutes() {
        return this.keepAliveTimeInMinutes;
    }

    public int getRollingCounterNumberOfBuckets() {
        return this.rollingCounterNumberOfBuckets;
    }

    public int getRollingCounterBucketSizeInMilliseconds() {
        return this.rollingCounterBucketSizeInMilliseconds;
    }
}

