/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.util;

import com.netflix.hystrix.strategy.properties.HystrixProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixRollingPercentile {
    private static final Logger logger = LoggerFactory.getLogger(HystrixRollingPercentile.class);
    private static final Time ACTUAL_TIME = new ActualTime();
    private final Time time;
    final BucketCircularArray buckets;
    private final int timeInMilliseconds;
    private final int numberOfBuckets;
    private final int bucketDataLength;
    private final int bucketSizeInMilliseconds;
    private final HystrixProperty<Boolean> enabled;
    volatile PercentileSnapshot currentPercentileSnapshot = new PercentileSnapshot(0);
    private ReentrantLock newBucketLock = new ReentrantLock();

    @Deprecated
    public HystrixRollingPercentile(HystrixProperty<Integer> timeInMilliseconds, HystrixProperty<Integer> numberOfBuckets, HystrixProperty<Integer> bucketDataLength, HystrixProperty<Boolean> enabled) {
        this(timeInMilliseconds.get(), numberOfBuckets.get(), bucketDataLength.get(), enabled);
    }

    public HystrixRollingPercentile(int timeInMilliseconds, int numberOfBuckets, int bucketDataLength, HystrixProperty<Boolean> enabled) {
        this(ACTUAL_TIME, timeInMilliseconds, numberOfBuckets, bucketDataLength, enabled);
    }

    HystrixRollingPercentile(Time time, int timeInMilliseconds, int numberOfBuckets, int bucketDataLength, HystrixProperty<Boolean> enabled) {
        this.time = time;
        this.timeInMilliseconds = timeInMilliseconds;
        this.numberOfBuckets = numberOfBuckets;
        this.bucketDataLength = bucketDataLength;
        this.enabled = enabled;
        if (this.timeInMilliseconds % this.numberOfBuckets != 0) {
            throw new IllegalArgumentException("The timeInMilliseconds must divide equally into numberOfBuckets. For example 1000/10 is ok, 1000/11 is not.");
        }
        this.bucketSizeInMilliseconds = this.timeInMilliseconds / this.numberOfBuckets;
        this.buckets = new BucketCircularArray(this.numberOfBuckets);
    }

    public void addValue(int ... value) {
        if (!this.enabled.get().booleanValue()) {
            return;
        }
        for (int v : value) {
            try {
                this.getCurrentBucket().data.addValue(v);
            }
            catch (Exception e) {
                logger.error("Failed to add value: " + v, e);
            }
        }
    }

    public int getPercentile(double percentile) {
        if (!this.enabled.get().booleanValue()) {
            return -1;
        }
        this.getCurrentBucket();
        return this.getCurrentPercentileSnapshot().getPercentile(percentile);
    }

    public int getMean() {
        if (!this.enabled.get().booleanValue()) {
            return -1;
        }
        this.getCurrentBucket();
        return this.getCurrentPercentileSnapshot().getMean();
    }

    private PercentileSnapshot getCurrentPercentileSnapshot() {
        return this.currentPercentileSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bucket getCurrentBucket() {
        long currentTime = this.time.getCurrentTimeInMillis();
        Bucket currentBucket = this.buckets.peekLast();
        if (currentBucket != null && currentTime < currentBucket.windowStart + (long)this.bucketSizeInMilliseconds) {
            return currentBucket;
        }
        if (this.newBucketLock.tryLock()) {
            try {
                if (this.buckets.peekLast() == null) {
                    Bucket newBucket = new Bucket(currentTime, this.bucketDataLength);
                    this.buckets.addLast(newBucket);
                    Bucket bucket = newBucket;
                    return bucket;
                }
                for (int i = 0; i < this.numberOfBuckets; ++i) {
                    Bucket bucket;
                    Bucket lastBucket = this.buckets.peekLast();
                    if (currentTime < lastBucket.windowStart + (long)this.bucketSizeInMilliseconds) {
                        bucket = lastBucket;
                        return bucket;
                    }
                    if (currentTime - (lastBucket.windowStart + (long)this.bucketSizeInMilliseconds) > (long)this.timeInMilliseconds) {
                        this.reset();
                        bucket = this.getCurrentBucket();
                        return bucket;
                    }
                    Bucket[] allBuckets = this.buckets.getArray();
                    this.buckets.addLast(new Bucket(lastBucket.windowStart + (long)this.bucketSizeInMilliseconds, this.bucketDataLength));
                    this.currentPercentileSnapshot = new PercentileSnapshot(allBuckets);
                }
                Bucket i = this.buckets.peekLast();
                return i;
            }
            finally {
                this.newBucketLock.unlock();
            }
        }
        currentBucket = this.buckets.peekLast();
        if (currentBucket != null) {
            return currentBucket;
        }
        try {
            Thread.sleep(5L);
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.getCurrentBucket();
    }

    public void reset() {
        if (!this.enabled.get().booleanValue()) {
            return;
        }
        this.buckets.clear();
    }

    private static class ActualTime
    implements Time {
        private ActualTime() {
        }

        @Override
        public long getCurrentTimeInMillis() {
            return System.currentTimeMillis();
        }
    }

    static interface Time {
        public long getCurrentTimeInMillis();
    }

    static class Bucket {
        final long windowStart;
        final PercentileBucketData data;

        Bucket(long startTime, int bucketDataLength) {
            this.windowStart = startTime;
            this.data = new PercentileBucketData(bucketDataLength);
        }
    }

    class BucketCircularArray
    implements Iterable<Bucket> {
        private final AtomicReference<ListState> state;
        private final int dataLength;
        private final int numBuckets;

        BucketCircularArray(int size) {
            AtomicReferenceArray _buckets = new AtomicReferenceArray(size + 1);
            this.state = new AtomicReference<ListState>(new ListState(_buckets, 0, 0));
            this.dataLength = _buckets.length();
            this.numBuckets = size;
        }

        public void clear() {
            ListState newState;
            ListState current;
            while (!this.state.compareAndSet(current = this.state.get(), newState = current.clear())) {
            }
        }

        @Override
        public Iterator<Bucket> iterator() {
            return Collections.unmodifiableList(Arrays.asList(this.getArray())).iterator();
        }

        public void addLast(Bucket o) {
            ListState newState;
            ListState currentState = this.state.get();
            if (this.state.compareAndSet(currentState, newState = currentState.addBucket(o))) {
                return;
            }
        }

        public int size() {
            return this.state.get().size;
        }

        public Bucket peekLast() {
            return this.state.get().tail();
        }

        private Bucket[] getArray() {
            return this.state.get().getArray();
        }

        private class ListState {
            private final AtomicReferenceArray<Bucket> data;
            private final int size;
            private final int tail;
            private final int head;

            private ListState(AtomicReferenceArray<Bucket> data, int head, int tail) {
                this.head = head;
                this.tail = tail;
                this.size = head == 0 && tail == 0 ? 0 : (tail + BucketCircularArray.this.dataLength - head) % BucketCircularArray.this.dataLength;
                this.data = data;
            }

            public Bucket tail() {
                if (this.size == 0) {
                    return null;
                }
                return this.data.get(this.convert(this.size - 1));
            }

            private Bucket[] getArray() {
                ArrayList<Bucket> array = new ArrayList<Bucket>();
                for (int i = 0; i < this.size; ++i) {
                    array.add(this.data.get(this.convert(i)));
                }
                return array.toArray(new Bucket[array.size()]);
            }

            private ListState incrementTail() {
                if (this.size == BucketCircularArray.this.numBuckets) {
                    return new ListState(this.data, (this.head + 1) % BucketCircularArray.this.dataLength, (this.tail + 1) % BucketCircularArray.this.dataLength);
                }
                return new ListState(this.data, this.head, (this.tail + 1) % BucketCircularArray.this.dataLength);
            }

            public ListState clear() {
                return new ListState(new AtomicReferenceArray<Bucket>(BucketCircularArray.this.dataLength), 0, 0);
            }

            public ListState addBucket(Bucket b) {
                this.data.set(this.tail, b);
                return this.incrementTail();
            }

            private int convert(int index) {
                return (index + this.head) % BucketCircularArray.this.dataLength;
            }
        }
    }

    static class PercentileSnapshot {
        private final int[] data;
        private final int length;
        private int mean;

        PercentileSnapshot(Bucket[] buckets) {
            int lengthFromBuckets = 0;
            for (Bucket bd : buckets) {
                lengthFromBuckets += bd.data.length;
            }
            this.data = new int[lengthFromBuckets];
            int index = 0;
            int sum = 0;
            for (Bucket bd : buckets) {
                PercentileBucketData pbd = bd.data;
                int length = pbd.length();
                for (int i = 0; i < length; ++i) {
                    int v = pbd.list.get(i);
                    this.data[index++] = v;
                    sum += v;
                }
            }
            this.length = index;
            this.mean = this.length == 0 ? 0 : sum / this.length;
            Arrays.sort(this.data, 0, this.length);
        }

        PercentileSnapshot(int ... data) {
            this.data = data;
            this.length = data.length;
            int sum = 0;
            for (int v : data) {
                sum += v;
            }
            this.mean = sum / this.length;
            Arrays.sort(this.data, 0, this.length);
        }

        int getMean() {
            return this.mean;
        }

        public int getPercentile(double percentile) {
            if (this.length == 0) {
                return 0;
            }
            return this.computePercentile(percentile);
        }

        private int computePercentile(double percent) {
            if (this.length <= 0) {
                return 0;
            }
            if (percent <= 0.0) {
                return this.data[0];
            }
            if (percent >= 100.0) {
                return this.data[this.length - 1];
            }
            double rank = percent / 100.0 * (double)this.length;
            int iLow = (int)Math.floor(rank);
            int iHigh = (int)Math.ceil(rank);
            assert (0 <= iLow && (double)iLow <= rank && rank <= (double)iHigh && iHigh <= this.length);
            assert (iHigh - iLow <= 1);
            if (iHigh >= this.length) {
                return this.data[this.length - 1];
            }
            if (iLow == iHigh) {
                return this.data[iLow];
            }
            return (int)((double)this.data[iLow] + (rank - (double)iLow) * (double)(this.data[iHigh] - this.data[iLow]));
        }
    }

    static class PercentileBucketData {
        private final int length;
        private final AtomicIntegerArray list;
        private final AtomicInteger index = new AtomicInteger();

        public PercentileBucketData(int dataLength) {
            this.length = dataLength;
            this.list = new AtomicIntegerArray(dataLength);
        }

        public void addValue(int ... latency) {
            for (int l : latency) {
                this.list.set(this.index.getAndIncrement() % this.length, l);
            }
        }

        public int length() {
            if (this.index.get() > this.list.length()) {
                return this.list.length();
            }
            return this.index.get();
        }
    }
}

