/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.common.states;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.exceptions.ServerConnectorException;
import org.wso2.transport.http.netty.contractimpl.Http2OutboundRespListener;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.common.states.StateUtil;
import org.wso2.transport.http.netty.contractimpl.listener.http2.Http2SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.http2.InboundMessageHolder;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2DataEventListener;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2TargetHandler;
import org.wso2.transport.http.netty.contractimpl.sender.http2.OutboundMsgHolder;
import org.wso2.transport.http.netty.contractimpl.sender.states.http2.RequestCompleted;
import org.wso2.transport.http.netty.message.Http2DataFrame;
import org.wso2.transport.http.netty.message.Http2InboundContentListener;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.HttpCarbonRequest;
import org.wso2.transport.http.netty.message.Listener;
import org.wso2.transport.http.netty.message.PooledDataStreamerFactory;

public class Http2StateUtil {
    private static final Logger LOG = LoggerFactory.getLogger(Http2StateUtil.class);

    public static void notifyRequestListener(Http2SourceHandler http2SourceHandler, InboundMessageHolder inboundMessageHolder, int streamId) {
        HttpCarbonMessage httpRequestMsg = inboundMessageHolder.getInboundMsg();
        if (http2SourceHandler.getServerConnectorFuture() != null) {
            try {
                ServerConnectorFuture outboundRespFuture = httpRequestMsg.getHttpResponseFuture();
                Http2OutboundRespListener http2OutboundRespListener = new Http2OutboundRespListener(http2SourceHandler.getServerChannelInitializer(), httpRequestMsg, http2SourceHandler.getChannelHandlerContext(), http2SourceHandler.getConnection(), http2SourceHandler.getEncoder(), streamId, http2SourceHandler.getServerName(), http2SourceHandler.getRemoteAddress(), http2SourceHandler.getServerRemoteFlowControlListener(), http2SourceHandler.getHttp2ServerChannel());
                outboundRespFuture.setHttpConnectorListener(http2OutboundRespListener);
                http2SourceHandler.getServerConnectorFuture().notifyHttpListener(httpRequestMsg);
                inboundMessageHolder.setHttp2OutboundRespListener(http2OutboundRespListener);
            }
            catch (Exception e) {
                LOG.error("Error while notifying listeners", e);
            }
        } else {
            LOG.error("Cannot find registered listener to forward the message");
        }
    }

    public static HttpCarbonRequest setupCarbonRequest(HttpRequest httpRequest, Http2SourceHandler http2SourceHandler, int streamId) {
        ChannelHandlerContext ctx = http2SourceHandler.getChannelHandlerContext();
        HttpCarbonRequest sourceReqCMsg = new HttpCarbonRequest(httpRequest, (Listener)new Http2InboundContentListener(streamId, ctx, http2SourceHandler.getConnection(), "INBOUND_REQUEST"));
        sourceReqCMsg.setProperty("POOLED_BYTE_BUFFER_FACTORY", new PooledDataStreamerFactory(ctx.alloc()));
        sourceReqCMsg.setProperty("CHNL_HNDLR_CTX", ctx);
        sourceReqCMsg.setProperty("SRC_HANDLER", http2SourceHandler);
        HttpVersion protocolVersion = httpRequest.protocolVersion();
        sourceReqCMsg.setHttpVersion(protocolVersion.majorVersion() + "." + protocolVersion.minorVersion());
        sourceReqCMsg.setHttpMethod(httpRequest.method().name());
        InetSocketAddress localAddress = null;
        if (ctx.channel().localAddress() instanceof InetSocketAddress) {
            localAddress = (InetSocketAddress)ctx.channel().localAddress();
        }
        sourceReqCMsg.setProperty("LOCAL_ADDRESS", localAddress);
        sourceReqCMsg.setProperty("LISTENER_PORT", localAddress != null ? Integer.valueOf(localAddress.getPort()) : null);
        sourceReqCMsg.setProperty("listener.interface.id", http2SourceHandler.getInterfaceId());
        sourceReqCMsg.setProperty("PROTOCOL", "http");
        String uri = httpRequest.uri();
        sourceReqCMsg.setRequestUrl(uri);
        sourceReqCMsg.setProperty("TO", uri);
        return sourceReqCMsg;
    }

    public static void writeHttp2ResponseHeaders(ChannelHandlerContext ctx, Http2ConnectionEncoder encoder, HttpResponseFuture outboundRespStatusFuture, int streamId, Http2Headers http2Headers, boolean endStream, Http2OutboundRespListener respListener) throws Http2Exception {
        for (Http2DataEventListener dataEventListener : respListener.getHttp2ServerChannel().getDataEventListeners()) {
            if (!dataEventListener.onHeadersWrite(ctx, streamId, http2Headers, endStream)) break;
        }
        if (endStream) {
            respListener.getHttp2ServerChannel().getStreamIdRequestMap().remove(streamId);
        }
        ChannelFuture channelFuture = encoder.writeHeaders(ctx, streamId, http2Headers, 0, endStream, ctx.newPromise());
        encoder.flowController().writePendingBytes();
        ctx.flush();
        Util.addResponseWriteFailureListener(outboundRespStatusFuture, channelFuture, respListener);
    }

    public static void writeHttp2Promise(Http2PushPromise pushPromise, ChannelHandlerContext ctx, Http2Connection conn, Http2ConnectionEncoder encoder, HttpCarbonMessage inboundRequestMsg, HttpResponseFuture outboundRespStatusFuture, int originalStreamId) throws Http2Exception {
        int promisedStreamId = Http2StateUtil.getNextStreamId(conn);
        pushPromise.setPromisedStreamId(promisedStreamId);
        pushPromise.setStreamId(originalStreamId);
        HttpRequest httpRequest = pushPromise.getHttpRequest();
        httpRequest.headers().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"http");
        Http2Headers http2Headers = HttpConversionUtil.toHttp2Headers(httpRequest, true);
        ChannelFuture channelFuture = encoder.writePushPromise(ctx, originalStreamId, promisedStreamId, http2Headers, 0, ctx.newPromise());
        encoder.flowController().writePendingBytes();
        ctx.flush();
        Util.checkForResponseWriteStatus(inboundRequestMsg, outboundRespStatusFuture, channelFuture);
    }

    public static void validatePromisedStreamState(int originalStreamId, int streamId, Http2Connection conn, HttpCarbonMessage inboundRequestMsg) throws Http2Exception {
        if (streamId == originalStreamId) {
            return;
        }
        if (!Http2StateUtil.isValidStreamId(streamId, conn)) {
            inboundRequestMsg.getHttpOutboundRespStatusFuture().notifyHttpListener(new ServerConnectorException("Promised stream is already rejected or stream is no longer valid"));
            throw new Http2Exception(Http2Error.REFUSED_STREAM, "Promised stream is already rejected or stream is no longer valid");
        }
    }

    public static boolean isValidStreamId(int streamId, Http2Connection conn) {
        return conn.stream(streamId) != null;
    }

    public static void releaseDataFrame(Http2SourceHandler http2SourceHandler, Http2DataFrame dataFrame) {
        int streamId = dataFrame.getStreamId();
        HttpCarbonMessage sourceReqCMsg = http2SourceHandler.getStreamIdRequestMap().get(streamId).getInboundMsg();
        if (sourceReqCMsg != null) {
            sourceReqCMsg.addHttpContent(new DefaultLastHttpContent());
            http2SourceHandler.getStreamIdRequestMap().remove(streamId);
        }
        dataFrame.getData().release();
    }

    public static void sendRstFrame(ChannelHandlerContext ctx, Http2ConnectionEncoder encoder, int streamId) throws Http2Exception {
        encoder.writeRstStream(ctx, streamId, Http2Error.NO_ERROR.code(), ctx.newPromise());
        encoder.flowController().writePendingBytes();
        ctx.flush();
    }

    public static void writeHttp2Headers(ChannelHandlerContext ctx, OutboundMsgHolder outboundMsgHolder, Http2ClientChannel http2ClientChannel, Http2ConnectionEncoder encoder, int streamId, HttpHeaders headers, Http2Headers http2Headers, boolean endStream) throws Http2Exception {
        int dependencyId = headers.getInt(HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), 0);
        short weight = headers.getShort(HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
        for (Http2DataEventListener dataEventListener : http2ClientChannel.getDataEventListeners()) {
            if (dataEventListener.onHeadersWrite(ctx, streamId, http2Headers, endStream)) continue;
            return;
        }
        encoder.writeHeaders(ctx, streamId, http2Headers, dependencyId, weight, false, 0, endStream, ctx.newPromise());
        encoder.flowController().writePendingBytes();
        ctx.flush();
        if (endStream) {
            outboundMsgHolder.setRequestWritten(true);
        }
    }

    public static int initiateStream(ChannelHandlerContext ctx, Http2Connection connection, Http2ClientChannel http2ClientChannel, OutboundMsgHolder outboundMsgHolder) throws Http2Exception {
        int streamId = Http2StateUtil.getNextStreamId(connection);
        Http2StateUtil.createStream(connection, streamId);
        http2ClientChannel.putInFlightMessage(streamId, outboundMsgHolder);
        http2ClientChannel.getDataEventListeners().forEach(dataEventListener -> dataEventListener.onStreamInit(ctx, streamId));
        return streamId;
    }

    private static int getNextStreamId(Http2Connection conn) {
        return conn.local().incrementAndGetNextStreamId();
    }

    private static void createStream(Http2Connection conn, int streamId) throws Http2Exception {
        conn.local().createStream(streamId, false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stream created streamId: {}", (Object)streamId);
        }
    }

    public static void onPushPromiseRead(ChannelHandlerContext ctx, Http2PushPromise http2PushPromise, Http2ClientChannel http2ClientChannel, OutboundMsgHolder outboundMsgHolder) {
        int streamId = http2PushPromise.getStreamId();
        int promisedStreamId = http2PushPromise.getPromisedStreamId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received a push promise on channel: {} over stream id: {}, promisedStreamId: {}", http2ClientChannel, streamId, promisedStreamId);
        }
        if (outboundMsgHolder == null) {
            LOG.warn("Push promise received in channel: {} over invalid stream id : {}", (Object)http2ClientChannel, (Object)streamId);
            return;
        }
        http2ClientChannel.putPromisedMessage(promisedStreamId, outboundMsgHolder);
        http2PushPromise.setOutboundMsgHolder(outboundMsgHolder);
        outboundMsgHolder.addPromise(http2PushPromise);
        for (Http2DataEventListener listener : http2ClientChannel.getDataEventListeners()) {
            if (listener.onStreamInit(ctx, promisedStreamId)) continue;
            return;
        }
    }

    public static void releaseContent(HttpContent httpContent) {
        httpContent.release();
    }

    public static void sendRequestTimeoutResponse(ChannelHandlerContext ctx, Http2OutboundRespListener http2OutboundRespListener, int streamId, HttpResponseStatus httpResponseStatus, ByteBuf content, boolean handleIncompleteRequest, boolean whileReceivingHeader) {
        try {
            DefaultHttp2Headers headers = new DefaultHttp2Headers();
            headers.status(httpResponseStatus.codeAsText());
            Http2ConnectionEncoder encoder = http2OutboundRespListener.getEncoder();
            encoder.writeHeaders(ctx, streamId, headers, 0, false, ctx.newPromise());
            ChannelFuture dataFuture = encoder.writeData(ctx, streamId, content, 0, true, ctx.newPromise());
            Http2StateUtil.handleFuture(dataFuture, handleIncompleteRequest, whileReceivingHeader, http2OutboundRespListener.getInboundRequestMsg());
            encoder.flowController().writePendingBytes();
            ctx.flush();
        }
        catch (Http2Exception e) {
            LOG.error("Error in sending timeout response:" + e.getMessage());
        }
    }

    private static void handleFuture(ChannelFuture outboundRespFuture, boolean handleIncompleteRequest, boolean whileReceivingHeader, HttpCarbonMessage inboundRequestMsg) {
        outboundRespFuture.addListener(channelFuture -> {
            Throwable cause = channelFuture.cause();
            if (cause != null) {
                LOG.warn("Failed to send: {}", (Object)cause.getMessage());
            }
            if (handleIncompleteRequest) {
                if (whileReceivingHeader) {
                    StateUtil.handleIncompleteInboundMessage(inboundRequestMsg, "Idle timeout triggered while reading inbound request headers");
                } else {
                    StateUtil.handleIncompleteInboundMessage(inboundRequestMsg, "Idle timeout triggered while reading inbound request entity body");
                }
            }
        });
    }

    public static void initHttp2MessageContext(HttpCarbonMessage outboundRequest, Http2TargetHandler http2TargetHandler) {
        Http2MessageStateContext http2MessageStateContext = outboundRequest.getHttp2MessageStateContext();
        if (http2MessageStateContext == null) {
            http2MessageStateContext = new Http2MessageStateContext();
            http2MessageStateContext.setSenderState(new RequestCompleted(http2TargetHandler, null));
            outboundRequest.setHttp2MessageStateContext(http2MessageStateContext);
        } else if (http2MessageStateContext.getSenderState() == null) {
            http2MessageStateContext.setSenderState(new RequestCompleted(http2TargetHandler, null));
        }
    }
}

