/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserMetrics;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixExecutable;
import com.netflix.hystrix.HystrixObservable;
import com.netflix.hystrix.HystrixRequestCache;
import com.netflix.hystrix.collapser.CollapserTimer;
import com.netflix.hystrix.collapser.HystrixCollapserBridge;
import com.netflix.hystrix.collapser.RealCollapserTimer;
import com.netflix.hystrix.collapser.RequestCollapser;
import com.netflix.hystrix.collapser.RequestCollapserFactory;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherFactory;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Action1;
import rx.schedulers.Schedulers;
import rx.subjects.ReplaySubject;

public abstract class HystrixCollapser<BatchReturnType, ResponseType, RequestArgumentType>
implements HystrixExecutable<ResponseType>,
HystrixObservable<ResponseType> {
    static final Logger logger = LoggerFactory.getLogger(HystrixCollapser.class);
    private final RequestCollapserFactory<BatchReturnType, ResponseType, RequestArgumentType> collapserFactory;
    private final HystrixRequestCache requestCache;
    private final HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType> collapserInstanceWrapper;
    private final HystrixCollapserMetrics metrics;
    private static ConcurrentHashMap<Class<? extends HystrixCollapser>, String> defaultNameCache = new ConcurrentHashMap();

    protected HystrixCollapser() {
        this(Setter.withCollapserKey(null).andScope(Scope.REQUEST));
    }

    protected HystrixCollapser(HystrixCollapserKey collapserKey) {
        this(Setter.withCollapserKey(collapserKey).andScope(Scope.REQUEST));
    }

    protected HystrixCollapser(Setter setter) {
        this(setter.collapserKey, setter.scope, new RealCollapserTimer(), setter.propertiesSetter, null);
    }

    HystrixCollapser(HystrixCollapserKey collapserKey, Scope scope, CollapserTimer timer, HystrixCollapserProperties.Setter propertiesBuilder) {
        this(collapserKey, scope, timer, propertiesBuilder, null);
    }

    HystrixCollapser(HystrixCollapserKey collapserKey, Scope scope, CollapserTimer timer, HystrixCollapserProperties.Setter propertiesBuilder, HystrixCollapserMetrics metrics) {
        if (collapserKey == null || collapserKey.name().trim().equals("")) {
            String defaultKeyName = HystrixCollapser.getDefaultNameFromClass(this.getClass());
            collapserKey = HystrixCollapserKey.Factory.asKey(defaultKeyName);
        }
        HystrixCollapserProperties properties = HystrixPropertiesFactory.getCollapserProperties(collapserKey, propertiesBuilder);
        this.collapserFactory = new RequestCollapserFactory(collapserKey, (RequestCollapserFactory.Scope)scope, timer, properties);
        this.requestCache = HystrixRequestCache.getInstance(collapserKey, HystrixPlugins.getInstance().getConcurrencyStrategy());
        this.metrics = metrics == null ? HystrixCollapserMetrics.getInstance(collapserKey, properties) : metrics;
        final HystrixCollapser self = this;
        HystrixMetricsPublisherFactory.createOrRetrievePublisherForCollapser(collapserKey, this.metrics, properties);
        this.collapserInstanceWrapper = new HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType>(){

            @Override
            public Collection<Collection<CollapsedRequest<ResponseType, RequestArgumentType>>> shardRequests(Collection<CollapsedRequest<ResponseType, RequestArgumentType>> requests) {
                Collection shards = self.shardRequests(requests);
                self.metrics.markShards(shards.size());
                return shards;
            }

            @Override
            public Observable<BatchReturnType> createObservableCommand(Collection<CollapsedRequest<ResponseType, RequestArgumentType>> requests) {
                HystrixCommand command = self.createCommand(requests);
                command.markAsCollapsedCommand(this.getCollapserKey(), requests.size());
                self.metrics.markBatch(requests.size());
                return command.toObservable();
            }

            @Override
            public Observable<Void> mapResponseToRequests(Observable<BatchReturnType> batchResponse, final Collection<CollapsedRequest<ResponseType, RequestArgumentType>> requests) {
                return batchResponse.single().doOnNext(new Action1<BatchReturnType>(){

                    @Override
                    public void call(BatchReturnType batchReturnType) {
                        self.mapResponseToRequests(batchReturnType, requests);
                    }
                }).ignoreElements().cast(Void.class);
            }

            @Override
            public HystrixCollapserKey getCollapserKey() {
                return self.getCollapserKey();
            }
        };
    }

    private HystrixCollapserProperties getProperties() {
        return this.collapserFactory.getProperties();
    }

    public HystrixCollapserKey getCollapserKey() {
        return this.collapserFactory.getCollapserKey();
    }

    public Scope getScope() {
        return Scope.valueOf(this.collapserFactory.getScope().name());
    }

    public HystrixCollapserMetrics getMetrics() {
        return this.metrics;
    }

    public abstract RequestArgumentType getRequestArgument();

    protected abstract HystrixCommand<BatchReturnType> createCommand(Collection<CollapsedRequest<ResponseType, RequestArgumentType>> var1);

    protected Collection<Collection<CollapsedRequest<ResponseType, RequestArgumentType>>> shardRequests(Collection<CollapsedRequest<ResponseType, RequestArgumentType>> requests) {
        return Collections.singletonList(requests);
    }

    protected abstract void mapResponseToRequests(BatchReturnType var1, Collection<CollapsedRequest<ResponseType, RequestArgumentType>> var2);

    @Override
    public Observable<ResponseType> observe() {
        ReplaySubject subject = ReplaySubject.create();
        this.toObservable().subscribe(subject);
        return subject;
    }

    @Override
    public Observable<ResponseType> toObservable() {
        return this.toObservable(Schedulers.computation());
    }

    public Observable<ResponseType> toObservable(Scheduler observeOn) {
        Observable fromCache;
        boolean isRequestCacheEnabled = this.getProperties().requestCacheEnabled().get();
        if (isRequestCacheEnabled && (fromCache = this.requestCache.get(this.getCacheKey())) != null) {
            this.metrics.markResponseFromCache();
            return fromCache;
        }
        RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> requestCollapser = this.collapserFactory.getRequestCollapser(this.collapserInstanceWrapper);
        Observable<ResponseType> response = requestCollapser.submitRequest(this.getRequestArgument());
        this.metrics.markRequestBatched();
        if (isRequestCacheEnabled) {
            Observable<ResponseType> o = response.cache();
            Observable<ResponseType> fromCache2 = this.requestCache.putIfAbsent(this.getCacheKey(), o);
            response = fromCache2 == null ? o : fromCache2;
        }
        return response;
    }

    @Override
    public ResponseType execute() {
        try {
            return this.queue().get();
        }
        catch (Throwable e) {
            if (e instanceof HystrixRuntimeException) {
                throw (HystrixRuntimeException)e;
            }
            if (e.getCause() instanceof HystrixRuntimeException) {
                throw (HystrixRuntimeException)e.getCause();
            }
            String message = this.getClass().getSimpleName() + " HystrixCollapser failed while executing.";
            logger.debug(message, e);
            throw new RuntimeException(message, e);
        }
    }

    @Override
    public Future<ResponseType> queue() {
        Observable<ResponseType> o = this.toObservable();
        return o.toBlocking().toFuture();
    }

    protected String getCacheKey() {
        return null;
    }

    static void reset() {
        RequestCollapserFactory.reset();
    }

    private static String getDefaultNameFromClass(Class<? extends HystrixCollapser> cls) {
        String fromCache = defaultNameCache.get(cls);
        if (fromCache != null) {
            return fromCache;
        }
        String name = cls.getSimpleName();
        if (name.equals("")) {
            name = cls.getName();
            name = name.substring(name.lastIndexOf(46) + 1, name.length());
        }
        defaultNameCache.put(cls, name);
        return name;
    }

    public static class Setter {
        private final HystrixCollapserKey collapserKey;
        private Scope scope = Scope.REQUEST;
        private HystrixCollapserProperties.Setter propertiesSetter;

        private Setter(HystrixCollapserKey collapserKey) {
            this.collapserKey = collapserKey;
        }

        public static Setter withCollapserKey(HystrixCollapserKey collapserKey) {
            return new Setter(collapserKey);
        }

        public Setter andScope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Setter andCollapserPropertiesDefaults(HystrixCollapserProperties.Setter propertiesSetter) {
            this.propertiesSetter = propertiesSetter;
            return this;
        }
    }

    public static interface CollapsedRequest<ResponseType, RequestArgumentType> {
        public RequestArgumentType getArgument();

        public void setResponse(ResponseType var1);

        public void emitResponse(ResponseType var1);

        public void setException(Exception var1);

        public void setComplete();
    }

    public static enum Scope implements RequestCollapserFactory.Scope
    {
        REQUEST,
        GLOBAL;

    }
}

