/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicPropertySupport;
import com.netflix.config.PropertyListener;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicProperty {
    private static final Logger logger = LoggerFactory.getLogger(DynamicProperty.class);
    private static volatile DynamicPropertySupport dynamicPropertySupportImpl;
    private static final ConcurrentHashMap<String, DynamicProperty> ALL_PROPS;
    private Object lock = new Object();
    private String propName;
    private String stringValue = null;
    private long changedTime;
    private CopyOnWriteArraySet<Runnable> callbacks = new CopyOnWriteArraySet();
    private static final String[] TRUE_VALUES;
    private static final String[] FALSE_VALUES;
    private CachedValue<Boolean> booleanValue = new CachedValue<Boolean>(){

        @Override
        protected Boolean parse(String string) throws IllegalArgumentException {
            int n;
            for (n = 0; n < TRUE_VALUES.length; ++n) {
                if (!string.equalsIgnoreCase(TRUE_VALUES[n])) continue;
                return Boolean.TRUE;
            }
            for (n = 0; n < FALSE_VALUES.length; ++n) {
                if (!string.equalsIgnoreCase(FALSE_VALUES[n])) continue;
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException();
        }
    };
    private CachedValue<String> cachedStringValue = new CachedValue<String>(){

        @Override
        protected String parse(String string) {
            return string;
        }
    };
    private CachedValue<Integer> integerValue = new CachedValue<Integer>(){

        @Override
        protected Integer parse(String string) throws NumberFormatException {
            return Integer.valueOf(string);
        }
    };
    private CachedValue<Long> longValue = new CachedValue<Long>(){

        @Override
        protected Long parse(String string) throws NumberFormatException {
            return Long.valueOf(string);
        }
    };
    private CachedValue<Float> floatValue = new CachedValue<Float>(){

        @Override
        protected Float parse(String string) throws NumberFormatException {
            return Float.valueOf(string);
        }
    };
    private CachedValue<Double> doubleValue = new CachedValue<Double>(){

        @Override
        protected Double parse(String string) throws NumberFormatException {
            return Double.valueOf(string);
        }
    };
    private CachedValue<Class> classValue = new CachedValue<Class>(){

        @Override
        protected Class parse(String string) throws ClassNotFoundException {
            return Class.forName(string);
        }
    };

    public static DynamicProperty getInstance(String string) {
        DynamicProperty dynamicProperty;
        DynamicProperty dynamicProperty2;
        if (dynamicPropertySupportImpl == null) {
            DynamicPropertyFactory.getInstance();
        }
        if ((dynamicProperty2 = ALL_PROPS.get(string)) == null && (dynamicProperty = ALL_PROPS.putIfAbsent(string, dynamicProperty2 = new DynamicProperty(string))) != null) {
            dynamicProperty2 = dynamicProperty;
        }
        return dynamicProperty2;
    }

    protected DynamicProperty() {
    }

    private DynamicProperty(String string) {
        this.propName = string;
        this.updateValue();
    }

    public String getName() {
        return this.propName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getChangedTimestamp() {
        Object object = this.lock;
        synchronized (object) {
            return this.changedTime;
        }
    }

    public String getString() {
        return this.cachedStringValue.getValue();
    }

    public String getString(String string) {
        return this.cachedStringValue.getValue(string);
    }

    public Boolean getBoolean() throws IllegalArgumentException {
        return this.booleanValue.getValue();
    }

    public Boolean getBoolean(Boolean bl) {
        return this.booleanValue.getValue(bl);
    }

    public Integer getInteger() throws IllegalArgumentException {
        return this.integerValue.getValue();
    }

    public Integer getInteger(Integer n) {
        return this.integerValue.getValue(n);
    }

    public Float getFloat() throws IllegalArgumentException {
        return this.floatValue.getValue();
    }

    public Float getFloat(Float f) {
        return this.floatValue.getValue(f);
    }

    public Long getLong() throws IllegalArgumentException {
        return this.longValue.getValue();
    }

    public Long getLong(Long l) {
        return this.longValue.getValue(l);
    }

    public Double getDouble() throws IllegalArgumentException {
        return this.doubleValue.getValue();
    }

    public Double getDouble(Double d) {
        return this.doubleValue.getValue(d);
    }

    public Class getNamedClass() throws IllegalArgumentException {
        return this.classValue.getValue();
    }

    public Class<?> getNamedClass(Class<?> clazz) {
        return this.classValue.getValue(clazz);
    }

    public void addCallback(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("Cannot add null callback to DynamicProperty");
        }
        this.callbacks.add(runnable);
    }

    public boolean removeCallback(Runnable runnable) {
        return this.callbacks.remove(runnable);
    }

    Set<Runnable> getCallbacks() {
        return this.callbacks;
    }

    private void notifyCallbacks() {
        for (Runnable runnable : this.callbacks) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                logger.error("Error in DynamicProperty callback", exception);
            }
        }
    }

    private boolean updateValue() {
        String string;
        try {
            if (dynamicPropertySupportImpl == null) {
                return false;
            }
            string = dynamicPropertySupportImpl.getString(this.propName);
        }
        catch (Exception exception) {
            logger.error("Unable to update property: " + this.propName, exception);
            return false;
        }
        return this.updateValue(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateValue(Object object) {
        String string = object == null ? null : object.toString();
        Object object2 = this.lock;
        synchronized (object2) {
            if (string == null && this.stringValue == null || string != null && string.equals(this.stringValue)) {
                return false;
            }
            this.stringValue = string;
            this.cachedStringValue.flush();
            this.booleanValue.flush();
            this.integerValue.flush();
            this.floatValue.flush();
            this.classValue.flush();
            this.doubleValue.flush();
            this.longValue.flush();
            this.changedTime = System.currentTimeMillis();
            return true;
        }
    }

    private static boolean updateProperty(String string, Object object) {
        DynamicProperty dynamicProperty = ALL_PROPS.get(string);
        if (dynamicProperty != null && dynamicProperty.updateValue(object)) {
            dynamicProperty.notifyCallbacks();
            return true;
        }
        return false;
    }

    private static boolean updateAllProperties() {
        boolean bl = false;
        for (DynamicProperty dynamicProperty : ALL_PROPS.values()) {
            if (!dynamicProperty.updateValue()) continue;
            dynamicProperty.notifyCallbacks();
            bl = true;
        }
        return bl;
    }

    static synchronized void initialize(DynamicPropertySupport dynamicPropertySupport) {
        dynamicPropertySupportImpl = dynamicPropertySupport;
        dynamicPropertySupport.addConfigurationListener(new DynamicPropertyListener());
        DynamicProperty.updateAllProperties();
    }

    static void registerWithDynamicPropertySupport(DynamicPropertySupport dynamicPropertySupport) {
        DynamicProperty.initialize(dynamicPropertySupport);
    }

    public String toString() {
        return "{DynamicProperty:" + this.propName + "}";
    }

    static {
        ALL_PROPS = new ConcurrentHashMap();
        TRUE_VALUES = new String[]{"true", "t", "yes", "y", "on"};
        FALSE_VALUES = new String[]{"false", "f", "no", "n", "off"};
    }

    static class DynamicPropertyListener
    implements PropertyListener {
        DynamicPropertyListener() {
        }

        @Override
        public void configSourceLoaded(Object object) {
            DynamicProperty.updateAllProperties();
        }

        @Override
        public void addProperty(Object object, String string, Object object2, boolean bl) {
            if (!bl) {
                DynamicProperty.updateProperty(string, object2);
            }
        }

        @Override
        public void setProperty(Object object, String string, Object object2, boolean bl) {
            if (!bl) {
                DynamicProperty.updateProperty(string, object2);
            }
        }

        @Override
        public void clearProperty(Object object, String string, Object object2, boolean bl) {
            if (!bl) {
                DynamicProperty.updateProperty(string, object2);
            }
        }

        @Override
        public void clear(Object object, boolean bl) {
            if (!bl) {
                DynamicProperty.updateAllProperties();
            }
        }
    }

    private abstract class CachedValue<T> {
        private volatile boolean isCached;
        private volatile IllegalArgumentException exception;
        private volatile T value;

        public CachedValue() {
            this.flush();
        }

        final void flush() {
            this.isCached = false;
            this.exception = null;
            this.value = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T getValue() throws IllegalArgumentException {
            if (!this.isCached) {
                Object object = DynamicProperty.this.lock;
                synchronized (object) {
                    try {
                        this.value = DynamicProperty.this.stringValue == null ? null : this.parse(DynamicProperty.this.stringValue);
                        this.exception = null;
                    }
                    catch (Exception exception) {
                        this.value = null;
                        this.exception = new IllegalArgumentException(exception);
                    }
                    finally {
                        this.isCached = true;
                    }
                }
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return this.value;
        }

        public T getValue(T t) {
            try {
                T t2 = this.getValue();
                return t2 == null ? t : t2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return t;
            }
        }

        public String toString() {
            if (!this.isCached) {
                return "{not cached}";
            }
            if (this.exception != null) {
                return "{Exception: " + this.exception + "}";
            }
            return "{Value: " + this.value + "}";
        }

        protected abstract T parse(String var1) throws Exception;
    }
}

