/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.AggregatedConfiguration;
import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.ConcurrentMapConfiguration;
import com.netflix.config.ConfigurationBasedDeploymentContext;
import com.netflix.config.DeploymentContext;
import com.netflix.config.DynamicProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicURLConfiguration;
import com.netflix.config.ExpandedConfigurationListenerAdapter;
import com.netflix.config.jmx.ConfigJMXManager;
import com.netflix.config.jmx.ConfigMBean;
import com.netflix.config.util.ConfigurationUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManager {
    static volatile AbstractConfiguration instance = null;
    static volatile boolean configurationInstalled = false;
    private static volatile ConfigMBean configMBean = null;
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationManager.class);
    static volatile DeploymentContext context = null;

    public static synchronized void install(AbstractConfiguration abstractConfiguration) throws IllegalStateException {
        if (!configurationInstalled) {
            if (instance != null) {
                ConfigurationManager.removeDefaultConfiguration();
            }
            instance = abstractConfiguration;
            if (DynamicPropertyFactory.getBackingConfigurationSource() != abstractConfiguration) {
                DynamicPropertyFactory.initWithConfigurationSource(abstractConfiguration);
            }
        } else {
            throw new IllegalStateException("A non-default configuration is already installed");
        }
        configurationInstalled = true;
        ConfigurationManager.registerConfigBean();
    }

    public static synchronized boolean isConfigurationInstalled() {
        return configurationInstalled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AbstractConfiguration getConfigInstance() {
        if (instance != null || Boolean.getBoolean("archaius.dynamicProperty.disableDefaultConfig")) return instance;
        Class<ConfigurationManager> clazz = ConfigurationManager.class;
        synchronized (ConfigurationManager.class) {
            if (instance != null) return instance;
            instance = new ConcurrentCompositeConfiguration();
            if (!Boolean.getBoolean("archaius.dynamicProperty.disableSystemConfig")) {
                SystemConfiguration systemConfiguration = new SystemConfiguration();
                ((ConcurrentCompositeConfiguration)instance).addConfiguration(systemConfiguration, "archaius.dynamicPropertyFactory.SYS_CONFIG");
                try {
                    DynamicURLConfiguration dynamicURLConfiguration = new DynamicURLConfiguration();
                    ((ConcurrentCompositeConfiguration)instance).addConfiguration(dynamicURLConfiguration, "archaius.dynamicPropertyFactory.URL_CONFIG");
                }
                catch (Throwable throwable) {
                    logger.warn("Failed to create default dynamic configuration", throwable);
                }
            }
            ConfigurationManager.registerConfigBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    static void registerConfigBean() {
        if (Boolean.getBoolean("archaius.dynamicPropertyFactory.registerConfigWithJMX")) {
            try {
                configMBean = ConfigJMXManager.registerConfigMbean(instance);
            }
            catch (Exception exception) {
                logger.error("Unable to register with JMX", exception);
            }
        }
    }

    static void setDirect(AbstractConfiguration abstractConfiguration) {
        ConfigurationManager.removeDefaultConfiguration();
        instance = abstractConfiguration;
        configurationInstalled = true;
        ConfigurationManager.registerConfigBean();
    }

    public static void loadPropertiesFromResources(String string) throws IOException {
        ClassLoader classLoader;
        URL uRL;
        if (instance == null) {
            instance = ConfigurationManager.getConfigInstance();
        }
        if ((uRL = (classLoader = Thread.currentThread().getContextClassLoader()).getResource(string)) == null) {
            throw new IOException("Cannot locate " + string + " as a classpath resource.");
        }
        Properties properties = new Properties();
        InputStream inputStream = uRL.openStream();
        properties.load(inputStream);
        inputStream.close();
        if (instance instanceof AggregatedConfiguration) {
            String string2 = ConfigurationManager.getConfigName(uRL);
            ConcurrentMapConfiguration concurrentMapConfiguration = new ConcurrentMapConfiguration();
            concurrentMapConfiguration.loadProperties(properties);
            ((AggregatedConfiguration)((Object)instance)).addConfiguration(concurrentMapConfiguration, string2);
        } else {
            ConfigurationUtils.loadProperties(properties, instance);
        }
    }

    public static void loadCascadedPropertiesFromResources(String string) throws IOException {
        Object object;
        ClassLoader classLoader;
        URL uRL;
        String string2 = string + ".properties";
        if (instance == null) {
            instance = ConfigurationManager.getConfigInstance();
        }
        if ((uRL = (classLoader = Thread.currentThread().getContextClassLoader()).getResource(string2)) == null) {
            throw new IOException("Cannot locate " + string2 + " as a classpath resource.");
        }
        Properties properties = new Properties();
        InputStream inputStream = uRL.openStream();
        properties.load(inputStream);
        inputStream.close();
        String string3 = ConfigurationManager.getDeploymentContext().getDeploymentEnvironment();
        if (string3 != null && string3.length() > 0 && (uRL = classLoader.getResource((String)(object = string + "-" + string3 + ".properties"))) != null) {
            InputStream inputStream2 = uRL.openStream();
            properties.load(inputStream2);
            inputStream2.close();
        }
        if (instance instanceof AggregatedConfiguration) {
            object = new ConcurrentMapConfiguration();
            ((ConcurrentMapConfiguration)object).loadProperties(properties);
            ((AggregatedConfiguration)((Object)instance)).addConfiguration((AbstractConfiguration)object, string);
        } else {
            ConfigurationUtils.loadProperties(properties, instance);
        }
    }

    public static void loadPropertiesFromConfiguration(AbstractConfiguration abstractConfiguration) {
        if (instance instanceof AggregatedConfiguration) {
            ((AggregatedConfiguration)((Object)instance)).addConfiguration(abstractConfiguration);
        } else {
            Properties properties = ConfigurationUtils.getProperties(abstractConfiguration);
            ConfigurationUtils.loadProperties(properties, instance);
        }
    }

    public static void loadProperties(Properties properties) {
        ConfigurationUtils.loadProperties(properties, instance);
    }

    public static void setDeploymentContext(DeploymentContext deploymentContext) {
        context = deploymentContext;
    }

    public static DeploymentContext getDeploymentContext() {
        return context;
    }

    private static String getConfigName(URL uRL) {
        String string = uRL.toExternalForm();
        string = string.replace('\\', '/');
        String string2 = uRL.getProtocol().toLowerCase();
        if ("jar".equals(string2) || "zip".equals(string2)) {
            int n;
            int n2 = string.lastIndexOf("!");
            if (n2 >= 0) {
                string = string.substring(0, n2);
            }
            if ((n = string.lastIndexOf("/")) >= 0) {
                string = string.substring(n + 1);
            }
        } else {
            int n = string.lastIndexOf("/");
            if (n >= 0) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    static synchronized void removeDefaultConfiguration() {
        if (instance == null || configurationInstalled) {
            return;
        }
        ConcurrentCompositeConfiguration concurrentCompositeConfiguration = (ConcurrentCompositeConfiguration)instance;
        DynamicURLConfiguration dynamicURLConfiguration = (DynamicURLConfiguration)concurrentCompositeConfiguration.getConfiguration("archaius.dynamicPropertyFactory.URL_CONFIG");
        if (dynamicURLConfiguration != null) {
            dynamicURLConfiguration.stopLoading();
        }
        Collection<ConfigurationListener> collection = concurrentCompositeConfiguration.getConfigurationListeners();
        ConfigurationListener configurationListener = null;
        for (ConfigurationListener configurationListener2 : collection) {
            if (!(configurationListener2 instanceof ExpandedConfigurationListenerAdapter) || !(((ExpandedConfigurationListenerAdapter)configurationListener2).getListener() instanceof DynamicProperty.DynamicPropertyListener)) continue;
            configurationListener = configurationListener2;
            break;
        }
        if (configurationListener != null) {
            concurrentCompositeConfiguration.removeConfigurationListener(configurationListener);
        }
        if (configMBean != null) {
            try {
                ConfigJMXManager.unRegisterConfigMBean(concurrentCompositeConfiguration, configMBean);
            }
            catch (Exception exception) {
                logger.error("Error unregistering with JMX", exception);
            }
        }
        instance = null;
    }

    static {
        try {
            Object object;
            String string;
            String string2 = System.getProperty("archaius.default.configuration.class");
            if (string2 != null) {
                instance = (AbstractConfiguration)Class.forName(string2).newInstance();
                configurationInstalled = true;
            } else {
                string = System.getProperty("archaius.default.configuration.factory");
                if (string != null) {
                    object = Class.forName(string).getDeclaredMethod("getInstance", new Class[0]);
                    ((Method)object).setAccessible(true);
                    instance = (AbstractConfiguration)((Method)object).invoke(null, new Object[0]);
                    configurationInstalled = true;
                }
            }
            string = System.getProperty("archaius.default.deploymentContext.class");
            if (string != null) {
                context = (DeploymentContext)Class.forName(string2).newInstance();
            } else {
                object = System.getProperty("archaius.default.deploymentContext.factory");
                if (object != null) {
                    Method method = Class.forName((String)object).getDeclaredMethod("getInstance", new Class[0]);
                    method.setAccessible(true);
                    context = (DeploymentContext)method.invoke(null, new Object[0]);
                } else {
                    context = new ConfigurationBasedDeploymentContext();
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error initializing configuration", exception);
        }
    }
}

