/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.properties;

import com.netflix.config.PropertyWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HystrixPropertiesChainedArchaiusProperty {
    private static final Logger logger = LoggerFactory.getLogger(HystrixPropertiesChainedArchaiusProperty.class);

    public static class DynamicStringProperty
    extends PropertyWrapper<String> {
        public DynamicStringProperty(String propName, String defaultValue) {
            super(propName, defaultValue);
        }

        public String get() {
            return this.prop.getString((String)this.defaultValue);
        }

        @Override
        public String getValue() {
            return this.get();
        }
    }

    public static class DynamicLongProperty
    extends PropertyWrapper<Long> {
        public DynamicLongProperty(String propName, Long defaultValue) {
            super(propName, defaultValue);
        }

        public Long get() {
            return this.prop.getLong((Long)this.defaultValue);
        }

        @Override
        public Long getValue() {
            return this.get();
        }
    }

    public static class DynamicIntegerProperty
    extends PropertyWrapper<Integer> {
        public DynamicIntegerProperty(String propName, Integer defaultValue) {
            super(propName, defaultValue);
        }

        public Integer get() {
            return this.prop.getInteger((Integer)this.defaultValue);
        }

        @Override
        public Integer getValue() {
            return this.get();
        }
    }

    public static class DynamicBooleanProperty
    extends PropertyWrapper<Boolean> {
        public DynamicBooleanProperty(String propName, Boolean defaultValue) {
            super(propName, defaultValue);
        }

        public Boolean get() {
            return this.prop.getBoolean((Boolean)this.defaultValue);
        }

        @Override
        public Boolean getValue() {
            return this.get();
        }
    }

    public static class BooleanProperty
    extends ChainLink<Boolean> {
        private final DynamicBooleanProperty sProp;

        public BooleanProperty(DynamicBooleanProperty sProperty) {
            this.sProp = sProperty;
        }

        public BooleanProperty(String name, DynamicBooleanProperty sProperty) {
            this(name, new BooleanProperty(sProperty));
        }

        public BooleanProperty(String name, BooleanProperty next) {
            this(new DynamicBooleanProperty(name, null), next);
        }

        public BooleanProperty(DynamicBooleanProperty sProperty, DynamicBooleanProperty next) {
            this(sProperty, new BooleanProperty(next));
        }

        public BooleanProperty(DynamicBooleanProperty sProperty, BooleanProperty next) {
            super(next);
            this.sProp = sProperty;
            this.sProp.addCallback(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Property changed: '" + BooleanProperty.this.getName() + " = " + BooleanProperty.this.getValue() + "'");
                    BooleanProperty.this.checkAndFlip();
                }
            });
            this.checkAndFlip();
        }

        @Override
        public boolean isValueAcceptable() {
            return this.sProp.getValue() != null;
        }

        @Override
        public Boolean getValue() {
            return this.sProp.get();
        }

        @Override
        public String getName() {
            return this.sProp.getName();
        }
    }

    public static class IntegerProperty
    extends ChainLink<Integer> {
        private final DynamicIntegerProperty sProp;

        public IntegerProperty(DynamicIntegerProperty sProperty) {
            this.sProp = sProperty;
        }

        public IntegerProperty(String name, DynamicIntegerProperty sProperty) {
            this(name, new IntegerProperty(sProperty));
        }

        public IntegerProperty(String name, IntegerProperty next) {
            this(new DynamicIntegerProperty(name, null), next);
        }

        public IntegerProperty(DynamicIntegerProperty sProperty, DynamicIntegerProperty next) {
            this(sProperty, new IntegerProperty(next));
        }

        public IntegerProperty(DynamicIntegerProperty sProperty, IntegerProperty next) {
            super(next);
            this.sProp = sProperty;
            this.sProp.addCallback(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Property changed: '" + IntegerProperty.this.getName() + " = " + IntegerProperty.this.getValue() + "'");
                    IntegerProperty.this.checkAndFlip();
                }
            });
            this.checkAndFlip();
        }

        @Override
        public boolean isValueAcceptable() {
            return this.sProp.get() != null;
        }

        @Override
        public Integer getValue() {
            return this.sProp.get();
        }

        @Override
        public String getName() {
            return this.sProp.getName();
        }
    }

    public static class StringProperty
    extends ChainLink<String> {
        private final DynamicStringProperty sProp;

        public StringProperty(DynamicStringProperty sProperty) {
            this.sProp = sProperty;
        }

        public StringProperty(String name, DynamicStringProperty sProperty) {
            this(name, new StringProperty(sProperty));
        }

        public StringProperty(String name, StringProperty next) {
            this(new DynamicStringProperty(name, null), next);
        }

        public StringProperty(DynamicStringProperty sProperty, DynamicStringProperty next) {
            this(sProperty, new StringProperty(next));
        }

        public StringProperty(DynamicStringProperty sProperty, StringProperty next) {
            super(next);
            this.sProp = sProperty;
            this.sProp.addCallback(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Property changed: '" + StringProperty.this.getName() + " = " + StringProperty.this.getValue() + "'");
                    StringProperty.this.checkAndFlip();
                }
            });
            this.checkAndFlip();
        }

        @Override
        public boolean isValueAcceptable() {
            return this.sProp.get() != null;
        }

        @Override
        protected String getValue() {
            return this.sProp.get();
        }

        @Override
        public String getName() {
            return this.sProp.getName();
        }
    }

    public static abstract class ChainLink<T> {
        private final AtomicReference<ChainLink<T>> pReference;
        private final ChainLink<T> next;
        private final List<Runnable> callbacks;

        public abstract String getName();

        protected abstract T getValue();

        public abstract boolean isValueAcceptable();

        public ChainLink() {
            this.next = null;
            this.pReference = new AtomicReference<ChainLink>(this);
            this.callbacks = new ArrayList<Runnable>();
        }

        public ChainLink(ChainLink<T> nextProperty) {
            this.next = nextProperty;
            this.pReference = new AtomicReference<ChainLink<T>>(this.next);
            this.callbacks = new ArrayList<Runnable>();
        }

        protected void checkAndFlip() {
            if (this.next == null) {
                this.pReference.set(this);
                return;
            }
            if (this.isValueAcceptable()) {
                logger.debug("Flipping property: " + this.getName() + " to use it's current value:" + this.getValue());
                this.pReference.set(this);
            } else {
                logger.debug("Flipping property: " + this.getName() + " to use NEXT property: " + this.next);
                this.pReference.set(this.next);
            }
            for (Runnable r : this.callbacks) {
                r.run();
            }
        }

        public T get() {
            if (this.pReference.get() == this) {
                return this.getValue();
            }
            return this.pReference.get().get();
        }

        public void addCallback(Runnable r) {
            this.callbacks.add(r);
        }

        public String toString() {
            return this.getName() + " = " + this.get();
        }
    }
}

