/*
 * Decompiled with CFR 0.152.
 */
package ua_parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import ua_parser.Client;
import ua_parser.Device;
import ua_parser.DeviceParser;
import ua_parser.OS;
import ua_parser.OSParser;
import ua_parser.UserAgent;
import ua_parser.UserAgentParser;

public class Parser {
    private static final String REGEX_YAML_PATH = "/ua_parser/regexes.yaml";
    public static final int CODE_POINT_LIMIT = 3455764;
    private UserAgentParser uaParser;
    private OSParser osParser;
    private DeviceParser deviceParser;

    public Parser() {
        this(Parser.getDefaultLoaderOptions());
    }

    public Parser(LoaderOptions loaderOptions) {
        try (InputStream is = Parser.class.getResourceAsStream(REGEX_YAML_PATH);){
            this.initialize(is, loaderOptions);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to initialize parser from regexes.yaml bundled in jar", e);
        }
    }

    public Parser(InputStream regexYaml) {
        this(regexYaml, Parser.getDefaultLoaderOptions());
    }

    public Parser(InputStream regexYaml, LoaderOptions loaderOptions) {
        this.initialize(regexYaml, loaderOptions);
    }

    public Client parse(String agentString) {
        UserAgent ua = this.parseUserAgent(agentString);
        OS os = this.parseOS(agentString);
        Device device = this.deviceParser.parse(agentString);
        return new Client(ua, os, device);
    }

    public UserAgent parseUserAgent(String agentString) {
        return this.uaParser.parse(agentString);
    }

    public Device parseDevice(String agentString) {
        return this.deviceParser.parse(agentString);
    }

    public OS parseOS(String agentString) {
        return this.osParser.parse(agentString);
    }

    public static LoaderOptions getDefaultLoaderOptions() {
        LoaderOptions options = new LoaderOptions();
        options.setCodePointLimit(3455764);
        return options;
    }

    private void initialize(InputStream regexYaml, LoaderOptions loaderOptions) {
        Yaml yaml = new Yaml(new SafeConstructor(loaderOptions));
        Map regexConfig = (Map)yaml.load(regexYaml);
        List uaParserConfigs = (List)regexConfig.get("user_agent_parsers");
        if (uaParserConfigs == null) {
            throw new IllegalArgumentException("user_agent_parsers is missing from yaml");
        }
        this.uaParser = UserAgentParser.fromList(uaParserConfigs);
        List osParserConfigs = (List)regexConfig.get("os_parsers");
        if (osParserConfigs == null) {
            throw new IllegalArgumentException("os_parsers is missing from yaml");
        }
        this.osParser = OSParser.fromList(osParserConfigs);
        List deviceParserConfigs = (List)regexConfig.get("device_parsers");
        if (deviceParserConfigs == null) {
            throw new IllegalArgumentException("device_parsers is missing from yaml");
        }
        this.deviceParser = DeviceParser.fromList(deviceParserConfigs);
    }
}

