/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicmodelzoo.cv.classification;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDArrays;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.Activation;
import ai.djl.nn.Block;
import ai.djl.nn.Blocks;
import ai.djl.nn.ParallelBlock;
import ai.djl.nn.SequentialBlock;
import ai.djl.nn.convolutional.Conv2d;
import ai.djl.nn.norm.Dropout;
import ai.djl.nn.pooling.Pool;
import java.util.Arrays;

public final class SqueezeNet {
    private SqueezeNet() {
    }

    static Block fire(int squeezePlanes, int expand1x1Planes, int expand3x3Planes) {
        SequentialBlock squeezeWithActivation = new SequentialBlock().add((Block)((Conv2d.Builder)((Conv2d.Builder)Conv2d.builder().setFilters(squeezePlanes)).setKernelShape(new Shape(new long[]{1L, 1L}))).build()).add(Activation::relu);
        SequentialBlock expand1x1 = new SequentialBlock().add((Block)((Conv2d.Builder)((Conv2d.Builder)Conv2d.builder().setFilters(expand1x1Planes)).setKernelShape(new Shape(new long[]{1L, 1L}))).build()).add(Activation::relu);
        SequentialBlock expand3x3 = new SequentialBlock().add((Block)((Conv2d.Builder)((Conv2d.Builder)((Conv2d.Builder)Conv2d.builder().setFilters(expand3x3Planes)).setKernelShape(new Shape(new long[]{3L, 3L}))).optPadding(new Shape(new long[]{1L, 1L}))).build()).add(Activation::relu);
        return new SequentialBlock().add((Block)squeezeWithActivation).add((Block)new ParallelBlock(list -> new NDList(new NDArray[]{NDArrays.concat((NDList)((NDList)list.get(0)).addAll((NDList)list.get(1)), (int)1)}), Arrays.asList(expand1x1, expand3x3)));
    }

    public static Block squeezenet(int outSize) {
        return new SequentialBlock().add((Block)((Conv2d.Builder)((Conv2d.Builder)((Conv2d.Builder)Conv2d.builder().setFilters(64)).setKernelShape(new Shape(new long[]{3L, 3L}))).optStride(new Shape(new long[]{2L, 2L}))).build()).add(Activation::relu).add(Pool.maxPool2dBlock((Shape)new Shape(new long[]{3L, 3L}), (Shape)new Shape(new long[]{2L, 2L}), (Shape)new Shape(new long[]{0L, 0L}), (boolean)true)).add(SqueezeNet.fire(16, 64, 64)).add(SqueezeNet.fire(16, 64, 64)).add(Pool.maxPool2dBlock((Shape)new Shape(new long[]{3L, 3L}), (Shape)new Shape(new long[]{2L, 2L}), (Shape)new Shape(new long[]{0L, 0L}), (boolean)true)).add(SqueezeNet.fire(32, 128, 128)).add(SqueezeNet.fire(32, 128, 128)).add(Pool.maxPool2dBlock((Shape)new Shape(new long[]{3L, 3L}), (Shape)new Shape(new long[]{2L, 2L}), (Shape)new Shape(new long[]{0L, 0L}), (boolean)true)).add(SqueezeNet.fire(48, 192, 192)).add(SqueezeNet.fire(48, 192, 192)).add(SqueezeNet.fire(64, 256, 256)).add(SqueezeNet.fire(64, 256, 256)).add((Block)Dropout.builder().optRate(0.5f).build()).add((Block)((Conv2d.Builder)((Conv2d.Builder)Conv2d.builder().setFilters(outSize)).setKernelShape(new Shape(new long[]{1L, 1L}))).build()).add(Activation::relu).add(Pool.globalAvgPool2dBlock()).add(Blocks.batchFlattenBlock());
    }
}

