/*
 * Decompiled with CFR 0.152.
 */
package water.server;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.util.Arrays;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import water.H2O;
import water.H2OError;
import water.Iced;
import water.api.schemas3.H2OErrorV3;
import water.exceptions.H2OAbstractRuntimeException;
import water.exceptions.H2OFailException;
import water.util.HttpResponseStatus;
import water.util.Log;
import water.util.StringUtils;

public class ServletUtils {
    private static final boolean DISABLE_CORS = Boolean.getBoolean("sys.ai.h2o.disable.cors");
    private static final String TRACE_METHOD = "TRACE";
    private static final ThreadLocal<Long> _startMillis = new ThreadLocal();
    private static final ThreadLocal<Integer> _status = new ThreadLocal();
    private static final ThreadLocal<String> _userAgent = new ThreadLocal();

    private ServletUtils() {
    }

    public static void startRequestLifecycle() {
        _startMillis.set(System.currentTimeMillis());
        _status.set(999);
    }

    private static void setStatus(int sc) {
        _status.set(sc);
    }

    private static int getStatus() {
        return _status.get();
    }

    private static long getStartMillis() {
        return _startMillis.get();
    }

    public static void startTransaction(String userAgent) {
        _userAgent.set(userAgent);
    }

    public static void endTransaction() {
        _userAgent.remove();
    }

    public static String getUserAgent() {
        return _userAgent.get();
    }

    public static void setResponseStatus(HttpServletResponse response, int sc) {
        ServletUtils.setStatus(sc);
        response.setStatus(sc);
    }

    public static void sendResponseError(HttpServletResponse response, int sc, String msg) throws IOException {
        ServletUtils.setStatus(sc);
        response.sendError(sc, msg);
    }

    public static InputStream extractPartInputStream(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String ct = request.getContentType();
        if (!ct.startsWith("multipart/form-data")) {
            ServletUtils.setResponseStatus(response, 400);
            response.getWriter().write("Content type must be multipart/form-data");
            return null;
        }
        int idx = ct.indexOf("boundary=");
        if (idx < 0) {
            ServletUtils.setResponseStatus(response, 400);
            response.getWriter().write("Boundary missing");
            return null;
        }
        String boundaryString = ct.substring(idx + "boundary=".length());
        byte[] boundary = StringUtils.bytesOf(boundaryString);
        ServletInputStream is = request.getInputStream();
        String line = ServletUtils.readLine((InputStream)is);
        while (line != null && line.trim().length() > 0) {
            line = ServletUtils.readLine((InputStream)is);
        }
        return new InputStreamWrapper((InputStream)is, boundary);
    }

    public static void sendErrorResponse(HttpServletResponse response, Exception exception, String uri) {
        if (exception instanceof H2OFailException) {
            H2OFailException ee = (H2OFailException)exception;
            H2OError error = ee.toH2OError(uri);
            Log.fatal("Caught exception (fatal to the cluster): " + error.toString());
            throw H2O.fail(error.toString());
        }
        if (exception instanceof H2OAbstractRuntimeException) {
            H2OAbstractRuntimeException ee = (H2OAbstractRuntimeException)exception;
            H2OError error = ee.toH2OError(uri);
            Log.warn("Caught exception: " + error.toString());
            ServletUtils.setResponseStatus(response, 500);
            ServletUtils.writeResponseErrorBody(response, error);
        } else {
            H2OError error = new H2OError(exception, uri);
            if (exception instanceof IllegalArgumentException) {
                error._http_status = HttpResponseStatus.BAD_REQUEST.getCode();
            } else if (exception instanceof FileNotFoundException) {
                error._http_status = HttpResponseStatus.BAD_REQUEST.getCode();
            } else if (exception instanceof MalformedURLException) {
                error._http_status = HttpResponseStatus.BAD_REQUEST.getCode();
            }
            ServletUtils.setResponseStatus(response, error._http_status);
            Log.warn("Caught exception: " + error.toString());
            ServletUtils.writeResponseErrorBody(response, error);
        }
    }

    private static void writeResponseErrorBody(HttpServletResponse response, H2OError error) {
        try {
            String s = ((Iced)new H2OErrorV3().fillFromImpl(error)).toJsonString();
            response.getWriter().write(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDecodedUri(HttpServletRequest request) {
        try {
            return URLDecoder.decode(request.getRequestURI(), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isXhrRequest(HttpServletRequest request) {
        String requestedWithHeader = request.getHeader("X-Requested-With");
        return "XMLHttpRequest".equals(requestedWithHeader);
    }

    public static boolean isTraceRequest(HttpServletRequest request) {
        return TRACE_METHOD.equalsIgnoreCase(request.getMethod());
    }

    public static void setCommonResponseHttpHeaders(HttpServletResponse response, boolean xhrRequest) {
        if (xhrRequest) {
            response.setHeader("Cache-Control", "no-cache");
        }
        if (DISABLE_CORS) {
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Access-Control-Allow-Headers", "*");
            response.setHeader("Access-Control-Allow-Methods", "*");
        }
        response.setHeader("X-h2o-build-project-version", H2O.ABV.projectVersion());
        response.setHeader("X-h2o-rest-api-version-max", Integer.toString(3));
        response.setHeader("X-h2o-cluster-id", Long.toString(H2O.CLUSTER_ID));
        response.setHeader("X-h2o-cluster-good", Boolean.toString(H2O.CLOUD.healthy()));
        response.setHeader("X-Frame-Options", "deny");
        response.setHeader("X-XSS-Protection", "1; mode=block");
        response.setHeader("X-Content-Type-Options", "nosniff");
        response.setHeader("Content-Security-Policy", "default-src 'self' 'unsafe-eval' 'unsafe-inline'; img-src 'self' data:");
        for (H2O.KeyValueArg header : H2O.ARGS.extra_headers) {
            response.addHeader(header._key, header._value);
        }
    }

    public static void logRequest(String method, HttpServletRequest request, HttpServletResponse response) {
        Log.httpd(method, request.getRequestURI(), ServletUtils.getStatus(), System.currentTimeMillis() - ServletUtils.getStartMillis());
    }

    private static String readLine(InputStream in) throws IOException {
        int sz;
        StringBuilder sb = new StringBuilder();
        byte[] mem = new byte[1024];
        do {
            sz = ServletUtils.readBufOrLine(in, mem);
            sb.append(new String(mem, 0, sz));
        } while (sz >= mem.length && mem[sz - 1] != 10);
        if (sb.length() == 0) {
            return null;
        }
        String line = sb.toString();
        if (line.endsWith("\r\n")) {
            line = line.substring(0, line.length() - 2);
        } else if (line.endsWith("\n")) {
            line = line.substring(0, line.length() - 1);
        }
        return line;
    }

    private static int readBufOrLine(InputStream in, byte[] mem) throws IOException {
        byte[] bb = new byte[1];
        int sz = 0;
        while (sz != mem.length) {
            byte b2;
            byte b;
            try {
                in.read(bb, 0, 1);
                b = bb[0];
                mem[sz++] = b;
            }
            catch (EOFException e) {
                break;
            }
            if (b == 10 || sz == mem.length) break;
            if (b != 13) continue;
            try {
                in.read(bb, 0, 1);
                b2 = bb[0];
                mem[sz++] = b2;
            }
            catch (EOFException e) {
                break;
            }
            if (b2 != 10) continue;
            break;
        }
        return sz;
    }

    private static final class InputStreamWrapper
    extends InputStream {
        static final byte[] BOUNDARY_PREFIX = new byte[]{13, 10, 45, 45};
        final InputStream _wrapped;
        final byte[] _boundary;
        final byte[] _lookAheadBuf;
        int _lookAheadLen;

        public InputStreamWrapper(InputStream is, byte[] boundary) {
            this._wrapped = is;
            this._boundary = Arrays.copyOf(BOUNDARY_PREFIX, BOUNDARY_PREFIX.length + boundary.length);
            System.arraycopy(boundary, 0, this._boundary, BOUNDARY_PREFIX.length, boundary.length);
            this._lookAheadBuf = new byte[this._boundary.length];
            this._lookAheadLen = 0;
        }

        @Override
        public void close() throws IOException {
            this._wrapped.close();
        }

        @Override
        public int available() throws IOException {
            return this._wrapped.available();
        }

        @Override
        public long skip(long n) throws IOException {
            return this._wrapped.skip(n);
        }

        @Override
        public void mark(int readlimit) {
            this._wrapped.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this._wrapped.reset();
        }

        @Override
        public boolean markSupported() {
            return this._wrapped.markSupported();
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int pos;
            if (this._lookAheadLen == -1) {
                return -1;
            }
            int readLen = this.readInternal(b, off, len);
            if (readLen != -1 && (pos = this.findBoundary(b, off, readLen)) != -1) {
                this._lookAheadLen = -1;
                return pos - off;
            }
            return readLen;
        }

        private int readInternal(byte[] b, int off, int len) throws IOException {
            if (len < this._lookAheadLen) {
                System.arraycopy(this._lookAheadBuf, 0, b, off, len);
                this._lookAheadLen -= len;
                System.arraycopy(this._lookAheadBuf, len, this._lookAheadBuf, 0, this._lookAheadLen);
                return len;
            }
            if (this._lookAheadLen > 0) {
                System.arraycopy(this._lookAheadBuf, 0, b, off, this._lookAheadLen);
                int r = Math.max(this._wrapped.read(b, off += this._lookAheadLen, len -= this._lookAheadLen), 0) + this._lookAheadLen;
                this._lookAheadLen = 0;
                return r;
            }
            return this._wrapped.read(b, off, len);
        }

        private int findBoundary(byte[] b, int off, int len) throws IOException {
            int bidx = -1;
            int idx = 0;
            for (int i = off; i < off + len; ++i) {
                if (this._boundary[idx] != b[i]) {
                    idx = 0;
                    bidx = -1;
                }
                if (this._boundary[idx] != b[i]) continue;
                if (idx == 0) {
                    bidx = i;
                }
                if (++idx != this._boundary.length) continue;
                return bidx;
            }
            if (bidx != -1) {
                assert (this._lookAheadLen == 0);
                this._lookAheadLen = this._boundary.length - idx;
                int readLen = this._wrapped.read(this._lookAheadBuf, 0, this._lookAheadLen);
                if (readLen < this._boundary.length - idx) {
                    this._lookAheadLen = readLen;
                    return -1;
                }
                for (int i = 0; i < this._boundary.length - idx; ++i) {
                    if (this._boundary[i + idx] == this._lookAheadBuf[i]) continue;
                    return -1;
                }
            }
            return bidx;
        }
    }
}

