/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.advmath;

import water.DKV;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.fvec.task.UniqTask;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.prims.mungers.AstGroup;
import water.rapids.vals.ValFrame;

public class AstUnique
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "unique";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        return new ValFrame(AstUnique.uniqueValuesBy(fr, 0));
    }

    public static Frame uniqueValuesBy(Frame fr, int columnIndex) {
        Vec v;
        Vec vec0 = fr.vec(columnIndex);
        if (vec0.isCategorical()) {
            v = Vec.makeSeq(0L, vec0.domain().length, true);
            v.setDomain(vec0.domain());
            DKV.put(v);
        } else {
            UniqTask t = (UniqTask)new UniqTask().doAll(vec0);
            int nUniq = t._uniq.size();
            final AstGroup.G[] uniq = t._uniq.keySet().toArray(new AstGroup.G[nUniq]);
            v = Vec.makeZero((long)nUniq, vec0.get_type());
            new MRTask(){

                @Override
                public void map(Chunk c) {
                    int start = (int)c.start();
                    for (int i = 0; i < c._len; ++i) {
                        c.set(i, uniq[i + start]._gs[0]);
                    }
                }
            }.doAll(v);
        }
        return new Frame(v);
    }
}

