/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import water.DKV;
import water.fvec.Frame;
import water.server.ServletUtils;
import water.util.FileUtils;
import water.util.Log;

public class DatasetServlet
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        String uri = ServletUtils.getDecodedUri(request);
        try {
            String suggested_fname;
            int x;
            String f_name = request.getParameter("frame_id");
            String hex_string = request.getParameter("hex_string");
            String escape_quotes_string = request.getParameter("escape_quotes");
            if (f_name == null) {
                throw new RuntimeException("Cannot find value for parameter 'frame_id'");
            }
            Frame dataset = (Frame)DKV.getGet(f_name);
            Frame.CSVStreamParams parms = new Frame.CSVStreamParams().setHexString(Boolean.parseBoolean(hex_string)).setEscapeQuotes(Boolean.parseBoolean(escape_quotes_string));
            InputStream is = dataset.toCSV(parms);
            response.setContentType("application/octet-stream");
            boolean dot = false;
            for (x = f_name.length() - 1; x >= 0; --x) {
                if (Character.isLetterOrDigit(f_name.charAt(x)) || f_name.charAt(x) == '_') continue;
                if (f_name.charAt(x) != '.' || dot) break;
                dot = true;
            }
            if (!(suggested_fname = f_name.substring(x + 1).replace(".hex", ".csv")).endsWith(".csv")) {
                suggested_fname = suggested_fname + ".csv";
            }
            f_name = suggested_fname;
            response.addHeader("Content-Disposition", "attachment; filename=" + f_name);
            ServletUtils.setResponseStatus(response, 200);
            ServletOutputStream os = null;
            try {
                os = response.getOutputStream();
                FileUtils.copyStream(is, (OutputStream)os, 2048);
                if (os == null) return;
            }
            catch (Throwable throwable) {
                if (os == null) throw throwable;
                try {
                    os.close();
                    throw throwable;
                }
                catch (Exception e) {
                    Log.err(e);
                }
                throw throwable;
            }
            try {
                os.close();
                return;
            }
            catch (Exception e) {
                Log.err(e);
            }
            return;
        }
        catch (Exception e) {
            ServletUtils.sendErrorResponse(response, e, uri);
            return;
        }
        finally {
            ServletUtils.logRequest("GET", request, response);
        }
    }
}

