/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.filters.dropduplicates;

import java.util.Arrays;
import water.fvec.Frame;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.prims.filters.dropduplicates.ColumnIndicesParser;
import water.rapids.ast.prims.filters.dropduplicates.DropDuplicateRows;
import water.rapids.ast.prims.filters.dropduplicates.KeepOrder;
import water.rapids.vals.ValFrame;
import water.util.EnumUtils;

public class AstDropDuplicates
extends AstPrimitive<AstDropDuplicates> {
    @Override
    public int nargs() {
        return 4;
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "frame", "cols", "droporder"};
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame deduplicatedFrame = stk.track(asts[1].exec(env)).getFrame();
        int[] comparedColumnsIndices = ColumnIndicesParser.parseAndCheckComparedColumnIndices(deduplicatedFrame, stk.track(asts[2].exec(env)));
        String dropOrderString = asts[3].str();
        KeepOrder keepOrder = EnumUtils.valueOfIgnoreCase(KeepOrder.class, dropOrderString).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown drop order: '%s'. Known types: %s", dropOrderString, Arrays.toString((Object[])KeepOrder.values()))));
        DropDuplicateRows dropDuplicateRows = new DropDuplicateRows(deduplicatedFrame, comparedColumnsIndices, keepOrder);
        Frame outputFrame = dropDuplicateRows.dropDuplicates();
        return new ValFrame(outputFrame);
    }

    @Override
    public String str() {
        return "dropdup";
    }
}

