/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.Model;
import hex.ModelExportOption;
import hex.grid.Grid;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import water.AutoBuffer;
import water.DKV;
import water.H2O;
import water.Key;
import water.api.Handler;
import water.api.schemas3.GridExportV3;
import water.api.schemas3.GridImportV3;
import water.api.schemas3.KeyV3;
import water.persist.Persist;
import water.util.FileUtils;

public class GridImportExportHandler
extends Handler {
    public KeyV3.GridKeyV3 importGrid(int version, GridImportV3 gridImportV3) throws IOException {
        Objects.requireNonNull(gridImportV3);
        this.validateGridImportParameters(gridImportV3);
        URI gridUri = FileUtils.getURI(gridImportV3.grid_path);
        Persist persist = H2O.getPM().getPersistForURI(gridUri);
        try (InputStream inputStream = persist.open(gridUri.toString());){
            AutoBuffer gridAutoBuffer = new AutoBuffer(inputStream);
            Object freezable = gridAutoBuffer.get();
            if (!(freezable instanceof Grid)) {
                throw new IllegalArgumentException(String.format("Given file '%s' is not a Grid", gridImportV3.grid_path));
            }
            Grid grid = (Grid)freezable;
            String gridDirectory = persist.getParent(gridUri.toString());
            GridImportExportHandler.loadGridModels(grid, gridDirectory);
            DKV.put(grid);
            KeyV3.GridKeyV3 gridKeyV3 = new KeyV3.GridKeyV3((Key<Grid>)grid._key);
            return gridKeyV3;
        }
    }

    public KeyV3.GridKeyV3 exportGrid(int version, GridExportV3 gridExportV3) throws IOException {
        this.validateGridExportParameters(gridExportV3);
        if (DKV.get(gridExportV3.grid_id) == null) {
            throw new IllegalArgumentException(String.format("Grid with id '%s' has not been found.", gridExportV3.grid_id));
        }
        Object possibleGrid = DKV.get(gridExportV3.grid_id).get();
        if (!(possibleGrid instanceof Grid)) {
            throw new IllegalArgumentException(String.format("Given Grid Key '%s' is not a valid Grid.", gridExportV3.grid_id));
        }
        Grid serializedGrid = (Grid)possibleGrid;
        serializedGrid.exportBinary(gridExportV3.grid_directory);
        ModelExportOption[] options = gridExportV3.getModelExportOptions();
        serializedGrid.exportModelsBinary(gridExportV3.grid_directory, options);
        return new KeyV3.GridKeyV3((Key<Grid>)serializedGrid._key);
    }

    private void validateGridExportParameters(GridExportV3 input) {
        Objects.requireNonNull(input);
        if (input.grid_directory == null || input.grid_directory.isEmpty()) {
            throw new IllegalArgumentException(String.format("Given grid directory '%s' is not a valid directory.", input.grid_directory));
        }
        if (input.grid_id == null || input.grid_id.isEmpty()) {
            throw new IllegalArgumentException(String.format("Invalid Grid id '%s'.", input.grid_id));
        }
    }

    private void validateGridImportParameters(GridImportV3 input) {
        Objects.requireNonNull(input);
        if (input.grid_path == null || input.grid_path.isEmpty()) {
            throw new IllegalArgumentException(String.format("Given grid directory '%s' is not a valid path.", input.grid_path));
        }
    }

    private static void loadGridModels(Grid grid, String gridDirectory) throws IOException {
        for (Key<Model> k : grid.getModelKeys()) {
            Object model = Model.importBinaryModel(gridDirectory + "/" + k.toString());
            assert (model != null);
        }
    }
}

