/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.TransformFoldAssignment;
import java.util.Arrays;
import water.Iced;
import water.Key;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.VecUtils;

public class FoldAssignment
extends Iced<FoldAssignment> {
    protected final Vec _fold;

    FoldAssignment(Vec fold) {
        this._fold = fold;
    }

    Frame toFrame(Key<Frame> key) {
        return new Frame(key, new String[]{"fold_assignment"}, new Vec[]{this._fold});
    }

    Vec getAdaptedFold() {
        return this._fold;
    }

    void remove(boolean keepOriginalFold) {
        if (!keepOriginalFold) {
            this._fold.remove();
        }
    }

    static FoldAssignment fromUserFoldSpecification(int N, Vec fold) {
        int[] foldValues = FoldAssignment.findActualFoldValues(fold);
        if (!(fold.isCategorical() || fold.isInt() && foldValues.length == N && (fold.min() == 0.0 && fold.max() == (double)(N - 1) || fold.min() == 1.0 && fold.max() == (double)N))) {
            throw new H2OIllegalArgumentException("Fold column must be either categorical or contiguous integers from 0..N-1 or 1..N");
        }
        return new TransformFoldAssignment(fold, foldValues);
    }

    static FoldAssignment fromInternalFold(int N, Vec fold) {
        assert (fold.isInt());
        assert (fold.min() == 0.0 && fold.max() == (double)(N - 1));
        return new FoldAssignment(fold);
    }

    static int nFoldWork(Vec fold) {
        return FoldAssignment.findActualFoldValues(fold).length;
    }

    static int[] findActualFoldValues(Vec f) {
        Object[] actualDomain;
        Vec fc = VecUtils.toCategoricalVec(f);
        try {
            actualDomain = !f.isCategorical() ? fc.domain() : VecUtils.collectDomainFast(fc);
        }
        finally {
            fc.remove();
        }
        int N = actualDomain.length;
        if (Arrays.equals(actualDomain, fc.domain())) {
            int offset = f.isCategorical() ? 0 : (int)f.min();
            return ArrayUtils.seq(offset, N + offset);
        }
        int[] mapping = new int[N];
        String[] fullDomain = fc.domain();
        for (int i = 0; i < N; ++i) {
            int pos = ArrayUtils.find(fullDomain, actualDomain[i]);
            assert (pos >= 0);
            mapping[i] = pos;
        }
        return mapping;
    }
}

