/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Distribution;
import hex.LinkFunction;
import hex.LogExpUtil;
import hex.LogFunction;
import hex.genmodel.utils.DistributionFamily;

class PoissonDistribution
extends Distribution {
    public PoissonDistribution(DistributionFamily family) {
        super(family, (LinkFunction)new LogFunction());
    }

    @Override
    public double deviance(double w, double y, double f) {
        f = this.link(f);
        return -2.0 * w * (y * f - LogExpUtil.exp(f));
    }

    @Override
    public double negHalfGradient(double y, double f) {
        return y - this.linkInv(f);
    }

    @Override
    public double initFNum(double w, double o, double y) {
        return w * y;
    }

    @Override
    public double initFDenom(double w, double o, double y) {
        return w * this.linkInv(o);
    }

    @Override
    public double gammaNum(double w, double y, double z, double f) {
        return w * y;
    }

    @Override
    public double gammaDenom(double w, double y, double z, double f) {
        return w * (y - z);
    }
}

