/*
 * Decompiled with CFR 0.152.
 */
package water.api.schemas3;

import hex.Model;
import org.apache.log4j.Logger;
import water.AutoBuffer;
import water.Freezable;
import water.H2O;
import water.Keyed;
import water.api.API;
import water.api.Schema;
import water.api.schemas3.KeyV3;
import water.api.schemas3.ModelOutputSchemaV3;
import water.api.schemas3.ModelParametersSchemaV3;
import water.api.schemas3.ModelSchemaBaseV3;
import water.exceptions.H2OIllegalArgumentException;
import water.util.PojoUtils;

public class ModelSchemaV3<M extends Model<M, P, O>, S extends ModelSchemaV3<M, S, P, PS, O, OS>, P extends Model.Parameters, PS extends ModelParametersSchemaV3<P, PS>, O extends Model.Output, OS extends ModelOutputSchemaV3<O, OS>>
extends ModelSchemaBaseV3<M, S> {
    private static final Logger LOG = Logger.getLogger(ModelSchemaV3.class);
    @API(help="The build parameters for the model (e.g. K for KMeans).", direction=API.Direction.OUTPUT)
    public PS parameters;
    @API(help="The build output for the model (e.g. the cluster centers for KMeans).", direction=API.Direction.OUTPUT)
    public OS output;
    @API(help="Compatible frames, if requested", direction=API.Direction.OUTPUT)
    public String[] compatible_frames;
    @API(help="Checksum for all the things that go into building the Model.", direction=API.Direction.OUTPUT)
    protected long checksum;
    private PS input_parameters;

    public ModelSchemaV3() {
    }

    public ModelSchemaV3(M m) {
        super(m);
        PojoUtils.copyProperties(this.parameters, ((Model)m)._parms, PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES);
        PojoUtils.copyProperties(this.output, ((Model)m)._output, PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES);
    }

    public PS createParametersSchema() {
        throw H2O.fail("createParametersSchema() must be implemented in class: " + this.getClass());
    }

    public OS createOutputSchema() {
        throw H2O.fail("createOutputSchema() must be implemented in class: " + this.getClass());
    }

    @Override
    public S fillFromImpl(M m) {
        this.timestamp = ((Model.Output)((Model)m)._output)._job == null ? -1L : (((Model.Output)((Model)m)._output)._job.isRunning() ? 0L : ((Model.Output)((Model)m)._output)._job.end_time());
        this.data_frame = new KeyV3.FrameKeyV3(((Model.Parameters)((Model)m)._parms)._train);
        this.response_column_name = ((Model.Parameters)((Model)m)._parms)._response_column;
        this.algo = ((Model.Parameters)((Model)m)._parms).algoName().toLowerCase();
        this.algo_full_name = ((Model.Parameters)((Model)m)._parms).fullName();
        this.model_id = new KeyV3.ModelKeyV3(((Model)m)._key);
        this.checksum = ((Keyed)m).checksum();
        this.have_pojo = ((Model)m).havePojo();
        this.have_mojo = ((Model)m).haveMojo();
        this.parameters = this.createParametersSchema();
        ((ModelParametersSchemaV3)this.parameters).fillFromImpl(((Model)m)._parms);
        if (((Model)m)._input_parms != null) {
            this.input_parameters = this.createParametersSchema();
            ((ModelParametersSchemaV3)this.input_parameters).fillFromImpl(((Model)m)._input_parms);
        }
        ((ModelParametersSchemaV3)this.parameters).model_id = this.model_id;
        this.output = this.createOutputSchema();
        ((ModelOutputSchemaV3)this.output).fillFromImpl(((Model)m)._output);
        return (S)this;
    }

    public final AutoBuffer writeJSON_impl(AutoBuffer ab) {
        ab.putJSONStr("algo", this.algo);
        ab.put1(44);
        ab.putJSONStr("algo_full_name", this.algo_full_name);
        ab.put1(44);
        ab.putJSON("model_id", this.model_id);
        ab.put1(44);
        try {
            Object defaults = ((ModelParametersSchemaV3)this.createParametersSchema()).fillFromImpl((Model.Parameters)((Model.Parameters)((Schema)this.parameters).getImplClass().newInstance()));
            ModelParametersSchemaV3.writeParametersJSON(ab, this.parameters, this.input_parameters, defaults, "parameters");
            ab.put1(44);
        }
        catch (Exception e) {
            LOG.error((Object)("Error creating an instance of ModelParameters for algo: " + this.algo), (Throwable)e);
            String msg = "Error creating an instance of ModelParameters for algo: " + this.algo;
            String dev_msg = "Error creating an instance of ModelParameters for algo: " + this.algo + ": " + this.getImplClass();
            throw new H2OIllegalArgumentException(msg, dev_msg);
        }
        if (null == this.output) {
            this.output = this.createOutputSchema();
        }
        ab.putJSON("output", (Freezable)this.output);
        ab.put1(44);
        ab.putJSONAStr("compatible_frames", this.compatible_frames);
        return ab;
    }
}

