/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.Arrays;
import jsr166y.CountedCompleter;
import jsr166y.ForkJoinPool;
import jsr166y.ForkJoinTask;
import water.DKV;
import water.DTask;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.Key;
import water.RPC;
import water.fvec.AppendableVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.DistributedException;
import water.util.FrameUtils;
import water.util.PrettyPrint;

public abstract class MRTask<T extends MRTask<T>>
extends DTask<T>
implements ForkJoinPool.ManagedBlocker {
    public Frame _fr;
    public Key[] _keys;
    private byte[] _output_types;
    private int _vid;
    protected AppendableVec[] _appendables;
    protected transient RPC<T> _nleft;
    protected transient RPC<T> _nrite;
    protected transient boolean _topLocal;
    transient boolean _topGlobal = false;
    protected transient T _left;
    protected transient T _rite;
    private transient T _res;
    protected short _nlo;
    protected short _nhi;
    protected transient int _lo;
    protected transient int _hi;
    protected transient Futures _fs;
    protected boolean _run_local;
    private PostMapAction<?> _postMap;
    MRProfile _profile;

    public MRTask() {
    }

    protected MRTask(H2O.H2OCountedCompleter cmp) {
        super(cmp);
    }

    protected MRTask(byte prior) {
        super(prior);
    }

    public AppendableVec[] appendables() {
        return this._appendables;
    }

    public final MRTask<T> withPostMapAction(PostMapAction<?> postMap) {
        this._postMap = postMap;
        return this;
    }

    public String profString() {
        return this._profile != null ? this._profile.toString() : "Profiling turned off";
    }

    public T profile() {
        this._profile = new MRProfile(this);
        return (T)this;
    }

    public Frame outputFrame() {
        return this.outputFrame(null, null, null);
    }

    public Frame outputFrame(String[] names, String[][] domains) {
        return this.outputFrame(null, names, domains);
    }

    public Frame outputFrame(Key<Frame> key, String[] names, String[][] domains) {
        Frame res = this.closeFrame(key, names, domains);
        if (key != null) {
            DKV.put(res);
        }
        return res;
    }

    private Frame closeFrame(Key key, String[] names, String[][] domains) {
        if (this._output_types == null) {
            return null;
        }
        int noutputs = this._output_types.length;
        Vec[] vecs = new Vec[noutputs];
        if (this._appendables == null || this._appendables.length == 0) {
            for (int i = 0; i < noutputs; ++i) {
                vecs[i] = this._fr.anyVec().makeZero();
            }
        } else {
            Futures fs = new Futures();
            int rowLayout = this._appendables[0].compute_rowLayout();
            for (int i = 0; i < noutputs; ++i) {
                this._appendables[i].setDomain(domains == null ? null : domains[i]);
                vecs[i] = this._appendables[i].close(rowLayout, fs);
            }
            fs.blockForPending();
        }
        return new Frame(key, names, vecs);
    }

    public void map(Chunk c) {
    }

    public void map(Chunk c, NewChunk nc) {
    }

    public void map(Chunk c0, Chunk c1) {
    }

    public void map(Chunk c0, Chunk c1, NewChunk nc) {
    }

    public void map(Chunk c0, NewChunk nc0, NewChunk nc1) {
    }

    public void map(Chunk c0, Chunk c1, Chunk c2) {
    }

    public void map(Chunk[] cs) {
    }

    public void map(Chunk[] cs, NewChunk nc) {
    }

    public void map(Chunk[] cs, NewChunk nc1, NewChunk nc2) {
    }

    public void map(Chunk[] cs, NewChunk[] ncs) {
    }

    public void map(Key key) {
    }

    public void reduce(T mrt) {
    }

    protected void setupLocal() {
    }

    protected void closeLocal() {
    }

    private int addShift(int x) {
        int sz = H2O.CLOUD.size();
        return (x += this._nlo) < sz ? x : x - sz;
    }

    private int subShift(int x) {
        int sz = H2O.CLOUD.size();
        return (x -= this._nlo) < 0 ? x + sz : x;
    }

    private short selfidx() {
        int idx = H2O.SELF.index();
        if (idx >= 0) {
            return (short)idx;
        }
        assert (H2O.SELF.isClient());
        return 0;
    }

    protected T self() {
        return (T)this;
    }

    public final T doAll(Vec ... vecs) {
        return this.doAll((byte[])null, vecs);
    }

    public final T doAll(byte[] outputTypes, Vec ... vecs) {
        return this.doAll(outputTypes, new Frame(vecs), false);
    }

    public final T doAll(byte outputType, Vec ... vecs) {
        return this.doAll(new byte[]{outputType}, new Frame(vecs), false);
    }

    public final T doAll(Vec vec, boolean runLocal) {
        return this.doAll(null, vec, runLocal);
    }

    public final T doAll(byte[] outputTypes, Vec vec, boolean runLocal) {
        return this.doAll(outputTypes, new Frame(vec), runLocal);
    }

    public final T doAll(Frame fr, boolean runLocal) {
        return this.doAll(null, fr, runLocal);
    }

    public final T doAll(Frame fr) {
        return this.doAll(null, fr, false);
    }

    public final T doAll(byte[] outputTypes, Frame fr) {
        return this.doAll(outputTypes, fr, false);
    }

    public final T doAll(byte outputType, Frame fr) {
        return this.doAll(new byte[]{outputType}, fr, false);
    }

    public final T doAll(byte[] outputTypes, Frame fr, boolean runLocal) {
        this.dfork(outputTypes, fr, runLocal);
        return this.getResult();
    }

    public final T doAll(int numberOfOutputs, byte outputType, Frame fr) {
        byte[] types = new byte[numberOfOutputs];
        Arrays.fill(types, outputType);
        return this.doAll(types, fr, false);
    }

    public T doAll(Key ... keys) {
        this.dfork(keys);
        return this.getResult();
    }

    public void dfork(Key ... keys) {
        this._topGlobal = true;
        this._keys = keys;
        this._nlo = this.selfidx();
        this._nhi = (short)H2O.CLOUD.size();
        this.setupLocal0();
        H2O.submitTask(this);
    }

    public T doAllNodes() {
        return this.doAll((Key[])null);
    }

    public void asyncExecOnAllNodes() {
        this.dfork((Key[])null);
    }

    public final T dfork(byte[] outputTypes, Vec ... vecs) {
        return this.dfork(outputTypes, new Frame(vecs), false);
    }

    public final T dfork(Vec ... vecs) {
        return this.dfork(null, new Frame(vecs), false);
    }

    public final T dfork(Frame fr) {
        return this.dfork(null, fr, false);
    }

    public final T dfork(byte[] outputTypes, Frame fr, boolean runLocal) {
        this._topGlobal = true;
        this._output_types = outputTypes;
        if (outputTypes != null && outputTypes.length > 0) {
            this._vid = fr.anyVec().group().reserveKeys(outputTypes.length);
        }
        this._fr = fr;
        this._nlo = this.selfidx();
        this._nhi = (short)H2O.CLOUD.size();
        this._run_local = runLocal;
        assert (this.checkRunLocal()) : "MRTask is expected to be running in a local-mode but _run_local = false";
        this.setupLocal0();
        H2O.submitTask(this);
        return this.self();
    }

    private boolean checkRunLocal() {
        if (!Boolean.getBoolean("sys.ai.h2o.debug.checkRunLocal")) {
            return true;
        }
        if ("water.fvec.RollupStats$Roll".equals(this.getClass().getName())) {
            return true;
        }
        return this._run_local;
    }

    public final T getResult(boolean fjManagedBlock) {
        assert (this.getCompleter() == null);
        do {
            try {
                if (fjManagedBlock) {
                    ForkJoinPool.managedBlock(this);
                } else {
                    this.block();
                }
                this.join();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable re) {
                this.onExceptionalCompletion(re, null);
                throw re instanceof DistributedException ? new DistributedException(re.getMessage(), re.getCause()) : new DistributedException(re);
            }
        } while (!this.isReleasable());
        assert (this._topGlobal) : "lost top global flag";
        return this.self();
    }

    public final T getResult() {
        return this.getResult(true);
    }

    @Override
    public boolean isReleasable() {
        return this.isDone();
    }

    @Override
    public boolean block() throws InterruptedException {
        while (!this.isDone()) {
            this.join();
        }
        return true;
    }

    @Override
    public final void dinvoke(H2ONode sender) {
        this.setupLocal0();
        H2O.submitTask(this);
    }

    protected boolean modifiesVolatileVecs() {
        return true;
    }

    private void setupLocal0() {
        if (this._profile != null) {
            this._profile = new MRProfile(this);
            new MRProfile(this)._localstart = System.currentTimeMillis();
        }
        this._fs = new Futures();
        if (this.modifiesVolatileVecs() && this._fr != null) {
            for (Vec v : this._fr.vecs()) {
                if (!v.isVolatile()) continue;
                v.preWriting();
            }
        }
        this._topLocal = true;
        short selfidx = this.selfidx();
        int nlo = this.subShift(selfidx);
        assert (nlo < this._nhi);
        int nmid = nlo + this._nhi >>> 1;
        if (!this._run_local && (nlo + 1 < this._nhi || H2O.ARGS.client)) {
            if (this._profile != null) {
                this._profile._rpcLstart = System.currentTimeMillis();
            }
            this._nleft = this.remote_compute(H2O.ARGS.client ? nlo : nlo + 1, nmid);
            if (this._profile != null) {
                this._profile._rpcRstart = System.currentTimeMillis();
            }
            this._nrite = this.remote_compute(nmid, this._nhi);
            if (this._profile != null) {
                this._profile._rpcRdone = System.currentTimeMillis();
            }
        } else if (this._profile != null) {
            this._profile._rpcRstart = this._profile._rpcRdone = System.currentTimeMillis();
            this._profile._rpcLstart = this._profile._rpcRdone;
        }
        if (this._fr != null) {
            this._lo = 0;
            this._hi = this._fr.numCols() == 0 ? 0 : this._fr.anyVec().nChunks();
            this._fr.vecs();
        } else if (this._keys != null) {
            this._lo = 0;
            this._hi = this._keys.length;
        }
        this.setupLocal();
        if (this._profile != null) {
            this._profile._localdone = System.currentTimeMillis();
        }
    }

    private RPC<T> remote_compute(int nlo, int nhi) {
        if (nlo < nhi) {
            int node = this.addShift(nlo);
            assert (node != H2O.SELF.index());
            T mrt = this.copyAndInit();
            ((MRTask)mrt)._nhi = (short)nhi;
            this.addToPendingCount(1);
            return new RPC<T>(H2O.CLOUD._memary[node], mrt).addCompleter(this).call();
        }
        return null;
    }

    @Override
    public final void compute2() {
        block40: {
            block39: {
                assert (this._left == null && this._rite == null && this._res == null);
                if (this._profile != null) {
                    this._profile._mapstart = System.currentTimeMillis();
                }
                if (this._hi - this._lo >= 2) {
                    int mid = this._lo + this._hi >>> 1;
                    this._left = this.copyAndInit();
                    this._rite = this.copyAndInit();
                    ((MRTask)this._left)._hi = mid;
                    ((MRTask)this._rite)._lo = mid;
                    this.addToPendingCount(1);
                    if (!this.isCompletedAbnormally()) {
                        ((ForkJoinTask)this._left).fork();
                    }
                    if (!this.isCompletedAbnormally()) {
                        ((MRTask)this._rite).compute2();
                    }
                    if (this._profile != null) {
                        this._profile._mapdone = System.currentTimeMillis();
                    }
                    return;
                }
                if (this._fr != null) break block39;
                if (this._keys != null && (this._hi <= this._lo || !this._keys[this._lo].home())) break block40;
                assert (this._keys == null || !H2O.ARGS.client) : "Client node should not process any keys in MRTask!";
                if (this._profile != null) {
                    this._profile._userstart = System.currentTimeMillis();
                }
                if (this._keys != null) {
                    this.map(this._keys[this._lo]);
                }
                this._res = this.self();
                if (this._postMap != null) {
                    this._postMap.call(this._keys[this._lo]);
                }
                if (this._profile == null) break block40;
                this._profile._closestart = System.currentTimeMillis();
                break block40;
            }
            if (this._hi > this._lo) {
                Vec v0 = this._fr.anyVec();
                if (this._run_local || v0.chunkKey(this._lo).home()) {
                    int num_outputs;
                    assert (this._run_local || !H2O.ARGS.client) : "Client node should not process any keys in MRTask!";
                    NewChunk[] appendableChunks = null;
                    Chunk[] bvs = FrameUtils.extractChunks(this._fr, this._lo, this._run_local);
                    if (this._output_types != null) {
                        Vec.VectorGroup vg = v0.group();
                        this._appendables = new AppendableVec[this._output_types.length];
                        appendableChunks = new NewChunk[this._output_types.length];
                        for (int i = 0; i < this._appendables.length; ++i) {
                            this._appendables[i] = new AppendableVec(vg.vecKey(this._vid + i), this._output_types[i]);
                            appendableChunks[i] = this._appendables[i].chunkForChunkIdx(this._lo);
                        }
                    }
                    if (this._profile != null) {
                        this._profile._userstart = System.currentTimeMillis();
                    }
                    int num_fr_vecs = this._fr.vecs().length;
                    int n = num_outputs = this._output_types == null ? 0 : this._output_types.length;
                    if (num_outputs == 0) {
                        if (num_fr_vecs == 1) {
                            this.map(bvs[0]);
                        } else if (num_fr_vecs == 2) {
                            this.map(bvs[0], bvs[1]);
                        } else if (num_fr_vecs == 3) {
                            this.map(bvs[0], bvs[1], bvs[2]);
                        }
                        this.map(bvs);
                    } else if (num_outputs == 1) {
                        assert (appendableChunks != null);
                        if (num_fr_vecs == 1) {
                            this.map(bvs[0], appendableChunks[0]);
                        } else if (num_fr_vecs == 2) {
                            this.map(bvs[0], bvs[1], appendableChunks[0]);
                        }
                        this.map(bvs, appendableChunks[0]);
                    } else if (num_outputs == 2) {
                        assert (appendableChunks != null);
                        if (num_fr_vecs == 1) {
                            this.map(bvs[0], appendableChunks[0], appendableChunks[1]);
                        }
                        this.map(bvs, appendableChunks[0], appendableChunks[1]);
                    }
                    if (num_outputs >= 0) {
                        this.map(bvs, appendableChunks);
                    }
                    this._res = this.self();
                    if (this._profile != null) {
                        this._profile._closestart = System.currentTimeMillis();
                    }
                    if (this._postMap != null) {
                        this._postMap.call(bvs);
                    }
                    for (Chunk chunk : bvs) {
                        chunk.close(this._lo, this._fs);
                    }
                    if (this._output_types != null) {
                        for (Chunk chunk : appendableChunks) {
                            chunk.close(this._lo, this._fs);
                        }
                    }
                }
            }
        }
        if (this._profile != null) {
            this._profile._mapdone = System.currentTimeMillis();
        }
        this.tryComplete();
    }

    @Override
    public final void onCompletion(CountedCompleter caller) {
        if (this._profile != null) {
            this._profile._onCstart = System.currentTimeMillis();
        }
        this.reduce2((MRTask<T>)this._left);
        this._left = null;
        this.reduce2((MRTask<T>)this._rite);
        this._rite = null;
        if (this._profile != null) {
            this._profile._reducedone = System.currentTimeMillis();
        }
        if (this._topLocal) {
            this.postLocal0();
        }
        if (this._profile != null) {
            this._profile._onCdone = System.currentTimeMillis();
        }
    }

    private void reduce2(MRTask<T> mrt) {
        if (mrt == null) {
            return;
        }
        if (this._profile != null) {
            this._profile.gather(mrt._profile, 0);
        }
        if (this._res == null) {
            this._res = mrt._res;
        } else if (mrt._res != null) {
            ((MRTask)this._res).reduce4(mrt._res);
        }
        assert (this._fs == mrt._fs);
    }

    protected void postGlobal() {
    }

    private void postLocal0() {
        this.closeLocal();
        if (this._profile != null) {
            this._profile._closeLocalDone = System.currentTimeMillis();
        }
        this.reduce3(this._nleft);
        this.reduce3(this._nrite);
        if (this._profile != null) {
            this._profile._remoteBlkDone = System.currentTimeMillis();
        }
        this._fs.blockForPending();
        if (this._profile != null) {
            this._profile._localBlkDone = System.currentTimeMillis();
        }
        if (this._res == null) {
            this._nhi = (short)-1;
        } else if (this._res != this) {
            ((MRTask)this._res)._profile = this._profile;
            this.copyOver(this._res);
        }
        if (this._topGlobal) {
            if (this._fr != null) {
                this._fr.postWrite(this._fs).blockForPending();
            }
            this.postGlobal();
        }
    }

    private void reduce3(RPC<T> rpc) {
        if (rpc == null) {
            return;
        }
        MRTask mrt = (MRTask)rpc.get();
        if (this._profile != null) {
            this._profile.gather(mrt._profile, rpc.size_rez());
        }
        if ((long)mrt._nhi != -1L) {
            if (this._res == null) {
                this._res = mrt;
            } else {
                this._res.reduce4((MRTask)mrt);
            }
        }
    }

    void reduce4(T mrt) {
        if (this._output_types != null) {
            for (int i = 0; i < this._appendables.length; ++i) {
                this._appendables[i].reduce(((MRTask)mrt)._appendables[i]);
            }
        }
        if (this._ex == null) {
            this._ex = ((MRTask)mrt)._ex;
        }
        this.reduce(mrt);
    }

    void self_cancel2() {
        if (!this.isDone()) {
            this.cancel(true);
            this.self_cancel1();
        }
    }

    private void self_cancel1() {
        T r;
        T l = this._left;
        if (l != null) {
            ((MRTask)l).self_cancel2();
        }
        if ((r = this._rite) != null) {
            ((MRTask)r).self_cancel2();
        }
    }

    @Override
    public final boolean onExceptionalCompletion(Throwable ex, CountedCompleter caller) {
        this.self_cancel1();
        RPC<T> nl = this._nleft;
        if (nl != null) {
            try {
                nl.get();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this._nleft = null;
        RPC<T> nr = this._nrite;
        if (nr != null) {
            try {
                nr.get();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this._nrite = null;
        return true;
    }

    private T copyAndInit() {
        MRTask x = (MRTask)this.clone();
        x._topGlobal = false;
        x.setCompleter(this);
        x._topLocal = false;
        x._nrite = null;
        x._nleft = null;
        x._rite = null;
        x._left = null;
        x._fs = this._fs;
        x._profile = this._profile != null ? new MRProfile(this) : null;
        x.setPendingCount(0);
        return (T)x;
    }

    public static abstract class PostMapAction<T extends PostMapAction<T>>
    extends Iced<T> {
        void call(Key mapInput) {
        }

        void call(Chunk[] mapInput) {
        }
    }

    private static class MRProfile
    extends Iced {
        String _clz;
        long _localstart;
        long _rpcLstart;
        long _rpcRstart;
        long _rpcRdone;
        long _localdone;
        long _mapstart;
        long _userstart;
        long _closestart;
        long _mapdone;
        long _onCstart;
        long _reducedone;
        long _closeLocalDone;
        long _remoteBlkDone;
        long _localBlkDone;
        long _onCdone;
        long _time1st;
        long _done1st;
        int _size_rez0;
        int _size_rez1;
        MRProfile _last;

        public MRProfile(MRTask mrt) {
            this._clz = mrt.getClass().toString();
            this._localdone = System.currentTimeMillis();
        }

        long sumTime() {
            return this._onCdone - (this._localstart == 0L ? this._mapstart : this._localstart);
        }

        void gather(MRProfile p, int size_rez) {
            p._clz = null;
            if (this._last == null) {
                this._last = p;
                this._time1st = p.sumTime();
                this._done1st = p._onCdone;
            } else {
                MRProfile first = this._last._onCdone <= p._onCdone ? this._last : p;
                MRProfile mRProfile = this._last = this._last._onCdone > p._onCdone ? this._last : p;
                if (first._onCdone > this._done1st) {
                    this._time1st = first.sumTime();
                    this._done1st = first._onCdone;
                }
            }
            if (size_rez != 0) {
                if (this._size_rez0 == 0) {
                    this._size_rez0 = size_rez;
                } else {
                    this._size_rez1 = size_rez;
                }
            }
            assert (this._userstart != 0L || this._last != null);
            assert (this._last._onCdone >= this._done1st);
        }

        public String toString() {
            return this.print(new StringBuilder(), 0).toString();
        }

        private StringBuilder print(StringBuilder sb, int d) {
            int i;
            if (d == 0) {
                sb.append(this._clz).append("\n");
            }
            for (i = 0; i < d; ++i) {
                sb.append("  ");
            }
            if (this._localstart != 0L) {
                sb.append("Node local ").append(this._localdone - this._localstart).append("ms, ");
            }
            if (this._last != null) {
                sb.append("Slow wait ").append(this._mapstart - this._localdone).append("ms + work ").append(this._last.sumTime()).append("ms, ");
                sb.append("Fast work ").append(this._time1st).append("ms + wait ").append(this._onCstart - this._done1st).append("ms\n");
                this._last.print(sb, d + 1);
                for (i = 0; i < d; ++i) {
                    sb.append("  ");
                }
                sb.append("join-i/o ").append(this._onCstart - this._last._onCdone).append("ms, ");
            }
            if (this._userstart != 0L) {
                sb.append("Map ").append(this._mapdone - this._mapstart).append("ms (prep ").append(this._userstart - this._mapstart);
                sb.append("ms, user ").append(this._closestart - this._userstart);
                sb.append("ms, closeChk ").append(this._mapdone - this._closestart).append("ms), ");
            }
            sb.append("Red ").append(this._onCdone - this._onCstart);
            sb.append("ms (locRed ").append(this._reducedone - this._onCstart).append("ms");
            if (this._remoteBlkDone != 0L) {
                sb.append(", close ").append(this._closeLocalDone - this._reducedone);
                sb.append("ms, remBlk ").append(this._remoteBlkDone - this._closeLocalDone);
                sb.append("ms, locBlk ").append(this._localBlkDone - this._remoteBlkDone);
                sb.append("ms, close ").append(this._onCdone - this._localBlkDone);
                sb.append("ms, size ").append(PrettyPrint.bytes(this._size_rez0)).append("+").append(PrettyPrint.bytes(this._size_rez1));
            }
            sb.append(")\n");
            return sb;
        }
    }
}

