/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Distribution;
import hex.LinkFunction;
import hex.LogExpUtil;
import hex.LogFunction;
import hex.Model;

class TweedieDistribution
extends Distribution {
    public TweedieDistribution(Model.Parameters params) {
        super(params, (LinkFunction)new LogFunction());
    }

    @Override
    public double deviance(double w, double y, double f) {
        f = this.link(f);
        assert (this._tweediePower > 1.0 && this._tweediePower < 2.0);
        return 2.0 * w * (Math.pow(y, 2.0 - this._tweediePower) / ((1.0 - this._tweediePower) * (2.0 - this._tweediePower)) - y * LogExpUtil.exp(f * (1.0 - this._tweediePower)) / (1.0 - this._tweediePower) + LogExpUtil.exp(f * (2.0 - this._tweediePower)) / (2.0 - this._tweediePower));
    }

    @Override
    public double negHalfGradient(double y, double f) {
        assert (this._tweediePower > 1.0 && this._tweediePower < 2.0);
        return y * LogExpUtil.exp(f * (1.0 - this._tweediePower)) - LogExpUtil.exp(f * (2.0 - this._tweediePower));
    }

    @Override
    public double initFNum(double w, double o, double y) {
        return w * y * LogExpUtil.exp(o * (1.0 - this._tweediePower));
    }

    @Override
    public double initFDenom(double w, double o, double y) {
        return w * LogExpUtil.exp(o * (2.0 - this._tweediePower));
    }

    @Override
    public double gammaNum(double w, double y, double z, double f) {
        return w * y * LogExpUtil.exp(f * (1.0 - this._tweediePower));
    }

    @Override
    public double gammaDenom(double w, double y, double z, double f) {
        return w * LogExpUtil.exp(f * (2.0 - this._tweediePower));
    }
}

