/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.BernoulliDistribution;
import hex.CustomDistribution;
import hex.Distribution;
import hex.GammaDistribution;
import hex.GaussianDistribution;
import hex.HuberDistribution;
import hex.LaplaceDistribution;
import hex.Model;
import hex.ModifiedHuberDistribution;
import hex.MultinomialDistribution;
import hex.PoissonDistribution;
import hex.QuantileDistribution;
import hex.QuasibinomialDistribution;
import hex.TweedieDistribution;
import hex.genmodel.utils.DistributionFamily;
import water.H2O;

public class DistributionFactory {
    public static Distribution getDistribution(DistributionFamily family) {
        switch (family) {
            case bernoulli: {
                return new BernoulliDistribution(family);
            }
            case quasibinomial: {
                return new QuasibinomialDistribution(family);
            }
            case modified_huber: {
                return new ModifiedHuberDistribution(family);
            }
            case multinomial: {
                return new MultinomialDistribution(family);
            }
            case AUTO: 
            case gaussian: {
                return new GaussianDistribution(family);
            }
            case poisson: {
                return new PoissonDistribution(family);
            }
            case gamma: {
                return new GammaDistribution(family);
            }
            case laplace: {
                return new LaplaceDistribution(family);
            }
        }
        throw H2O.unimpl("Try to get " + family + " which is not supported.");
    }

    public static Distribution getDistribution(Model.Parameters params) {
        DistributionFamily family = params._distribution;
        switch (family) {
            case bernoulli: {
                return new BernoulliDistribution(family);
            }
            case quasibinomial: {
                return new QuasibinomialDistribution(family);
            }
            case modified_huber: {
                return new ModifiedHuberDistribution(family);
            }
            case multinomial: {
                return new MultinomialDistribution(family);
            }
            case AUTO: 
            case gaussian: {
                return new GaussianDistribution(family);
            }
            case poisson: {
                return new PoissonDistribution(family);
            }
            case gamma: {
                return new GammaDistribution(family);
            }
            case laplace: {
                return new LaplaceDistribution(family);
            }
            case tweedie: {
                return new TweedieDistribution(params);
            }
            case huber: {
                return new HuberDistribution(params);
            }
            case quantile: {
                return new QuantileDistribution(params);
            }
            case custom: {
                return CustomDistribution.getCustomDistribution(params);
            }
        }
        throw H2O.unimpl("Try to get " + family + " which is not supported.");
    }
}

