/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.AUUC;
import hex.CustomMetric;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsSupervised;
import java.util.Arrays;
import water.Key;
import water.MRTask;
import water.Scope;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.C8DVolatileChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;

public class ModelMetricsBinomialUplift
extends ModelMetricsSupervised {
    public final AUUC _auuc;

    public ModelMetricsBinomialUplift(Model model, Frame frame, long nobs, String[] domain, double sigma, AUUC auuc, CustomMetric customMetric) {
        super(model, frame, nobs, 0.0, domain, sigma, customMetric);
        this._auuc = auuc;
    }

    public static ModelMetricsBinomialUplift getFromDKV(Model model, Frame frame) {
        ModelMetrics mm = ModelMetrics.getFromDKV(model, frame);
        if (!(mm instanceof ModelMetricsBinomialUplift)) {
            throw new H2OIllegalArgumentException("Expected to find a Binomial ModelMetrics for model: " + model._key.toString() + " and frame: " + frame._key.toString(), "Expected to find a ModelMetricsBinomial for model: " + model._key.toString() + " and frame: " + frame._key.toString() + " but found a: " + (mm == null ? null : mm.getClass()));
        }
        return (ModelMetricsBinomialUplift)mm;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this._auuc != null) {
            sb.append("Default AUUC: ").append((float)this._auuc.auuc()).append("\n");
            sb.append("Qini AUUC: ").append((float)this._auuc.auucByType(AUUC.AUUCType.qini)).append("\n");
            sb.append("Lift AUUC: ").append((float)this._auuc.auucByType(AUUC.AUUCType.lift)).append("\n");
            sb.append("Gain AUUC: ").append((float)this._auuc.auucByType(AUUC.AUUCType.gain)).append("\n");
        }
        return sb.toString();
    }

    public double auuc() {
        return this._auuc.auuc();
    }

    public double auucRandom() {
        return this._auuc.auucRandom();
    }

    public double qini() {
        return this._auuc.qini();
    }

    @Override
    protected StringBuilder appendToStringMetrics(StringBuilder sb) {
        return sb;
    }

    public static ModelMetricsBinomialUplift make(Vec targetClassProbs, Vec actualLabels, Vec treatment, AUUC.AUUCType auucType, int nbins) {
        return ModelMetricsBinomialUplift.make(targetClassProbs, actualLabels, treatment, actualLabels.domain(), auucType, nbins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelMetricsBinomialUplift make(Vec targetClassProbs, Vec actualLabels, Vec treatment, String[] domain, AUUC.AUUCType auucType, int auucNbins) {
        Scope.enter();
        try {
            Vec labels = actualLabels.toCategoricalVec();
            if (domain == null) {
                domain = labels.domain();
            }
            if (labels == null || targetClassProbs == null || treatment == null) {
                throw new IllegalArgumentException("Missing actualLabels or predictedProbs or treatment values for uplift binomial metrics!");
            }
            if (!targetClassProbs.isNumeric()) {
                throw new IllegalArgumentException("Predicted probabilities must be numeric per-class probabilities for uplift binomial metrics.");
            }
            if (domain.length != 2) {
                throw new IllegalArgumentException("Domain must have 2 class labels, but is " + Arrays.toString(domain) + " for uplift binomial metrics.");
            }
            if ((labels = labels.adaptTo(domain)).cardinality() != 2) {
                throw new IllegalArgumentException("Adapted domain must have 2 class labels, but is " + Arrays.toString(labels.domain()) + " for uplift binomial metrics.");
            }
            if (!treatment.isCategorical() || treatment.cardinality() != 2) {
                throw new IllegalArgumentException("Treatment values should be catecorical value and have 2 class " + Arrays.toString(treatment.domain()) + " for uplift binomial uplift metrics.");
            }
            long dataSize = treatment.length();
            if (auucNbins < -1 || auucNbins == 0 || (long)auucNbins > dataSize) {
                throw new IllegalArgumentException("The number of bins to calculate AUUC need to be -1 (default value) or higher than zero, but less than data size.");
            }
            if (auucNbins == -1) {
                auucNbins = 1000L > dataSize ? (int)dataSize : 1000;
            }
            Frame fr = new Frame(targetClassProbs);
            fr.add("labels", labels);
            fr.add("treatment", treatment);
            MetricBuilderBinomialUplift mb = ((UpliftBinomialMetrics)new UpliftBinomialMetrics((String[])labels.domain(), (double[])AUUC.calculateQuantileThresholds((int)auucNbins, (Vec)targetClassProbs)).doAll((Frame)fr))._mb;
            labels.remove();
            Frame preds = new Frame(targetClassProbs);
            ModelMetricsBinomialUplift mm = (ModelMetricsBinomialUplift)mb.makeModelMetrics(null, fr, preds, fr.vec("labels"), fr.vec("treatment"), auucType, auucNbins);
            mm._description = "Computed on user-given predictions and labels.";
            ModelMetricsBinomialUplift modelMetricsBinomialUplift = mm;
            return modelMetricsBinomialUplift;
        }
        finally {
            Scope.exit(new Key[0]);
        }
    }

    public static class MetricBuilderBinomialUplift
    extends ModelMetricsSupervised.MetricBuilderSupervised<MetricBuilderBinomialUplift> {
        protected AUUC.AUUCBuilder _auuc;

        public MetricBuilderBinomialUplift(String[] domain, double[] thresholds) {
            super(2, domain);
            if (thresholds != null) {
                this._auuc = new AUUC.AUUCBuilder(thresholds);
            }
        }

        public MetricBuilderBinomialUplift(String[] domain) {
            super(2, domain);
        }

        @Override
        public double[] perRow(double[] ds, float[] yact, Model m) {
            return this.perRow(ds, yact, 1.0, 0.0, m);
        }

        @Override
        public double[] perRow(double[] ds, float[] yact, double weight, double offset, Model m) {
            assert (this._auuc == null || yact.length == 2) : "Treatment must be included in `yact` when calculating AUUC";
            if (Float.isNaN(yact[0])) {
                return ds;
            }
            if (ArrayUtils.hasNaNs(ds)) {
                return ds;
            }
            if (weight == 0.0 || Double.isNaN(weight)) {
                return ds;
            }
            int y = (int)yact[0];
            if (y != 0 && y != 1) {
                return ds;
            }
            this._wY += weight * (double)y;
            this._wYY += weight * (double)y * (double)y;
            ++this._count;
            this._wcount += weight;
            if (this._auuc != null) {
                float treatment = yact[1];
                this._auuc.perRow(ds[0], weight, y, treatment);
            }
            return ds;
        }

        @Override
        public void reduce(MetricBuilderBinomialUplift mb) {
            super.reduce(mb);
            if (this._auuc != null) {
                this._auuc.reduce(mb._auuc);
            }
        }

        @Override
        public ModelMetrics makeModelMetrics(Model m, Frame f, Frame frameWithExtraColumns, Frame preds) {
            AUUC.AUUCType auucType;
            Vec resp = null;
            Vec treatment = null;
            AUUC.AUUCType aUUCType = auucType = m == null ? AUUC.AUUCType.AUTO : ((Model.Parameters)m._parms)._auuc_type;
            if (preds != null) {
                if (frameWithExtraColumns == null) {
                    frameWithExtraColumns = f;
                }
                Vec vec = resp = m == null && frameWithExtraColumns.vec(f.numCols() - 1).isCategorical() ? frameWithExtraColumns.vec(f.numCols() - 1) : frameWithExtraColumns.vec(((Model.Parameters)m._parms)._response_column);
                if (m != null && ((Model.Parameters)m._parms)._treatment_column != null) {
                    treatment = frameWithExtraColumns.vec(((Model.Parameters)m._parms)._treatment_column);
                }
            }
            int auucNbins = m == null || ((Model.Parameters)m._parms)._auuc_nbins == -1 ? 1000 : ((Model.Parameters)m._parms)._auuc_nbins;
            return this.makeModelMetrics(m, f, preds, resp, treatment, auucType, auucNbins);
        }

        private ModelMetrics makeModelMetrics(Model m, Frame f, Frame preds, Vec resp, Vec treatment, AUUC.AUUCType auucType, int nbins) {
            AUUC auuc = null;
            if (preds != null && resp != null) {
                auuc = this._auuc == null ? new AUUC(preds.vec(0), resp, treatment, auucType, nbins) : new AUUC(this._auuc, auucType);
            }
            return this.makeModelMetrics(m, f, auuc);
        }

        private ModelMetrics makeModelMetrics(Model m, Frame f, AUUC auuc) {
            double sigma = Double.NaN;
            if (auuc == null) {
                sigma = this.weightedSigma();
                auuc = new AUUC(this._auuc, ((Model.Parameters)m._parms)._auuc_type);
            }
            ModelMetricsBinomialUplift mm = new ModelMetricsBinomialUplift(m, f, this._count, this._domain, sigma, auuc, this._customMetric);
            if (m != null) {
                m.addModelMetrics(mm);
            }
            return mm;
        }

        @Override
        public Frame makePredictionCache(Model m, Vec response) {
            return new Frame(response.makeVolatileDoubles(1));
        }

        @Override
        public void cachePrediction(double[] cdist, Chunk[] chks, int row, int cacheChunkIdx, Model m) {
            assert (cdist.length == 3);
            ((C8DVolatileChunk)chks[cacheChunkIdx]).getValues()[row] = cdist[0];
        }

        public String toString() {
            return "";
        }
    }

    private static class UpliftBinomialMetrics
    extends MRTask<UpliftBinomialMetrics> {
        String[] domain;
        double[] thresholds;
        public MetricBuilderBinomialUplift _mb;

        public UpliftBinomialMetrics(String[] domain, double[] thresholds) {
            this.domain = domain;
            this.thresholds = thresholds;
        }

        @Override
        public void map(Chunk[] chks) {
            this._mb = new MetricBuilderBinomialUplift(this.domain, this.thresholds);
            Chunk uplift = chks[0];
            Chunk actuals = chks[1];
            Chunk treatment = chks[2];
            double[] ds = new double[1];
            float[] acts = new float[2];
            for (int i = 0; i < chks[0]._len; ++i) {
                ds[0] = uplift.atd(i);
                acts[0] = (float)actuals.atd(i);
                acts[1] = (float)treatment.atd(i);
                this._mb.perRow(ds, acts, 1.0, 0.0, null);
            }
        }

        @Override
        public void reduce(UpliftBinomialMetrics mrt) {
            this._mb.reduce(mrt._mb);
        }
    }
}

