/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.transforms;

import water.DKV;
import water.H2O;
import water.Key;
import water.Scope;
import water.fvec.Frame;
import water.rapids.Session;
import water.rapids.ast.AstParameter;
import water.rapids.ast.params.AstId;
import water.rapids.ast.params.AstStr;
import water.rapids.ast.params.AstStrList;
import water.rapids.transforms.Transform;

public class H2OColSelect
extends Transform<H2OColSelect> {
    private final String[] _cols;

    public H2OColSelect(String name, String ast, boolean inplace, String[] newNames) {
        super(name, ast, inplace, newNames);
        AstParameter cols = (AstParameter)this._ast._asts[2];
        this._cols = cols instanceof AstStrList ? ((AstStrList)cols)._strs : (cols instanceof AstStr ? new String[]{((AstStr)cols).getStr()} : null);
    }

    @Override
    public Transform<H2OColSelect> fit(Frame f) {
        return this;
    }

    @Override
    protected Frame transformImpl(Frame f) {
        this._ast._asts[1] = new AstId(f);
        Session ses = new Session();
        Frame fr = ses.exec(this._ast, null).getFrame();
        if (fr._key == null) {
            fr = new Frame(Key.make("H2OColSelect_" + f._key.toString()), fr.names(), fr.vecs());
        }
        Scope.track(fr);
        DKV.put(fr);
        return fr;
    }

    @Override
    Frame inverseTransform(Frame f) {
        throw H2O.unimpl();
    }

    @Override
    public String genClassImpl() {
        StringBuilder sb = new StringBuilder();
        sb.append("    @Override public RowData transform(RowData row) {\n");
        sb.append("      RowData colSelect = new RowData();\n");
        for (String s : this._cols) {
            sb.append("      colSelect.put(\"" + s + "\", row.get(\"" + s + "\"));\n");
        }
        sb.append("      return colSelect;\n").append("    }\n");
        return sb.toString();
    }
}

